/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.PeerException;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.Message;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerStatatistic;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.relay.RelayRPC;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayForwarderRPC
extends DispatchHandler
implements PeerStatusListener {
    private static final Logger LOG = LoggerFactory.getLogger(RelayForwarderRPC.class);
    private final PeerConnection peerConnection;
    private List<Map<Number160, PeerStatatistic>> peerMap = null;
    private volatile PeerAddress unreachablePeer;
    private final RelayRPC relayRPC;

    public RelayForwarderRPC(PeerConnection peerConnection, final Peer peer, RelayRPC relayRPC) {
        super(peer.peerBean(), peer.connectionBean());
        this.peerConnection = peerConnection.changeRemotePeer(peerConnection.remotePeer().changeRelayed(true));
        peerConnection.closeFuture().addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Void>>(){

            public void operationComplete(FutureDone<Void> future) throws Exception {
                peer.peerBean().removePeerStatusListeners((PeerStatusListener)RelayForwarderRPC.this);
                peer.connectionBean().dispatcher().removeIoHandler(RelayForwarderRPC.this.unreachablePeer.peerId());
            }
        });
        this.unreachablePeer = peerConnection.remotePeer().changeRelayed(true);
        this.relayRPC = relayRPC;
        LOG.debug("created forwarder from peer {} to peer {}", (Object)peer.peerAddress(), (Object)this.unreachablePeer);
    }

    public boolean peerFailed(PeerAddress remotePeer, PeerException exception) {
        return false;
    }

    public boolean peerFound(PeerAddress remotePeer, PeerAddress referrer, PeerConnection peerConnection2) {
        boolean firstHand = referrer == null;
        boolean secondHand = remotePeer.equals((Object)referrer);
        boolean samePeerConnection = this.peerConnection.equals((Object)peerConnection2);
        if ((firstHand || secondHand && samePeerConnection) && remotePeer.peerId().equals((Object)this.unreachablePeer.peerId()) && remotePeer.isRelayed()) {
            LOG.debug("update the unreachable peer to {} based on {}, ref {}", new Object[]{this.unreachablePeer, remotePeer, referrer});
            this.unreachablePeer = remotePeer;
        }
        return false;
    }

    public void register(Peer peer) {
        for (RPC.Commands command : RPC.Commands.values()) {
            if (command == RPC.Commands.RELAY) continue;
            peer.connectionBean().dispatcher().registerIoHandler(this.unreachablePeer.peerId(), (DispatchHandler)this, new int[]{command.getNr()});
        }
        peer.peerBean().addPeerStatusListeners((PeerStatusListener)this);
    }

    public static void register(PeerConnection peerConnection, Peer peer, RelayRPC relayRPC) {
        RelayForwarderRPC relayForwarderRPC = new RelayForwarderRPC(peerConnection, peer, relayRPC);
        relayForwarderRPC.register(peer);
    }

    public static RelayForwarderRPC find(Peer peer, Number160 peerId) {
        return (RelayForwarderRPC)peer.connectionBean().dispatcher().searchHandler(peerId, (int)RPC.Commands.NEIGHBOR.getNr());
    }

    public void handleResponse(Message message, PeerConnection peerConnectionUnused, boolean sign, Responder responder) throws Exception {
        PeerAddress sender = this.unreachablePeer;
        if (message.command() == RPC.Commands.PING.getNr()) {
            LOG.debug("Received message {} to handle ping for unreachable peer {}", (Object)message, (Object)this.unreachablePeer);
            this.handlePing(message, responder, sender);
        } else if (message.command() == RPC.Commands.NEIGHBOR.getNr()) {
            LOG.debug("Received message {} to handle neighbor request for unreachable peer {}", (Object)message, (Object)this.unreachablePeer);
            this.handleNeigbhor(message, responder, sender);
        } else {
            LOG.debug("Received message {} to forward to unreachable peer {}", (Object)message, (Object)this.unreachablePeer);
            this.handleRelay(message, responder, sender);
        }
    }

    private void handleRelay(final Message message, final Responder responder, final PeerAddress sender) throws InvalidKeyException, SignatureException, IOException {
        message.restoreContentReferences();
        Buffer buf = RelayUtils.encodeMessage(message);
        FutureResponse fr = this.relayRPC.forwardMessage(this.peerConnection, buf);
        fr.addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

            public void operationComplete(FutureResponse future) throws Exception {
                if (future.isSuccess()) {
                    Buffer buffer = future.responseMessage().buffer(0);
                    Message responseFromUnreachablePeer = RelayUtils.decodeMessage(buffer, message.recipientSocket(), message.senderSocket());
                    responseFromUnreachablePeer.restoreContentReferences();
                    responseFromUnreachablePeer.sender(sender);
                    responseFromUnreachablePeer.recipient(message.sender());
                    LOG.debug("response from unreachable peer: {}", (Object)responseFromUnreachablePeer);
                    responder.response(responseFromUnreachablePeer);
                } else {
                    responder.failed(Message.Type.USER1, "Relaying message failed: " + future.failedReason());
                }
            }
        });
    }

    private void handlePing(Message message, Responder responder, PeerAddress sender) {
        LOG.debug("peerconnection open? {}", (Object)this.peerConnection.isOpen());
        Message response = RelayForwarderRPC.createResponseMessage((Message)message, (Message.Type)(this.peerConnection.isOpen() ? Message.Type.OK : Message.Type.EXCEPTION), (PeerAddress)sender);
        responder.response(response);
    }

    public void handleNeigbhor(Message message, Responder responder, PeerAddress sender) throws IOException {
        if (message.keyList().size() < 2) {
            throw new IllegalArgumentException("We need the location and domain key at least");
        }
        if (message.type() != Message.Type.REQUEST_1 && message.type() != Message.Type.REQUEST_2 && message.type() != Message.Type.REQUEST_3 && message.type() != Message.Type.REQUEST_4 && message.command() == RPC.Commands.NEIGHBOR.getNr()) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        Number160 locationKey = message.key(0);
        SortedSet<PeerAddress> neighbors = this.neighbors(locationKey, 30);
        if (neighbors == null) {
            Message response = RelayForwarderRPC.createResponseMessage((Message)message, (Message.Type)Message.Type.NOT_FOUND, (PeerAddress)sender);
            response.neighborsSet(new NeighborSet(-1, Collections.emptyList()));
            responder.response(response);
            return;
        }
        Message responseMessage = RelayForwarderRPC.createResponseMessage((Message)message, (Message.Type)Message.Type.OK, (PeerAddress)sender);
        LOG.debug("found the following neighbors {}", neighbors);
        NeighborSet neighborSet = new NeighborSet(1000, neighbors);
        responseMessage.neighborsSet(neighborSet);
        responder.response(responseMessage);
    }

    private SortedSet<PeerAddress> neighbors(Number160 id, int atLeast) {
        LOG.trace("Answering routing request on behalf of unreachable peer {}, neighbors of {}", (Object)this.unreachablePeer, (Object)id);
        if (this.peerMap == null) {
            return null;
        }
        return PeerMap.closePeers((Number160)this.unreachablePeer.peerId(), (Number160)id, (int)30, this.peerMap);
    }

    public Collection<PeerAddress> all() {
        ArrayList<PeerStatatistic> result1 = new ArrayList<PeerStatatistic>();
        for (Map<Number160, PeerStatatistic> map : this.peerMap) {
            result1.addAll(map.values());
        }
        ArrayList<PeerAddress> result2 = new ArrayList<PeerAddress>();
        for (PeerStatatistic peerStatatistic : result1) {
            result2.add(peerStatatistic.peerAddress());
        }
        return result2;
    }

    public void setMap(List<Map<Number160, PeerStatatistic>> peerMap) {
        this.peerMap = peerMap;
    }
}

