/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.nat;

import java.util.Collection;
import java.util.List;
import java.util.TimerTask;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.p2p.builder.BootstrapBuilder;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.DistributedRelay;
import net.tomp2p.relay.FutureRelay;
import net.tomp2p.relay.RelayRPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PeerMapUpdateTask
extends TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(PeerMapUpdateTask.class);
    private final RelayRPC relayRPC;
    private final BootstrapBuilder bootstrapBuilder;
    private final DistributedRelay distributedRelay;
    private final Collection<PeerAddress> manualRelays;
    private final int maxFail;

    public PeerMapUpdateTask(RelayRPC relayRPC, BootstrapBuilder bootstrapBuilder, DistributedRelay distributedRelay, Collection<PeerAddress> manualRelays, int maxFail) {
        this.relayRPC = relayRPC;
        this.bootstrapBuilder = bootstrapBuilder;
        this.distributedRelay = distributedRelay;
        this.manualRelays = manualRelays;
        this.maxFail = maxFail;
    }

    @Override
    public void run() {
        if (this.relayRPC.peer().isShutdown() || !this.relayRPC.peer().peerAddress().isRelayed()) {
            this.cancel();
            return;
        }
        FutureBootstrap fb = this.bootstrapBuilder.start();
        fb.addListener((BaseFutureListener)new BaseFutureAdapter<FutureBootstrap>(){

            public void operationComplete(FutureBootstrap future) throws Exception {
                if (future.isSuccess()) {
                    List peerMapVerified = PeerMapUpdateTask.this.relayRPC.peer().peerBean().peerMap().peerMapVerified();
                    for (final PeerConnection pc : PeerMapUpdateTask.this.distributedRelay.relayAddresses()) {
                        FutureResponse fr = PeerMapUpdateTask.this.relayRPC.sendPeerMap(pc.remotePeer(), peerMapVerified, pc);
                        fr.addListener((BaseFutureListener)new BaseFutureAdapter<BaseFuture>(){

                            public void operationComplete(BaseFuture future) throws Exception {
                                if (future.isFailed()) {
                                    LOG.warn("failed to update peer map on relay peer {}: {}", (Object)pc.remotePeer(), (Object)future.failedReason());
                                } else {
                                    LOG.trace("Updated peer map on relay {}", (Object)pc.remotePeer());
                                }
                            }
                        });
                    }
                }
            }
        });
        FutureRelay futureRelay2 = new FutureRelay();
        this.distributedRelay.setupRelays(futureRelay2, this.manualRelays, this.maxFail);
        this.distributedRelay.peer().notifyAutomaticFutures((BaseFuture)futureRelay2);
    }
}

