/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.nat;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.Ports;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.futures.FutureDiscover;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.nat.FutureNAT;
import net.tomp2p.nat.FutureRelayNAT;
import net.tomp2p.nat.NATUtils;
import net.tomp2p.nat.PeerMapUpdateTask;
import net.tomp2p.natpmp.NatPmpException;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.Shutdown;
import net.tomp2p.p2p.builder.BootstrapBuilder;
import net.tomp2p.p2p.builder.DiscoverBuilder;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.DistributedRelay;
import net.tomp2p.relay.FutureRelay;
import net.tomp2p.relay.RelayListener;
import net.tomp2p.relay.RelayRPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerNAT {
    private static final Logger LOG = LoggerFactory.getLogger(PeerNAT.class);
    private final Peer peer;
    private final NATUtils natUtils;
    private final RelayRPC relayRPC;
    private BootstrapBuilder bootstrapBuilder;
    private int peerMapUpdateInterval = 5;
    private int failedRelayWaitTime = 60;
    private int minRelays = 2;
    private int maxFail = 2;
    private Collection<PeerAddress> relays;

    public PeerNAT(Peer peer) {
        this.peer = peer;
        this.natUtils = new NATUtils();
        this.relayRPC = new RelayRPC(peer);
        peer.addShutdownListener(new Shutdown(){

            public BaseFuture shutdown() {
                PeerNAT.this.natUtils.shutdown();
                return new FutureDone().done();
            }
        });
    }

    public RelayRPC relayRPC() {
        return this.relayRPC;
    }

    public FutureNAT startSetupPortforwarding(final FutureDiscover futureDiscover) {
        final FutureNAT futureNAT = new FutureNAT();
        futureDiscover.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDiscover>(){

            public void operationComplete(FutureDiscover future) throws Exception {
                if (future.reporter() != null) {
                    futureNAT.discoverPeer(future.reporter());
                }
                if (future.isFailed() && future.isNat()) {
                    Ports externalPorts = PeerNAT.this.setupPortforwarding(future.internalAddress().getHostAddress());
                    if (externalPorts != null) {
                        PeerAddress serverAddress = PeerNAT.this.peer.peerBean().serverPeerAddress();
                        serverAddress = serverAddress.changePorts(externalPorts.tcpPort(), externalPorts.udpPort());
                        serverAddress = serverAddress.changeAddress(future.externalAddress());
                        PeerNAT.this.peer.peerBean().serverPeerAddress(serverAddress);
                        DiscoverBuilder builder = new DiscoverBuilder(PeerNAT.this.peer).peerAddress(futureNAT.discoverPeer());
                        builder.start().addListener((BaseFutureListener)new BaseFutureAdapter<FutureDiscover>(){

                            public void operationComplete(FutureDiscover future) throws Exception {
                                if (future.isSuccess()) {
                                    futureNAT.done(future.peerAddress(), future.reporter());
                                } else {
                                    PeerAddress pa = PeerNAT.this.peer.peerBean().serverPeerAddress().changeFirewalledTCP(true).changeFirewalledUDP(true);
                                    PeerNAT.this.peer.peerBean().serverPeerAddress(pa);
                                    futureNAT.failed((BaseFuture)future);
                                }
                            }
                        });
                    } else {
                        PeerAddress pa = PeerNAT.this.peer.peerBean().serverPeerAddress().changeFirewalledTCP(true).changeFirewalledUDP(true);
                        PeerNAT.this.peer.peerBean().serverPeerAddress(pa);
                        futureNAT.failed("could not setup NAT");
                    }
                } else {
                    LOG.info("nothing to do, you are reachable from outside");
                    futureNAT.done(futureDiscover.peerAddress(), futureDiscover.reporter());
                }
            }
        });
        return futureNAT;
    }

    public Ports setupPortforwarding(String internalHost) {
        boolean success;
        Ports ports;
        block8: {
            ports = new Ports();
            try {
                success = this.natUtils.mapUPNP(internalHost, this.peer.peerAddress().tcpPort(), this.peer.peerAddress().udpPort(), ports.udpPort(), ports.tcpPort());
            }
            catch (Exception e) {
                success = false;
            }
            if (!success) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("cannot find UPNP devices");
                }
                try {
                    success = this.natUtils.mapPMP(this.peer.peerAddress().tcpPort(), this.peer.peerAddress().udpPort(), ports.udpPort(), ports.tcpPort());
                    if (!success && LOG.isWarnEnabled()) {
                        LOG.warn("cannot find NAT-PMP devices");
                    }
                }
                catch (NatPmpException e1) {
                    if (!LOG.isWarnEnabled()) break block8;
                    LOG.warn("cannot find NAT-PMP devices ", (Throwable)e1);
                }
            }
        }
        if (success) {
            return ports;
        }
        return null;
    }

    public FutureRelay startSetupRelay(FutureNAT futureNAT) {
        final FutureRelay futureRelay = new FutureRelay();
        if (futureNAT == null) {
            this.startSetupRelay(futureRelay);
            return futureRelay;
        }
        futureNAT.addListener((BaseFutureListener)new BaseFutureAdapter<FutureNAT>(){

            public void operationComplete(FutureNAT future) throws Exception {
                if (future.isSuccess()) {
                    futureRelay.nothingTodo();
                } else {
                    PeerNAT.this.startSetupRelay(futureRelay);
                }
            }
        });
        return futureRelay;
    }

    public FutureRelay startSetupRelay() {
        FutureRelay futureRelay = new FutureRelay();
        this.startSetupRelay(futureRelay);
        return futureRelay;
    }

    private void startSetupRelay(FutureRelay futureRelay) {
        final DistributedRelay distributedRelay = new DistributedRelay(this.peer, this.relayRPC, this.failedRelayWaitTime());
        this.peer.addShutdownListener(new Shutdown(){

            public BaseFuture shutdown() {
                return distributedRelay.shutdown();
            }
        });
        distributedRelay.addRelayListener(new RelayListener(){

            @Override
            public void relayFailed(DistributedRelay distributedRelay, PeerConnection peerConnection) {
                FutureRelay futureRelay2 = new FutureRelay(1);
                futureRelay2.distributedRelay(distributedRelay);
                distributedRelay.setupRelays(futureRelay2, PeerNAT.this.relays, PeerNAT.this.minRelays, PeerNAT.this.maxFail);
                PeerNAT.this.peer.notifyAutomaticFutures((BaseFuture)futureRelay2);
            }
        });
        distributedRelay.setupRelays(futureRelay, this.relays, this.minRelays, this.maxFail);
        futureRelay.distributedRelay(distributedRelay);
    }

    public Shutdown startRelayMaintenance(FutureRelay futureRelay) {
        if (this.bootstrapBuilder() == null) {
            throw new IllegalArgumentException("you need to set bootstrap builder first with PeerNAT.bootstrapBuilder()");
        }
        final PeerMapUpdateTask peerMapUpdateTask = new PeerMapUpdateTask(this.relayRPC, this.bootstrapBuilder(), futureRelay.distributedRelay());
        this.peer.connectionBean().timer().scheduleAtFixedRate(peerMapUpdateTask, 0L, this.peerMapUpdateInterval(), TimeUnit.SECONDS);
        final Shutdown shutdown = new Shutdown(){

            public BaseFuture shutdown() {
                peerMapUpdateTask.cancel();
                return new FutureDone().done();
            }
        };
        this.peer.addShutdownListener(shutdown);
        return new Shutdown(){

            public BaseFuture shutdown() {
                peerMapUpdateTask.cancel();
                PeerNAT.this.peer.removeShutdownListener(shutdown);
                return new FutureDone().done();
            }
        };
    }

    public FutureRelayNAT startRelay() {
        return this.startRelay(null);
    }

    public FutureRelayNAT startRelay(final FutureNAT futureNAT) {
        if (this.bootstrapBuilder() == null) {
            if (futureNAT.reporter() != null) {
                this.bootstrapBuilder(this.peer.bootstrap().peerAddress(futureNAT.reporter()));
            } else if (futureNAT.discoverPeer() != null) {
                this.bootstrapBuilder(this.peer.bootstrap().peerAddress(futureNAT.discoverPeer()));
            } else {
                throw new IllegalArgumentException("you need to set bootstrap builder first with PeerNAT.bootstrapBuilder()");
            }
        }
        final FutureRelayNAT futureBootstrapNAT = new FutureRelayNAT();
        PeerAddress upa = this.peer.peerBean().serverPeerAddress();
        upa = upa.changeFirewalledTCP(true).changeFirewalledUDP(true);
        this.peer.peerBean().serverPeerAddress(upa);
        FutureBootstrap futureBootstrap = this.bootstrapBuilder().start();
        futureBootstrapNAT.futureBootstrap0(futureBootstrap);
        futureBootstrap.addListener((BaseFutureListener)new BaseFutureAdapter<FutureBootstrap>(){

            public void operationComplete(FutureBootstrap future) throws Exception {
                if (future.isSuccess()) {
                    final FutureRelay futureRelay = PeerNAT.this.startSetupRelay(futureNAT);
                    futureBootstrapNAT.futureRelay(futureRelay);
                    futureRelay.addListener((BaseFutureListener)new BaseFutureAdapter<FutureRelay>(){

                        public void operationComplete(FutureRelay future) throws Exception {
                            if (future.isSuccess()) {
                                FutureBootstrap futureBootstrap = PeerNAT.this.bootstrapBuilder().start();
                                futureBootstrapNAT.futureBootstrap1(futureBootstrap);
                                futureBootstrap.addListener((BaseFutureListener)new BaseFutureAdapter<FutureBootstrap>(){

                                    public void operationComplete(FutureBootstrap future) throws Exception {
                                        if (future.isSuccess()) {
                                            Shutdown shutdown = PeerNAT.this.startRelayMaintenance(futureRelay);
                                            futureBootstrapNAT.done(shutdown);
                                        } else {
                                            futureBootstrapNAT.failed((BaseFuture)future);
                                        }
                                    }
                                });
                            } else {
                                futureBootstrapNAT.failed((BaseFuture)future);
                            }
                        }
                    });
                } else {
                    futureBootstrapNAT.failed((BaseFuture)future);
                }
            }
        });
        return futureBootstrapNAT;
    }

    public PeerNAT failedRelayWaitTime(int failedRelayWaitTime) {
        this.failedRelayWaitTime = failedRelayWaitTime;
        return this;
    }

    public int failedRelayWaitTime() {
        return this.failedRelayWaitTime;
    }

    public PeerNAT minRelays(int minRelays) {
        this.minRelays = minRelays;
        return this;
    }

    public int minRelays() {
        return this.minRelays;
    }

    public PeerNAT maxFail(int maxFail) {
        this.maxFail = maxFail;
        return this;
    }

    public int maxFail() {
        return this.maxFail;
    }

    public PeerNAT peerMapUpdateInterval(int peerMapUpdateInterval) {
        this.peerMapUpdateInterval = peerMapUpdateInterval;
        return this;
    }

    public int peerMapUpdateInterval() {
        return this.peerMapUpdateInterval;
    }

    public PeerNAT bootstrapBuilder(BootstrapBuilder bootstrapBuilder) {
        this.bootstrapBuilder = bootstrapBuilder;
        return this;
    }

    public PeerNAT bootstrapBuilder(PeerAddress peerAddress) {
        this.bootstrapBuilder = this.peer.bootstrap().peerAddress(peerAddress);
        return this;
    }

    public BootstrapBuilder bootstrapBuilder() {
        return this.bootstrapBuilder;
    }

    public Collection<PeerAddress> relays() {
        return this.relays;
    }

    public PeerNAT relays(Collection<PeerAddress> relays) {
        this.relays = relays;
        return this;
    }
}

