/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.upnp;

import net.tomp2p.upnp.Action;
import net.tomp2p.upnp.ActionMessage;
import net.tomp2p.upnp.Service;
import net.tomp2p.upnp.StateVariable;
import net.tomp2p.upnp.StateVariableMessage;

public class UPNPMessageFactory {
    public final Service service;

    public UPNPMessageFactory(Service service) {
        this.service = service;
    }

    public ActionMessage getMessage(String serviceActionName) {
        Action serviceAction = this.service.getUPNPServiceAction(serviceActionName);
        if (serviceAction != null) {
            return new ActionMessage(this.service, serviceAction);
        }
        return null;
    }

    public StateVariableMessage getStateVariableMessage(String serviceStateVariable) {
        StateVariable stateVar = this.service.getUPNPServiceStateVariable(serviceStateVariable);
        if (stateVar != null) {
            return new StateVariableMessage(this.service, stateVar);
        }
        return null;
    }
}

