/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.upnp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import net.tomp2p.upnp.Service;
import net.tomp2p.upnp.XMLUtil;
import org.w3c.dom.Node;

public class Device {
    public final String deviceType;
    public final String friendlyName;
    public final String manufacturer;
    public final URL manufacturerURL;
    public final URL presentationURL;
    public final String modelDescription;
    public final String modelName;
    public final String modelNumber;
    public final String modelURL;
    public final String serialNumber;
    public final String UDN;
    public final String USN;
    public final long UPC;
    public final Service[] services;
    public final Device[] childDevices;
    public final Device parent;

    public Device(Node deviceCtx, Device parent, URL urlBase) {
        this.deviceType = Device.getMandatoryData(deviceCtx, "deviceType");
        this.friendlyName = Device.getMandatoryData(deviceCtx, "friendlyName");
        this.manufacturer = this.getNonMandatoryData(deviceCtx, "manufacturer");
        URL url = null;
        try {
            url = new URL(this.getNonMandatoryData(deviceCtx, "manufacturerURL"));
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        this.manufacturerURL = url;
        url = null;
        try {
            url = Device.getURL(this.getNonMandatoryData(deviceCtx, "presentationURL"), urlBase);
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        this.presentationURL = url;
        this.modelDescription = this.getNonMandatoryData(deviceCtx, "modelDescription");
        this.modelName = Device.getMandatoryData(deviceCtx, "modelName");
        this.modelNumber = this.getNonMandatoryData(deviceCtx, "modelNumber");
        this.modelURL = this.getNonMandatoryData(deviceCtx, "modelURL");
        this.serialNumber = this.getNonMandatoryData(deviceCtx, "serialNumber");
        this.UDN = Device.getMandatoryData(deviceCtx, "UDN");
        this.USN = this.UDN.concat("::").concat(this.deviceType);
        String tmp = this.getNonMandatoryData(deviceCtx, "UPC");
        long l = -1L;
        if (tmp != null) {
            try {
                l = Long.parseLong(tmp);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.UPC = l;
        this.parent = parent;
        ArrayList<Service> sList = new ArrayList<Service>();
        try {
            Node serviceList = (Node)XMLUtil.xpath.evaluate("serviceList", deviceCtx, XPathConstants.NODE);
            int serviceCount = Integer.parseInt(XMLUtil.xpath.evaluate("count( service )", serviceList));
            for (int i = 1; i <= serviceCount; ++i) {
                Node serviceXML = (Node)XMLUtil.xpath.evaluate("service[" + i + "]", serviceList, XPathConstants.NODE);
                try {
                    sList.add(new Service(serviceXML, urlBase, this));
                    continue;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        this.services = sList.toArray(new Service[sList.size()]);
        ArrayList<Device> children = new ArrayList<Device>();
        try {
            Node devList = (Node)XMLUtil.xpath.evaluate("deviceList", deviceCtx, XPathConstants.NODE);
            int devCount = Integer.parseInt(XMLUtil.xpath.evaluate("count( device )", devList));
            for (int i = 1; i <= devCount; ++i) {
                Node devXML = (Node)XMLUtil.xpath.evaluate("device[" + i + "]", devList, XPathConstants.NODE);
                Device d = new Device(devXML, this, urlBase);
                children.add(d);
            }
        }
        catch (XPathExpressionException e) {
            // empty catch block
        }
        this.childDevices = children.toArray(new Device[children.size()]);
    }

    private String getNonMandatoryData(Node ctx, String ctxFieldName) {
        String value = null;
        try {
            value = XMLUtil.xpath.evaluate(ctxFieldName, ctx);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        if (value != null && value.length() == 0) {
            value = null;
        }
        return value;
    }

    private static String getMandatoryData(Node ctx, String ctxFieldName) {
        String value = null;
        try {
            value = XMLUtil.xpath.evaluate(ctxFieldName, ctx);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        if (value != null && value.length() == 0) {
            throw new RuntimeException("Mandatory field " + ctxFieldName + " not provided, uncompliant UPNP device !!");
        }
        return value;
    }

    public static final URL getURL(String url, URL baseURL) throws MalformedURLException {
        URL rtrVal;
        if (url == null || url.trim().length() == 0) {
            return null;
        }
        try {
            rtrVal = new URL(url);
        }
        catch (MalformedURLException malEx) {
            if (baseURL != null) {
                if ((url = url.replace('\\', '/')).charAt(0) != '/') {
                    String externalForm = baseURL.toExternalForm();
                    if (!externalForm.endsWith("/")) {
                        externalForm = externalForm + "/";
                    }
                    rtrVal = new URL(externalForm + url);
                } else {
                    String URLRoot = baseURL.getProtocol() + "://" + baseURL.getHost() + ":" + baseURL.getPort();
                    rtrVal = new URL(URLRoot + url);
                }
            }
            throw malEx;
        }
        return rtrVal;
    }

    public List<Device> getChildDevices() {
        if (this.childDevices == null) {
            return null;
        }
        ArrayList<Device> rtrVal = new ArrayList<Device>();
        for (Device device : this.childDevices) {
            rtrVal.add(device);
            List<Device> found = device.getChildDevices();
            if (found == null) continue;
            rtrVal.addAll(found);
        }
        return rtrVal;
    }

    public Device getDirectParent() {
        return this.parent;
    }

    public Device getChildDevice(String deviceURI) {
        if (this.deviceType.equals(deviceURI)) {
            return this;
        }
        if (this.childDevices == null) {
            return null;
        }
        for (Device device : this.childDevices) {
            Device found = device.getChildDevice(deviceURI);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public Service getService(String serviceURI) {
        if (this.services == null) {
            return null;
        }
        for (Service service : this.services) {
            if (!service.serviceType.equals(serviceURI)) continue;
            return service;
        }
        return null;
    }

    public Service getServiceByID(String serviceID) {
        if (this.services == null) {
            return null;
        }
        for (Service service : this.services) {
            if (!service.serviceId.equals(serviceID)) continue;
            return service;
        }
        return null;
    }

    public List<Service> getServices(String serviceURI) {
        if (this.services == null) {
            return null;
        }
        ArrayList<Service> rtrVal = new ArrayList<Service>();
        for (Service service : this.services) {
            if (!service.serviceType.equals(serviceURI)) continue;
            rtrVal.add(service);
        }
        if (rtrVal.size() == 0) {
            return null;
        }
        return rtrVal;
    }

    public String toString() {
        String s;
        int i;
        StringBuilder b = new StringBuilder("UPNP device ").append(this.deviceType);
        b.append(" ").append(this.friendlyName);
        b.append("\n\t").append(this.manufacturer);
        b.append(" ").append(this.manufacturerURL);
        b.append(" ").append(this.presentationURL);
        b.append("\n\t").append(this.modelName);
        b.append(" ").append(this.modelNumber);
        b.append(" ").append(this.modelDescription);
        b.append(" ").append(this.modelURL);
        b.append("\n\t").append(this.serialNumber);
        b.append("\n\tServices:\n\t\t");
        for (i = 0; i < this.services.length; ++i) {
            s = this.services[i].toString();
            s = s.replaceAll("\n", "\n\t\t");
            b.append(s);
            b.append("\n\t\t");
        }
        b.append("\n\tDevices:\n\t\t");
        for (i = 0; i < this.childDevices.length; ++i) {
            s = this.childDevices[i].toString();
            s = s.replaceAll("\n", "\n\t");
            b.append(s);
            b.append("\n\t\t");
        }
        return b.toString();
    }
}

