/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FuturePeerConnection;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.relay.ConcurrentCacheSet;
import net.tomp2p.relay.FutureRelay;
import net.tomp2p.relay.RelayListener;
import net.tomp2p.relay.RelayRPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedRelay {
    static final Logger LOG = LoggerFactory.getLogger(DistributedRelay.class);
    private final Peer peer;
    private final RelayRPC relayRPC;
    private final Set<PeerConnection> relayAddresses;
    private final Set<PeerAddress> failedRelays;
    private final Collection<RelayListener> relayListeners = new ArrayList<RelayListener>(1);
    private final FutureChannelCreator futureChannelCreator;

    public DistributedRelay(Peer peer, RelayRPC relayRPC, int failedRelayWaitTime) {
        this.peer = peer;
        this.relayRPC = relayRPC;
        this.relayAddresses = new CopyOnWriteArraySet<PeerConnection>();
        this.failedRelays = new ConcurrentCacheSet<PeerAddress>(failedRelayWaitTime);
        this.futureChannelCreator = peer.getConnectionBean().reservation().create(0, 5);
    }

    public Collection<PeerConnection> relayAddresses() {
        return this.relayAddresses;
    }

    public DistributedRelay addRelayListener(RelayListener relayListener) {
        this.relayListeners.add(relayListener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureForkJoin<FutureDone<Void>> shutdown() {
        FutureDone[] futureDones = new FutureDone[this.relayAddresses.size() + 1];
        AtomicReferenceArray<FutureDone> futureDones2 = new AtomicReferenceArray<FutureDone>(futureDones);
        int i = 1;
        for (PeerConnection peerConnection : this.relayAddresses) {
            futureDones2.set(i++, peerConnection.close());
        }
        final FutureDone futureChannelShutdown = new FutureDone();
        futureDones2.set(0, futureChannelShutdown);
        DistributedRelay distributedRelay = this;
        synchronized (distributedRelay) {
            this.relayListeners.clear();
        }
        this.futureChannelCreator.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

            public void operationComplete(FutureChannelCreator future) throws Exception {
                future.channelCreator().shutdown().addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Void>>(){

                    public void operationComplete(FutureDone<Void> future) throws Exception {
                        futureChannelShutdown.setDone();
                    }
                });
            }
        });
        return new FutureForkJoin(futureDones2);
    }

    public FutureRelay setupRelays(final FutureRelay futureRelay, final Collection<PeerAddress> relays, final int successRelays, final int maxFail) {
        this.futureChannelCreator.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    Collection relayCandidates;
                    ChannelCreator cc = future.channelCreator();
                    if (relays == null) {
                        relayCandidates = DistributedRelay.this.relayCandidates();
                    } else {
                        relayCandidates = new ArrayList(relays);
                        DistributedRelay.this.filter(relayCandidates);
                    }
                    DistributedRelay.this.setupPeerConnections(futureRelay, cc, relayCandidates, successRelays, maxFail);
                } else {
                    futureRelay.setFailed((BaseFuture)future);
                }
            }
        });
        return futureRelay;
    }

    private Set<PeerAddress> relayCandidates() {
        LinkedHashSet<PeerAddress> relayCandidates = new LinkedHashSet<PeerAddress>(this.peer.getDistributedRouting().peerMap().getAll());
        this.filter(relayCandidates);
        return relayCandidates;
    }

    private void filter(Collection<PeerAddress> relayCandidates) {
        Iterator<PeerAddress> iterator = relayCandidates.iterator();
        block0: while (iterator.hasNext()) {
            PeerAddress pa = iterator.next();
            if (pa.isRelayed()) {
                iterator.remove();
                continue;
            }
            for (PeerConnection pc : this.relayAddresses) {
                if (!pc.remotePeer().equals((Object)pa)) continue;
                iterator.remove();
                continue block0;
            }
        }
        relayCandidates.removeAll(this.failedRelays);
        LOG.debug("Found {} peers that could act as relays", (Object)relayCandidates.size());
    }

    private void setupPeerConnections(FutureRelay futureRelay, ChannelCreator cc, Collection<PeerAddress> relayCandidates, int relaySuccess, int maxFail) {
        int nrOfRelays = Math.min(5 - this.relayAddresses.size(), relayCandidates.size());
        nrOfRelays = Math.min(nrOfRelays, futureRelay.nrRelays());
        LOG.debug("setting up {} relays", (Object)nrOfRelays);
        if (nrOfRelays > 0) {
            FutureDone[] futureDones = new FutureDone[nrOfRelays];
            AtomicReferenceArray<FutureDone<PeerConnection>> relayConnectionFutures = new AtomicReferenceArray<FutureDone<PeerConnection>>(futureDones);
            this.setupPeerConnectionsRecursive(relayConnectionFutures, relayCandidates, cc, nrOfRelays, futureRelay, relaySuccess, 0, maxFail);
        } else {
            futureRelay.setFailed("done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupPeerConnectionsRecursive(final AtomicReferenceArray<FutureDone<PeerConnection>> futures, final Collection<PeerAddress> relayCandidates, final ChannelCreator cc, final int numberOfRelays, final FutureRelay futureRelay, final int relaySuccess, final int fail, final int maxFail) {
        int active = 0;
        for (int i = 0; i < numberOfRelays; ++i) {
            if (futures.get(i) == null) {
                PeerAddress candidate = null;
                Collection<PeerAddress> collection = relayCandidates;
                synchronized (collection) {
                    if (!relayCandidates.isEmpty()) {
                        candidate = relayCandidates.iterator().next();
                        relayCandidates.remove(candidate);
                    }
                }
                if (candidate == null) continue;
                FuturePeerConnection fpc = this.peer.createPeerConnection(candidate);
                FutureDone<PeerConnection> futureDone = this.relayRPC.setupRelay(cc, fpc);
                this.setupAddRealys(futureDone);
                futures.set(i, futureDone);
                ++active;
                continue;
            }
            ++active;
        }
        if (active == 0) {
            this.updatePeerAddress();
            futureRelay.setDone(new ArrayList<PeerConnection>(this.relayAddresses));
            return;
        }
        if (fail > maxFail) {
            this.updatePeerAddress();
            futureRelay.setFailed("maxfail");
            return;
        }
        FutureForkJoin ffj = new FutureForkJoin(Math.min(relaySuccess, active), false, futures);
        ffj.addListener((BaseFutureListener)new BaseFutureAdapter<FutureForkJoin<FutureDone<PeerConnection>>>(){

            public void operationComplete(FutureForkJoin<FutureDone<PeerConnection>> futureForkJoin) throws Exception {
                if (futureForkJoin.isSuccess()) {
                    DistributedRelay.this.updatePeerAddress();
                    futureRelay.setDone(new ArrayList<PeerConnection>(DistributedRelay.this.relayAddresses));
                } else if (!DistributedRelay.this.peer.isShutdown()) {
                    DistributedRelay.this.setupPeerConnectionsRecursive(futures, relayCandidates, cc, numberOfRelays, futureRelay, relaySuccess, fail + 1, maxFail);
                } else {
                    futureRelay.setFailed("shutting down");
                }
            }
        });
    }

    private void setupAddRealys(final FutureDone<PeerConnection> futureDone) {
        futureDone.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<PeerConnection>>(){

            public void operationComplete(FutureDone<PeerConnection> future) throws Exception {
                if (future.isSuccess()) {
                    PeerConnection peerConnection = (PeerConnection)future.getObject();
                    PeerAddress relayAddress = peerConnection.remotePeer();
                    if (future.isSuccess()) {
                        LOG.debug("Adding peer {} as a relay", (Object)relayAddress);
                        DistributedRelay.this.relayAddresses.add(peerConnection);
                        DistributedRelay.this.addCloseListener(peerConnection);
                    } else {
                        LOG.debug("Peer {} denied relay request", (Object)relayAddress);
                        DistributedRelay.this.failedRelays.add(relayAddress);
                    }
                } else {
                    futureDone.setFailed(future);
                }
            }
        });
    }

    private void addCloseListener(final PeerConnection peerConnection) {
        peerConnection.closeFuture().addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(FutureDone<Void> future) throws Exception {
                if (!DistributedRelay.this.peer.isShutdown()) {
                    PeerAddress failedRelay = peerConnection.remotePeer();
                    LOG.debug("Relay " + failedRelay + " failed, setting up a new relay peer");
                    DistributedRelay.this.relayAddresses.remove(peerConnection);
                    DistributedRelay.this.failedRelays.add(failedRelay);
                    DistributedRelay.this.updatePeerAddress();
                    5 var3_3 = this;
                    synchronized (var3_3) {
                        for (RelayListener relayListener : DistributedRelay.this.relayListeners) {
                            relayListener.relayFailed(DistributedRelay.this, peerConnection);
                        }
                    }
                }
            }
        });
    }

    private void updatePeerAddress() {
        boolean hasRelays = !this.relayAddresses.isEmpty();
        ArrayList<PeerSocketAddress> socketAddresses = new ArrayList<PeerSocketAddress>(this.relayAddresses.size());
        for (PeerConnection pc : this.relayAddresses) {
            PeerAddress pa = pc.remotePeer();
            socketAddresses.add(new PeerSocketAddress(pa.getInetAddress(), pa.tcpPort(), pa.udpPort()));
        }
        PeerAddress newAddress = this.peer.getPeerAddress().changeFirewalledTCP(!hasRelays).changeFirewalledUDP(!hasRelays).changeRelayed(hasRelays).changePeerSocketAddresses(socketAddresses);
        this.peer.getPeerBean().serverPeerAddress(newAddress);
        LOG.debug("update peer address {}, isrelay = {}", (Object)newAddress, (Object)hasRelays);
    }
}

