/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.natpmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import net.tomp2p.natpmp.MessageResponseInterface;
import net.tomp2p.natpmp.MessageType;
import net.tomp2p.natpmp.NatPmpException;
import net.tomp2p.natpmp.ResultCode;

public abstract class Message {
    private MessageType type;
    private DatagramSocket socket;
    private byte[] response;
    private NatPmpException responseException;
    private MessageResponseInterface listener;
    private ResultCode resultCode;
    private Integer secondsSinceEpoch;

    Message(MessageType type, MessageResponseInterface listener) {
        this.type = type;
        this.listener = listener;
        if (type == null) {
            throw new NullPointerException("MessageType must not be null.");
        }
    }

    abstract byte[] getRequestPayload();

    abstract byte getOpcode();

    abstract void parseResponse(byte[] var1) throws Throwable;

    public NatPmpException getResponseException() {
        return this.responseException;
    }

    public ResultCode getResultCode() throws NatPmpException {
        return this.resultCode;
    }

    public Integer getSecondsSinceEpoch() throws NatPmpException {
        return this.secondsSinceEpoch;
    }

    private void setResponseException(NatPmpException responseException) {
        this.responseException = responseException;
    }

    void notifyListener() {
        if (this.response == null) {
            if (this.listener != null) {
                this.listener.noResponseReceived(this);
            }
            return;
        }
        try {
            this.internalNotifyListener();
        }
        catch (NatPmpException ex) {
            this.setResponseException(ex);
        }
        if (this.getResponseException() != null) {
            if (this.listener != null) {
                this.listener.exceptionGenerated(this, this.getResponseException());
            }
        } else if (this.listener != null) {
            this.listener.responseReceived(this);
        }
    }

    private void internalNotifyListener() throws NatPmpException {
        this.secondsSinceEpoch = Message.intFromByteArray(this.response, 4);
        switch (Message.shortFromByteArray(this.response, 2)) {
            case 0: {
                this.resultCode = ResultCode.Success;
                break;
            }
            case 1: {
                this.resultCode = ResultCode.UnsupportedVersion;
                break;
            }
            case 2: {
                this.resultCode = ResultCode.NotAuthorizedRefused;
                break;
            }
            case 3: {
                this.resultCode = ResultCode.NetworkFailure;
                break;
            }
            case 4: {
                this.resultCode = ResultCode.OutOfResources;
                break;
            }
            case 5: {
                this.resultCode = ResultCode.UnsupportedOpcode;
                break;
            }
            default: {
                throw new NatPmpException("Unsupported Result Code: " + Message.shortFromByteArray(this.response, 2));
            }
        }
        if (this.resultCode != ResultCode.Success) {
            throw new NatPmpException("Message was not successful. The returned message code was " + this.resultCode.toString() + ".");
        }
        if (this.response[1] != this.getOpcode() + -128) {
            throw new NatPmpException("Incorrect opcode received from gateway.");
        }
        try {
            this.parseResponse(this.response);
        }
        catch (Throwable ex) {
            if (ex instanceof NatPmpException) {
                throw (NatPmpException)ex;
            }
            throw new NatPmpException("Exception encountered during parsing of response.", ex);
        }
    }

    MessageType getMessageType() {
        return this.type;
    }

    static final int intFromByteArray(byte[] src, int offset) {
        return ((src[offset] & 0xFF) << 24) + ((src[offset + 1] & 0xFF) << 16) + ((src[offset + 2] & 0xFF) << 8) + (src[offset + 3] & 0xFF);
    }

    static final void intToByteArray(int value, byte[] array, int offset) {
        array[offset] = (byte)(value >>> 24);
        array[offset + 1] = (byte)(value >>> 16);
        array[offset + 2] = (byte)(value >>> 8);
        array[offset + 3] = (byte)value;
    }

    static final int shortFromByteArray(byte[] src, int offset) {
        return ((src[offset] & 0xFF) << 8) + (src[offset + 1] & 0xFF);
    }

    static final void shortToByteArray(int value, byte[] array, int offset) {
        array[offset] = (byte)(value >>> 8);
        array[offset + 1] = (byte)value;
    }

    synchronized void sendMessage(InetAddress destination) {
        try {
            this.sendMessageInternal(destination);
        }
        catch (NatPmpException ex) {
            this.setResponseException(ex);
        }
    }

    private void sendMessageInternal(InetAddress destination) throws NatPmpException {
        if (this.socket != null) {
            throw new NatPmpException("Message is already being sent.");
        }
        try {
            this.socket = new DatagramSocket();
            this.socket.connect(destination, 5351);
            this.socket.setSoTimeout(250);
        }
        catch (IOException ex) {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            throw new NatPmpException("Exception during socket setup.", ex);
        }
        this.sendMessageInternal();
        this.socket.close();
    }

    private void sendMessageInternal() throws NatPmpException {
        for (int attempts = 4; attempts > 0; --attempts) {
            DatagramPacket packet;
            try {
                byte[] payload = this.getRequestPayload();
                payload[0] = 0;
                payload[1] = this.getOpcode();
                packet = new DatagramPacket(payload, payload.length, this.socket.getRemoteSocketAddress());
                this.socket.send(packet);
            }
            catch (PortUnreachableException ex) {
                throw new NatPmpException("The gateway is unreachable.");
            }
            catch (IOException ex) {
                throw new NatPmpException("Exception while sending packet.", ex);
            }
            try {
                byte[] localResponse = new byte[16];
                packet = new DatagramPacket(localResponse, 0, 16);
                this.socket.receive(packet);
                if (packet.getLength() > 0) {
                    this.response = localResponse;
                    return;
                }
            }
            catch (SocketTimeoutException ex) {
            }
            catch (PortUnreachableException ex) {
                throw new NatPmpException("The gateway is unreachable.");
            }
            catch (IOException ex) {
                throw new NatPmpException("Exception while waiting for packet to be received.", ex);
            }
            try {
                this.socket.setSoTimeout(this.socket.getSoTimeout() * 2);
                continue;
            }
            catch (SocketException ex) {
                throw new NatPmpException("Exception while increasing socket timeout time.", ex);
            }
        }
    }
}

