/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FuturePeerConnection;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.Message;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStatatistic;
import net.tomp2p.relay.NoDirectResponse;
import net.tomp2p.relay.RelayForwarderRPC;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RelayRPC.class);
    private final ConnectionConfiguration config;
    private final Peer peer;

    public RelayRPC(Peer peer) {
        super(peer.getPeerBean(), peer.getConnectionBean());
        this.register(new int[]{RPC.Commands.RELAY.getNr()});
        this.peer = peer;
        this.config = new DefaultConnectionConfiguration();
    }

    public FutureResponse sendPeerMap(PeerAddress peerAddress, List<Map<Number160, PeerStatatistic>> map, PeerConnection peerConnection) {
        Message message = this.createMessage(peerAddress, RPC.Commands.RELAY.getNr(), Message.Type.REQUEST_3);
        message.setKeepAlive(true);
        message.setNeighborsSet(new NeighborSet(-1, RelayUtils.flatten(map)));
        FutureResponse futureResponse = new FutureResponse(message);
        return this.sendSingle(peerConnection, futureResponse);
    }

    public FutureResponse forwardMessage(PeerConnection peerConnection, Buffer buf) {
        Message message = this.createMessage(peerConnection.remotePeer(), RPC.Commands.RELAY.getNr(), Message.Type.REQUEST_2);
        message.setKeepAlive(true);
        message.setBuffer(buf);
        FutureResponse futureResponse = new FutureResponse(message);
        return this.sendSingle(peerConnection, futureResponse);
    }

    private FutureResponse sendSingle(final PeerConnection peerConnection, final FutureResponse futureResponse) {
        final RequestHandler requestHandler = new RequestHandler(futureResponse, this.peerBean(), this.connectionBean(), this.config);
        FutureChannelCreator fcc = peerConnection.acquire(requestHandler.futureResponse());
        fcc.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    requestHandler.sendTCP(peerConnection);
                } else {
                    futureResponse.setFailed((BaseFuture)future);
                }
            }
        });
        return futureResponse;
    }

    public FutureDone<PeerConnection> setupRelay(ChannelCreator channelCreator, FuturePeerConnection fpc) {
        final FutureDone futureDone = new FutureDone();
        Message message = this.createMessage(fpc.remotePeer(), RPC.Commands.RELAY.getNr(), Message.Type.REQUEST_1);
        message.setKeepAlive(true);
        final FutureResponse futureResponse = new FutureResponse(message);
        LOG.debug("Setting up relay connection to peer {}, message {}", (Object)fpc.remotePeer(), (Object)message);
        fpc.addListener((BaseFutureListener)new BaseFutureAdapter<FuturePeerConnection>(){

            public void operationComplete(FuturePeerConnection futurePeerConnection) throws Exception {
                if (futurePeerConnection.isSuccess()) {
                    final PeerConnection peerConnection = (PeerConnection)futurePeerConnection.getObject();
                    RelayRPC.this.sendSingle(peerConnection, futureResponse).addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

                        public void operationComplete(FutureResponse future) throws Exception {
                            if (future.isSuccess()) {
                                futureDone.setDone((Object)peerConnection);
                            } else {
                                futureDone.setFailed((BaseFuture)future);
                            }
                        }
                    });
                } else {
                    futureDone.setFailed((BaseFuture)futurePeerConnection);
                }
            }
        });
        return futureDone;
    }

    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        LOG.debug("received RPC message {}", (Object)message);
        if (message.getType() == Message.Type.REQUEST_1 && message.getCommand() == RPC.Commands.RELAY.getNr()) {
            this.handleSetup(message, peerConnection, responder);
        } else if (message.getType() == Message.Type.REQUEST_2 && message.getCommand() == RPC.Commands.RELAY.getNr()) {
            this.handlePiggyBackMessage(message, responder);
        } else if (message.getType() == Message.Type.REQUEST_3 && message.getCommand() == RPC.Commands.RELAY.getNr()) {
            this.handleMap(message, responder);
        } else {
            throw new IllegalArgumentException("Message content is wrong");
        }
    }

    public Peer peer() {
        return this.peer;
    }

    private void handleSetup(Message message, final PeerConnection peerConnection, Responder responder) {
        if (this.peerBean().serverPeerAddress().isRelayed()) {
            responder.response(this.createResponseMessage(message, Message.Type.DENIED));
            return;
        }
        RelayForwarderRPC.register(peerConnection, this.peer, this);
        peerConnection.closeFuture().addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Void>>(){

            public void operationComplete(FutureDone<Void> future) throws Exception {
                LOG.debug("Unregister the relay for {}", (Object)peerConnection.remotePeer().getPeerId());
                RelayForwarderRPC.unregister(RelayRPC.this.peer, peerConnection.remotePeer().getPeerId());
            }
        });
        responder.response(this.createResponseMessage(message, Message.Type.OK));
    }

    private void handlePiggyBackMessage(Message message, Responder responderToRelay) throws Exception {
        Buffer requestBuffer = message.getBuffer(0);
        Message realMessage = RelayUtils.decodeMessage(requestBuffer, new InetSocketAddress(0), new InetSocketAddress(0));
        LOG.debug("Received message from relay peer: {}", (Object)realMessage);
        realMessage.restoreContentReferences();
        NoDirectResponse responder = new NoDirectResponse();
        this.peer.getConnectionBean().dispatcher().getAssociatedHandler(realMessage).handleResponse(realMessage, null, false, (Responder)responder);
        LOG.debug("Send reply message to relay peer: {}", (Object)responder.getResponse());
        Message response = this.createResponseMessage(message, Message.Type.OK);
        response.setBuffer(RelayUtils.encodeMessage(responder.getResponse()));
        responderToRelay.response(response);
    }

    private void handleMap(Message message, Responder responder) {
        Collection map = message.getNeighborsSet(0).neighbors();
        RelayForwarderRPC relayForwarderRPC = RelayForwarderRPC.find(this.peer, message.getSender().getPeerId());
        if (relayForwarderRPC != null) {
            relayForwarderRPC.setMap(RelayUtils.unflatten(map, message.getSender()));
        } else {
            LOG.error("need to call setup relay first");
        }
        Message response = this.createResponseMessage(message, Message.Type.OK);
        responder.response(response);
    }
}

