/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.natpmp;

import net.tomp2p.natpmp.Message;
import net.tomp2p.natpmp.MessageResponseInterface;
import net.tomp2p.natpmp.MessageType;
import net.tomp2p.natpmp.NatPmpException;

public class MapRequestMessage
extends Message {
    private int internalPort;
    private int requestedExternalPort;
    private Integer externalPort;
    private int requestedPortMappingLifetime;
    private Integer portMappingLifetime;

    public MapRequestMessage(boolean isTCP, int internalPort, int requestedExternalPort, int requestedPortMappingLifetime, MessageResponseInterface listener) {
        super(isTCP ? MessageType.MapTCP : MessageType.MapUDP, listener);
        this.internalPort = internalPort;
        this.requestedExternalPort = requestedExternalPort;
        this.requestedPortMappingLifetime = requestedPortMappingLifetime;
    }

    @Override
    byte[] getRequestPayload() {
        byte[] request = new byte[12];
        request[2] = 0;
        request[3] = 0;
        MapRequestMessage.shortToByteArray(this.getInternalPort(), request, 4);
        MapRequestMessage.shortToByteArray(this.getRequestedExternalPort(), request, 6);
        MapRequestMessage.intToByteArray(this.getRequestedPortMappingLifetime(), request, 8);
        return request;
    }

    @Override
    void parseResponse(byte[] response) throws NatPmpException {
        int returnedInternalPort = MapRequestMessage.shortFromByteArray(response, 8);
        if (returnedInternalPort != this.internalPort) {
            throw new NatPmpException("The internal port returned from the gateway was not the same as the one sent.");
        }
        this.internalPort = returnedInternalPort;
        this.externalPort = MapRequestMessage.shortFromByteArray(response, 10);
        this.portMappingLifetime = MapRequestMessage.intFromByteArray(response, 12);
    }

    @Override
    byte getOpcode() {
        return this.getMessageType() == MessageType.MapUDP ? (byte)1 : 2;
    }

    public int getInternalPort() {
        return this.internalPort;
    }

    public int getRequestedExternalPort() {
        return this.requestedExternalPort;
    }

    public Integer getExternalPort() throws NatPmpException {
        return this.externalPort;
    }

    public int getRequestedPortMappingLifetime() {
        return this.requestedPortMappingLifetime;
    }

    public Integer getPortMappingLifetime() throws NatPmpException {
        return this.portMappingLifetime;
    }
}

