/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import net.tomp2p.dht.FutureGet;
import net.tomp2p.dht.FuturePut;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.dht.RemoveBuilder;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;
import net.tomp2p.utils.Pair;

public class ExampleVDHT {
    private static final Random RND = new Random(42L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, ClassNotFoundException, InterruptedException {
        PeerDHT master = null;
        int nrPeers = 100;
        int port = 4001;
        try {
            PeerDHT[] peers = ExampleUtils.createAndAttachPeersDHT(100, 4001);
            ExampleUtils.bootstrap(peers);
            master = peers[0];
            Number160 nr = new Number160(RND);
            ExampleVDHT.exampleDHT(peers, nr);
            ExampleVDHT.exampleVDHT(peers, nr);
        }
        finally {
            if (master != null) {
                master.shutdown();
            }
        }
    }

    private static void exampleDHT(final PeerDHT[] peers, Number160 nr) throws IOException, ClassNotFoundException, InterruptedException {
        FuturePut fp = (FuturePut)peers[0].put(Number160.ONE).data(new Data((Object)"start -")).start().awaitUninterruptibly();
        System.out.println("stored initial value: " + fp.failedReason());
        final CountDownLatch cl = new CountDownLatch(3);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ExampleVDHT.storeDHT(peers[1], " one ");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                cl.countDown();
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ExampleVDHT.storeDHT(peers[2], " two ");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                cl.countDown();
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ExampleVDHT.storeDHT(peers[3], " three ");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                cl.countDown();
            }
        }).start();
        cl.await();
        FutureGet fg = (FutureGet)peers[5].get(Number160.ONE).getLatest().start().awaitUninterruptibly();
        System.out.println("res: " + ((Data)((Map)fg.rawData().values().iterator().next()).values().iterator().next()).object());
    }

    private static void storeDHT(PeerDHT peerDHT, String string) throws ClassNotFoundException, InterruptedException, IOException {
        FutureGet fg = (FutureGet)peerDHT.get(Number160.ONE).getLatest().start().awaitUninterruptibly();
        FuturePut fp = (FuturePut)peerDHT.put(Number160.ONE).data(new Data((Object)(fg.data().object() + string))).start().awaitUninterruptibly();
        System.out.println("stored!: " + fp.failedReason());
    }

    private static void exampleVDHT(final PeerDHT[] peers, Number160 nr) throws IOException, ClassNotFoundException, InterruptedException {
        FuturePut fp = (FuturePut)peers[0].put(Number160.ONE).data(new Data((Object)"start -")).start().awaitUninterruptibly();
        System.out.println("stored initial value: " + fp.failedReason());
        final CountDownLatch cl = new CountDownLatch(3);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ExampleVDHT.store(peers[1], " one ");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                cl.countDown();
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ExampleVDHT.store(peers[2], " two ");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                cl.countDown();
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ExampleVDHT.store(peers[3], " three ");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                cl.countDown();
            }
        }).start();
        cl.await();
        FutureGet fg = (FutureGet)peers[5].get(Number160.ONE).getLatest().start().awaitUninterruptibly();
        System.out.println("res: " + ((Data)((Map)fg.rawData().values().iterator().next()).values().iterator().next()).object());
    }

    private static void store(PeerDHT peerDHT, String string) throws ClassNotFoundException, InterruptedException, IOException {
        Pair pair2 = null;
        for (int i = 0; i < 5; ++i) {
            Pair<Number160, Data> pair = ExampleVDHT.getAndUpdate(peerDHT, string);
            if (pair == null) {
                System.out.println("we cannot handle this kind of inconsistency automatically, handing over the the API dev");
                return;
            }
            FuturePut fp = (FuturePut)peerDHT.put(Number160.ONE).data(Number160.ZERO, ((Data)pair.element1()).prepareFlag(), (Number160)pair.element0()).start().awaitUninterruptibly();
            pair2 = ExampleVDHT.checkVersions(fp.rawResult());
            if (pair2 != null && (Byte)pair2.element1() == 1) break;
            System.out.println("get delay or fork - put");
            ((RemoveBuilder)peerDHT.remove(Number160.ONE).versionKey((Number160)pair.element0())).start().awaitUninterruptibly();
            Thread.sleep(RND.nextInt(500));
        }
        if (pair2 != null && (Byte)pair2.element1() == 1) {
            FuturePut fp = (FuturePut)peerDHT.put(Number160.ONE).versionKey(((Number640)pair2.element0()).versionKey()).putConfirm().data(new Data()).start().awaitUninterruptibly();
            System.out.println("stored!: " + fp.failedReason());
        } else {
            System.out.println("we cannot handle this kind of inconsistency automatically, handing over the the API dev");
        }
    }

    private static Pair<Number160, Data> getAndUpdate(PeerDHT peerDHT, String string) throws InterruptedException, ClassNotFoundException, IOException {
        FutureGet fg;
        Pair pair = null;
        for (int i = 0; i < 5 && (pair = ExampleVDHT.checkVersions((fg = (FutureGet)peerDHT.get(Number160.ONE).getLatest().start().awaitUninterruptibly()).rawData())) == null; ++i) {
            System.out.println("get delay or fork - get");
            Thread.sleep(RND.nextInt(500));
        }
        if (pair != null) {
            Data newData = new Data((Object)(((Data)pair.element1()).object() + string));
            Number160 v = ((Number640)pair.element0()).versionKey();
            long version = v.timestamp() + 1L;
            newData.addBasedOn(v);
            return new Pair((Object)new Number160(version, newData.hash()), (Object)newData);
        }
        return null;
    }

    private static <K> Pair<Number640, K> checkVersions(Map<PeerAddress, Map<Number640, K>> rawData) {
        Number640 latestKey = null;
        Object latestData = null;
        for (Map.Entry<PeerAddress, Map<Number640, K>> entry : rawData.entrySet()) {
            if (latestData == null && latestKey == null) {
                latestData = entry.getValue().values().iterator().next();
                latestKey = entry.getValue().keySet().iterator().next();
                continue;
            }
            if (latestKey.equals((Object)entry.getValue().keySet().iterator().next()) && latestData.equals(entry.getValue().values().iterator().next())) continue;
            return null;
        }
        return new Pair(latestKey, latestData);
    }
}

