/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.tomp2p.dht.FutureGet;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ObjectDataReply;
import net.tomp2p.storage.Data;

public final class ExampleSimpleRecommondation {
    private ExampleSimpleRecommondation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        PeerDHT[] peers = null;
        try {
            int peerNr = 100;
            int port = 4001;
            peers = ExampleUtils.createAndAttachPeersDHT(100, 4001);
            ExampleUtils.bootstrap(peers);
            MyPeer[] myPeers = ExampleSimpleRecommondation.wrap(peers);
            ExampleSimpleRecommondation.example(myPeers);
        }
        finally {
            if (peers != null && peers[0] != null) {
                peers[0].shutdown();
            }
        }
    }

    private static MyPeer[] wrap(PeerDHT[] peers) {
        MyPeer[] retVal = new MyPeer[peers.length];
        for (int i = 0; i < peers.length; ++i) {
            retVal[i] = new MyPeer(peers[i]);
        }
        return retVal;
    }

    private static void example(MyPeer[] peers) throws IOException, ClassNotFoundException {
        System.out.println("Setup: we have " + peers.length + " peers; peers[12] (Leo) knows Jan, peers[24] (Tom) knows Urs and Pat, peers[42] (Urs) knows Pat and Tim");
        int peer12 = 12;
        int peer24 = 24;
        int peer42 = 42;
        peers[12].announce("Leo", "Jan");
        peers[24].announce("Tom", "Urs");
        peers[24].announce("Tom", "Pat");
        peers[42].announce("Urs", "Pat");
        peers[42].announce("Urs", "Tim");
        System.out.println("peers[24] (Tom) wants to know the friends of Urs");
        peers[24].list("Urs");
        System.out.println("peers[24] (Tom) does not know Tim yet, but Urs does");
    }

    private static class MyPeer {
        private final PeerDHT peer;
        private final Map<Number160, String> friends = new HashMap<Number160, String>();

        public MyPeer(PeerDHT peer) {
            this.peer = peer;
            this.setReplyHandler(peer);
        }

        public void announce(String nickName, String friendName) throws IOException {
            this.friends.put(Number160.createHash((String)nickName), friendName);
            this.announce();
        }

        public void announce() throws IOException {
            for (Map.Entry<Number160, String> entry : this.friends.entrySet()) {
                ArrayList<String> tmp = new ArrayList<String>(this.friends.values());
                TreeMap<Number160, Data> dataMap = new TreeMap<Number160, Data>();
                for (String friend : tmp) {
                    dataMap.put(this.peer.peerID().xor(Number160.createHash((String)friend)), new Data((Object)friend));
                }
                this.peer.put(entry.getKey()).dataMapContent(dataMap).start().awaitUninterruptibly();
            }
        }

        public void list(String nickName) throws IOException, ClassNotFoundException {
            Number160 key = Number160.createHash((String)nickName);
            FutureGet futureGet = this.peer.get(key).all().start();
            futureGet.awaitUninterruptibly();
            for (Map.Entry entry : futureGet.dataMap().entrySet()) {
                System.out.println("this peers' (" + nickName + ") friend:" + ((Data)entry.getValue()).object());
            }
            System.out.println("DHT reports that " + futureGet.dataMap().size() + " peer(s) are his friends");
        }

        private void setReplyHandler(PeerDHT peer) {
            peer.peer().objectDataReply(new ObjectDataReply(){

                public Object reply(PeerAddress sender, Object request) throws Exception {
                    if (request != null && request instanceof Number160) {
                        return MyPeer.this.friends.get((Number160)request);
                    }
                    return null;
                }
            });
        }
    }
}

