/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import java.util.Map;
import net.tomp2p.dht.FutureGet;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.storage.Data;

public final class ExampleMultiColumn {
    private ExampleMultiColumn() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        PeerDHT master = null;
        try {
            int peerNr = 100;
            int port = 4001;
            PeerDHT[] peers = ExampleUtils.createAndAttachPeersDHT(100, 4001);
            master = peers[0];
            ExampleUtils.bootstrap(peers);
            ExampleMultiColumn.exampleMultiColumn(peers);
        }
        finally {
            if (master != null) {
                master.shutdown();
            }
        }
    }

    private static void exampleMultiColumn(PeerDHT[] peers) throws IOException, ClassNotFoundException {
        String rowKey1 = "tbocek";
        String rowKey2 = "fhecht";
        String rowKey3 = "gmachado";
        String rowKey4 = "tsiaras";
        String rowKey5 = "bstiller";
        String col1 = "first name";
        String col2 = "last name";
        String col3 = "loaction";
        String col4 = "nr";
        Number160 locationKey = Number160.createHash((String)"users");
        System.out.println("storing data in table (identified by locationKey) " + locationKey);
        ExampleMultiColumn.multiAdd(peers[11], rowKey1, col1, "thomas");
        ExampleMultiColumn.multiAdd(peers[11], rowKey1, col2, "bocek");
        ExampleMultiColumn.multiAdd(peers[11], rowKey1, col3, "zuerich");
        ExampleMultiColumn.multiAdd(peers[11], rowKey1, col4, "77");
        ExampleMultiColumn.multiAdd(peers[11], rowKey2, col1, "fabio");
        ExampleMultiColumn.multiAdd(peers[11], rowKey2, col2, "hecht");
        ExampleMultiColumn.multiAdd(peers[11], rowKey2, col3, "zuerich");
        ExampleMultiColumn.multiAdd(peers[11], rowKey3, col1, "guilherme");
        ExampleMultiColumn.multiAdd(peers[11], rowKey3, col2, "machado");
        ExampleMultiColumn.multiAdd(peers[11], rowKey3, col3, "zuerich");
        ExampleMultiColumn.multiAdd(peers[11], rowKey4, col1, "christos");
        ExampleMultiColumn.multiAdd(peers[11], rowKey4, col2, "tsiaras");
        ExampleMultiColumn.multiAdd(peers[11], rowKey4, col3, "zuerich");
        ExampleMultiColumn.multiAdd(peers[11], rowKey5, col1, "burkhard");
        ExampleMultiColumn.multiAdd(peers[11], rowKey5, col2, "stiller");
        ExampleMultiColumn.multiAdd(peers[11], rowKey5, col3, "zuerich");
        Number160 contentKey = ExampleMultiColumn.combine(rowKey1, col1);
        int peerGet = 22;
        FutureGet futureGet = peers[22].get(locationKey).contentKey(contentKey).start();
        futureGet.awaitUninterruptibly();
        System.out.println("single fetch for (" + rowKey1 + "," + col1 + "): [" + futureGet.data().object() + "]");
        Number640 from = new Number640(locationKey, Number160.ZERO, ExampleMultiColumn.createNr(rowKey1, 0), Number160.ZERO);
        Number640 to = new Number640(locationKey, Number160.ZERO, ExampleMultiColumn.createNr(rowKey1, -1), Number160.MAX_VALUE);
        FutureGet futureGet2 = peers[22].get(locationKey).from(from).to(to).start();
        futureGet2.awaitUninterruptibly();
        System.out.println("row fetch [" + rowKey1 + "]");
        for (Map.Entry entry : futureGet2.dataMap().entrySet()) {
            System.out.println("multi fetch: " + ((Data)entry.getValue()).object());
        }
        String search = col1;
        from = new Number640(locationKey, Number160.ZERO, ExampleMultiColumn.createNr(search, 0), Number160.ZERO);
        to = new Number640(locationKey, Number160.ZERO, ExampleMultiColumn.createNr(search, -1), Number160.MAX_VALUE);
        FutureGet futureGet3 = peers[22].get(locationKey).from(from).to(to).start();
        futureGet3.awaitUninterruptibly();
        System.out.println("column fetch [" + search + "]");
        for (Map.Entry entry : futureGet3.dataMap().entrySet()) {
            System.out.println("multi fetch: " + ((Data)entry.getValue()).object());
        }
    }

    private static void multiAdd(PeerDHT peer, String rowKey, String col, String string) throws IOException {
        Number160 locationKey = Number160.createHash((String)"users");
        Number160 contentKey = ExampleMultiColumn.combine(rowKey, col);
        peer.put(locationKey).data(contentKey, new Data((Object)string)).start().awaitUninterruptibly();
        contentKey = ExampleMultiColumn.combine(col, rowKey);
        peer.put(locationKey).data(contentKey, new Data((Object)string)).start().awaitUninterruptibly();
    }

    private static Number160 createNr(String key1, int nr) {
        Number160 firstKey = Number160.createHash((String)key1);
        int[] val = firstKey.toIntArray();
        val[0] = val[0] ^ val[4] ^ val[3] ^ val[2];
        val[1] = val[1] ^ val[4] ^ val[3] ^ val[2];
        val[2] = nr;
        val[3] = nr;
        val[4] = nr;
        return new Number160(val);
    }

    private static Number160 combine(String key1, String key2) {
        Number160 firstKey = Number160.createHash((String)key1);
        Number160 secondKey = Number160.createHash((String)key2);
        return ExampleMultiColumn.combine(firstKey, secondKey);
    }

    private static Number160 combine(Number160 firstKey, Number160 secondKey) {
        int[] val1 = firstKey.toIntArray();
        val1[0] = val1[0] ^ val1[4] ^ val1[3] ^ val1[2];
        val1[1] = val1[1] ^ val1[4] ^ val1[3] ^ val1[2];
        int[] val2 = secondKey.toIntArray();
        val2[2] = val2[2] ^ val2[0] ^ val2[1];
        val2[3] = val2[3] ^ val2[0] ^ val2[1];
        val2[4] = val2[4] ^ val2[0] ^ val2[1];
        val2[0] = val1[0];
        val2[1] = val1[1];
        return new Number160(val2);
    }
}

