/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import java.io.Serializable;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.dht.FutureGet;
import net.tomp2p.dht.FuturePut;
import net.tomp2p.dht.PeerBuilderDHT;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.dht.Storage;
import net.tomp2p.dht.StorageLayer;
import net.tomp2p.dht.StorageMemory;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;

public final class ExampleDST {
    private static final int n = 2;
    private static final int m = 8;

    private ExampleDST() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int peerNr = 100;
        int port = 4001;
        PeerDHT[] peers = null;
        try {
            peers = ExampleDST.createAndAttachNodes(100, 4001, 2);
            ExampleUtils.bootstrap(peers);
            ExampleDST.exampleDST(peers);
        }
        finally {
            if (peers != null && peers[0] != null) {
                peers[0].shutdown();
            }
        }
    }

    private static PeerDHT[] createAndAttachNodes(int nr, int port, int max) throws IOException {
        PeerDHT[] peers = new PeerDHT[nr];
        for (int i = 0; i < nr; ++i) {
            Peer peer;
            if (i == 0) {
                peer = new PeerBuilder(new Number160(ExampleUtils.RND)).ports(port).start();
                peers[0] = new PeerBuilderDHT(peer).storageLayer(ExampleDST.setupStorage(max)).start();
                continue;
            }
            peer = new PeerBuilder(new Number160(ExampleUtils.RND)).masterPeer(peers[0].peer()).start();
            peers[i] = new PeerBuilderDHT(peer).storageLayer(ExampleDST.setupStorage(max)).start();
        }
        return peers;
    }

    private static StorageLayer setupStorage(final int max) {
        StorageLayer sl = new StorageLayer((Storage)new StorageMemory()){

            public Map<Number640, Enum<?>> putAll(NavigableMap<Number640, Data> dataMap, PublicKey publicKey, boolean putIfAbsent, boolean domainProtection, boolean sendSelf) {
                HashSet<Number640> full = new HashSet<Number640>();
                Iterator iterator = dataMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Number640 key = (Number640)entry.getKey();
                    NavigableMap map = this.get(key.minContentKey(), key.maxContentKey(), -1, false);
                    if (map.size() < max) continue;
                    full.add(key);
                    iterator.remove();
                }
                HashMap retVal = new HashMap(super.putAll(dataMap, publicKey, putIfAbsent, domainProtection, sendSelf));
                for (Number640 key : full) {
                    retVal.put(key, (Enum<?>)StorageLayer.PutStatus.FAILED);
                }
                return retVal;
            }

            public NavigableMap<Number640, Data> get(Number640 from, Number640 to, SimpleBloomFilter<Number160> contentKeyBloomFilter, SimpleBloomFilter<Number160> versionKeyBloomFilter, SimpleBloomFilter<Number160> contentBloomFilter, int limit, boolean ascending, boolean isBloomFilterAnd) {
                NavigableMap tmp = super.get(from, to, contentKeyBloomFilter, versionKeyBloomFilter, contentBloomFilter, limit, ascending, isBloomFilterAnd);
                return this.wrap(tmp);
            }

            private NavigableMap<Number640, Data> wrap(SortedMap<Number640, Data> tmp) {
                TreeMap<Number640, Data> retVal = new TreeMap<Number640, Data>();
                for (Map.Entry<Number640, Data> entry : tmp.entrySet()) {
                    try {
                        String data = (String)entry.getValue().object();
                        retVal.put(entry.getKey(), new Data((Object)new StringBoolean(tmp.size() < max, data)));
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return retVal;
            }
        };
        return sl;
    }

    private static void exampleDST(PeerDHT[] peers) throws IOException, ClassNotFoundException {
        int peer16 = 16;
        int peer55 = 55;
        boolean index1 = true;
        int index2 = 2;
        int index3 = 3;
        int index5 = 5;
        int index7 = 7;
        int width = 4;
        int height = (int)ExampleDST.log2(width);
        Interval inter = new Interval(1, 8);
        ExampleDST.putDST(peers[16], 1, "test", inter, height);
        ExampleDST.putDST(peers[16], 2, "hallo", inter, height);
        ExampleDST.putDST(peers[16], 3, "world", inter, height);
        ExampleDST.putDST(peers[16], 5, "sys", inter, height);
        ExampleDST.putDST(peers[16], 7, "communication", inter, height);
        Collection<Interval> inters = ExampleDST.splitSegment(1, 5, 1, 8, height);
        Collection<String> result = ExampleDST.getDST(peers[55], inters, 2);
        System.out.println("got from range query raw " + result);
        System.out.println("got from range query unique " + new HashSet<String>(result));
    }

    private static Collection<String> getDST(PeerDHT peer, Collection<Interval> inters, int bagSize) throws ClassNotFoundException, IOException {
        ArrayList<String> retVal = new ArrayList<String>();
        AtomicInteger dhtCounter = new AtomicInteger();
        ExampleDST.getDSTRec(peer, inters, retVal, new HashSet<String>(), dhtCounter, bagSize);
        System.out.println("for get we used " + dhtCounter + " DHT calls");
        return retVal;
    }

    private static void getDSTRec(PeerDHT peer, Collection<Interval> inters, Collection<String> result, Collection<String> already, AtomicInteger dhtCounter, int bagSize) throws ClassNotFoundException, IOException {
        for (Interval inter2 : inters) {
            if (already.contains(inter2.toString())) continue;
            Number160 key = Number160.createHash((String)inter2.toString());
            already.add(inter2.toString());
            System.out.println("get for " + inter2);
            FutureGet futureGet = peer.get(key).all().start();
            futureGet.awaitUninterruptibly();
            dhtCounter.incrementAndGet();
            for (Map.Entry entry : futureGet.dataMap().entrySet()) {
                StringBoolean stringBoolean = (StringBoolean)((Data)entry.getValue()).object();
                result.add(stringBoolean.string);
                if (stringBoolean.bool.booleanValue() || inter2.size() <= bagSize) continue;
                ExampleDST.getDSTRec(peer, inter2.split(), result, already, dhtCounter, bagSize);
            }
        }
    }

    private static void putDST(PeerDHT peer, int index, String word, Interval interval, int height) throws IOException {
        Interval inter = interval;
        for (int i = 0; i <= height; ++i) {
            Number160 key = Number160.createHash((String)inter.toString());
            FuturePut futurePut = peer.put(key).data(new Number160(index), new Data((Object)word)).start();
            futurePut.awaitUninterruptibly();
            System.out.println("stored " + word + " in " + inter + " status: " + !futurePut.result().isEmpty());
            inter = inter.split(index);
        }
        System.out.println("for DHT.put() we used " + (height + 1) + " DHT calls");
    }

    private static double log2(double num) {
        return Math.log(num) / Math.log(2.0);
    }

    private static Collection<Interval> splitSegment(int s, int t, int lower, int upper, int maxDepth) {
        ArrayList<Interval> retVal = new ArrayList<Interval>();
        ExampleDST.splitSegment(s, t, lower, upper, maxDepth, retVal);
        return retVal;
    }

    private static void splitSegment(int s, int t, int lower, int upper, int maxDepth, Collection<Interval> retVal) {
        if (s <= lower && upper <= t || maxDepth == 0) {
            retVal.add(new Interval(lower, upper));
            return;
        }
        int mid = (lower + upper) / 2;
        if (s <= mid) {
            ExampleDST.splitSegment(s, t, lower, mid, maxDepth - 1, retVal);
        }
        if (t > mid) {
            ExampleDST.splitSegment(s, t, mid + 1, upper, maxDepth - 1, retVal);
        }
    }

    private static final class Interval {
        private final int from;
        private final int to;

        private Interval(int from, int to) {
            if (from > to) {
                throw new IllegalArgumentException("from cannot be greater than to");
            }
            this.from = from;
            this.to = to;
        }

        public String toString() {
            return "interv. [" + this.from + ".." + this.to + "]";
        }

        private Collection<Interval> split() {
            int mid = (this.to - this.from + 1) / 2;
            int tok = this.from + mid;
            ArrayList<Interval> retVal = new ArrayList<Interval>();
            retVal.add(new Interval(this.from, tok - 1));
            retVal.add(new Interval(tok, this.to));
            return retVal;
        }

        private Interval split(int nr) {
            int mid = (this.to - this.from + 1) / 2;
            int tok = this.from + mid;
            if (nr < tok) {
                return new Interval(this.from, tok - 1);
            }
            return new Interval(tok, this.to);
        }

        private int size() {
            return this.to - this.from + 1;
        }
    }

    private static final class StringBoolean
    implements Serializable {
        private static final long serialVersionUID = -3947493823227587011L;
        private final Boolean bool;
        private final String string;

        private StringBoolean(boolean bool, String string) {
            this.bool = bool;
            this.string = string;
        }
    }
}

