/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import net.tomp2p.dht.PeerBuilderDHT;
import net.tomp2p.nat.PeerBuilderNAT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ObjectDataReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeedNodeForTesting {
    private static Peer peer = null;
    private static boolean running = true;
    private static final Logger log = LoggerFactory.getLogger(SeedNodeForTesting.class);

    public static void main(String[] args) throws Exception {
        block2: {
            try {
                Number160 peerId = Number160.createHash((String)"seed");
                peer = new PeerBuilder(peerId).ports(5000).start();
                peer.objectDataReply(new ObjectDataReply(){

                    public Object reply(PeerAddress sender, Object request) throws Exception {
                        log.trace("received request: ", (Object)request.toString());
                        return "pong";
                    }
                });
                new PeerBuilderDHT(peer).start();
                new PeerBuilderNAT(peer).start();
                log.debug("SeedNode started.");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (running) {
                            for (PeerAddress pa : peer.peerBean().peerMap().all()) {
                                log.debug("peer online:" + pa);
                            }
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                    }
                }).start();
            }
            catch (Exception e) {
                if (peer == null) break block2;
                peer.shutdown().awaitUninterruptibly();
            }
        }
    }

    public static void stop() {
        running = false;
        if (peer != null) {
            peer.shutdown().awaitUninterruptibly();
        }
        peer = null;
    }
}

