/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.tracker.FutureTracker;
import net.tomp2p.tracker.PeerBuilderTracker;
import net.tomp2p.tracker.PeerTracker;

public final class ExampleTracker {
    private ExampleTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Peer[] peers = null;
        try {
            int peerNr = 100;
            int port = 4001;
            peers = ExampleUtils.createAndAttachNodes(100, 4001);
            ExampleUtils.bootstrap(peers);
            PeerTracker[] myPeers = ExampleTracker.wrap(peers);
            ExampleTracker.example(myPeers);
        }
        finally {
            if (peers != null && peers[0] != null) {
                peers[0].shutdown();
            }
        }
    }

    private static PeerTracker[] wrap(Peer[] peers) {
        PeerTracker[] retVal = new PeerTracker[peers.length];
        for (int i = 0; i < peers.length; ++i) {
            retVal[i] = new PeerBuilderTracker(peers[i]).verifyPeersOnTracker(false).start();
        }
        return retVal;
    }

    private static void example(PeerTracker[] peers) throws IOException, ClassNotFoundException {
        FutureTracker futureTracker = (FutureTracker)peers[12].addTracker(Number160.createHash((String)"song1")).start().awaitUninterruptibly();
        System.out.println("added myself to the tracker with location [song1]: " + futureTracker.isSuccess() + " I'm: " + peers[12].peerAddress());
        FutureTracker futureTracker2 = (FutureTracker)peers[24].getTracker(Number160.createHash((String)"song1")).start().awaitUninterruptibly();
        System.out.println("peer24 got this: " + futureTracker2.trackers());
        System.out.println("currently stored on: " + futureTracker2.trackerPeers());
    }
}

