/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import java.util.HashSet;
import net.tomp2p.dht.FutureDigest;
import net.tomp2p.dht.FutureGet;
import net.tomp2p.dht.FuturePut;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.peers.Number160;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;

public final class ExampleSearch {
    private static final String TERM = "Communication Systems Group";

    private ExampleSearch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int peerNr = 100;
        int port = 4001;
        PeerDHT[] peers = null;
        try {
            peers = ExampleUtils.createAndAttachPeersDHT(100, 4001);
            ExampleUtils.bootstrap(peers);
            ExampleSearch.exampleSearch(peers);
            ExampleSearch.exampleKeywordSearch(peers);
            ExampleSearch.exampleBloomfilerSearch(peers);
            ExampleSearch.exampleXORSearch(peers);
        }
        finally {
            if (peers != null && peers[0] != null) {
                peers[0].shutdown();
            }
        }
    }

    private static void exampleSearch(PeerDHT[] peers) throws IOException, ClassNotFoundException {
        int peer30 = 30;
        int peer60 = 60;
        Number160 key = Number160.createHash((String)TERM);
        FuturePut futurePut = peers[60].put(key).object((Object)TERM).start();
        futurePut.awaitUninterruptibly();
        FutureGet futureGet = peers[30].get(key).start();
        futureGet.awaitUninterruptibly();
        System.out.println("got: " + key + " = " + futureGet.data().object());
    }

    private static void exampleKeywordSearch(PeerDHT[] peers) throws IOException, ClassNotFoundException {
        String[] keywords;
        int peer10 = 10;
        int peer20 = 20;
        Number160 keyTerm = Number160.createHash((String)TERM);
        for (String keyword : keywords = TERM.split(" ")) {
            Number160 keyKeyword = Number160.createHash((String)keyword);
            peers[10].put(keyKeyword).object((Object)keyTerm).start().awaitUninterruptibly();
        }
        Number160 termKey = ExampleSearch.findReference(peers[20], "Communication");
        if (termKey == null) {
            System.out.println("nothing found");
            return;
        }
        FutureGet futureGet = peers[10].get(termKey).start();
        futureGet.awaitUninterruptibly();
        System.out.println("searched (keyword) for [Communication], found " + futureGet.data().object());
    }

    private static void exampleXORSearch(PeerDHT[] peers) throws IOException, ClassNotFoundException {
        Number160 key2Keyword;
        Number160 keyTerm = Number160.createHash((String)TERM);
        String[] keywords = TERM.split(" ");
        HashSet<Number160> xoredKeywords = new HashSet<Number160>();
        for (String keyword1 : keywords) {
            for (String keyword2 : keywords) {
                Number160 key1Keyword;
                if (!keyword1.equals(keyword2)) {
                    key1Keyword = Number160.createHash((String)keyword1);
                    Number160 key2Keyword2 = Number160.createHash((String)keyword2);
                    xoredKeywords.add(key1Keyword.xor(key2Keyword2));
                    continue;
                }
                key1Keyword = Number160.createHash((String)keyword1);
                xoredKeywords.add(key1Keyword);
            }
        }
        System.out.println("we store " + xoredKeywords.size() + " keywords");
        for (Number160 key : xoredKeywords) {
            peers[10].put(key).object((Object)keyTerm).start().awaitUninterruptibly();
        }
        Number160 key1Keyword = Number160.createHash((String)"Communication");
        Number160 termKey = ExampleSearch.findReference(peers[20], key1Keyword.xor(key2Keyword = Number160.createHash((String)"Systems")));
        if (termKey != null) {
            FutureGet futureGet = peers[10].get(termKey).start();
            futureGet.awaitUninterruptibly();
            System.out.println("searched (xor) for [Communication and Systems], found " + futureGet.data().object());
        } else {
            System.out.println("searched (xor) for [Communication and Systems], nothing found");
        }
    }

    private static void exampleBloomfilerSearch(PeerDHT[] peers) throws IOException, ClassNotFoundException {
        String[] keywords;
        Number160 keyTerm = Number160.createHash((String)TERM);
        for (String keyword : keywords = TERM.split(" ")) {
            Number160 keyKeyword = Number160.createHash((String)keyword);
            peers[10].put(keyKeyword).object((Object)keyTerm).start().awaitUninterruptibly();
        }
        Number160 termKey = ExampleSearch.findReference(peers[20], Number160.createHash((String)"Communication"), Number160.createHash((String)"Systems"));
        if (termKey != null) {
            FutureGet futureGet = peers[10].get(termKey).start();
            futureGet.awaitUninterruptibly();
            System.out.println("searched (bf) for [Communication and Systems], found " + futureGet.data().object());
        } else {
            System.out.println("searched (bf) for [Communication and Systems], nothing found");
        }
    }

    private static Number160 findReference(PeerDHT peer, String keyword) throws ClassNotFoundException, IOException {
        Number160 keyKeyword = Number160.createHash((String)keyword);
        FutureGet futureGet = peer.get(keyKeyword).start();
        futureGet.awaitUninterruptibly();
        if (futureGet.data() == null) {
            return null;
        }
        Number160 termKey = (Number160)futureGet.data().object();
        return termKey;
    }

    private static Number160 findReference(PeerDHT peer, Number160 keyKeyword) throws ClassNotFoundException, IOException {
        FutureGet futureGet = peer.get(keyKeyword).start();
        futureGet.awaitUninterruptibly();
        Data data = futureGet.data();
        if (data != null && data.object() != null) {
            return (Number160)futureGet.data().object();
        }
        return null;
    }

    private static Number160 findReference(PeerDHT peer, Number160 key1Keyword, Number160 key2Keyword) throws ClassNotFoundException, IOException {
        FutureDigest futureDigest = peer.digest(key1Keyword).returnAllBloomFilter().start();
        futureDigest.awaitUninterruptibly();
        SimpleBloomFilter contentBF = futureDigest.digest().contentBloomFilter();
        System.err.println("bf:" + contentBF.getBitSet());
        FutureGet futureGet = peer.get(key2Keyword).all().contentBloomFilter(contentBF).start();
        futureGet.awaitUninterruptibly();
        Data data = futureGet.data();
        if (data != null && data.object() != null) {
            return (Number160)futureGet.data().object();
        }
        return null;
    }
}

