/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import java.util.Random;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.futures.FutureDirect;
import net.tomp2p.nat.FutureRelayNAT;
import net.tomp2p.nat.PeerBuilderNAT;
import net.tomp2p.nat.PeerNAT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.RelayClientConfig;
import net.tomp2p.relay.tcp.TCPRelayClientConfig;
import net.tomp2p.rpc.ObjectDataReply;

public class ExampleHoleP {
    public static Peer master;
    public static Peer unreachable1;
    public static Peer unreachable2;
    public static final Random RND;
    public static final int PORT = 4001;
    public static final int NUMBER_OF_NODES = 5;
    public static final int IDLE_UDP_SECONDS = 30;
    public static int numberOfHoles;
    public static int numberOfPunches;

    public static void main(String[] args) throws Exception {
        ExampleHoleP.setUp(args);
        FutureDirect fd = unreachable1.sendDirect(unreachable2.peerAddress()).forceUDP(true).object((Object)"What is the meaning of life?").start();
        System.err.println(unreachable1.peerID().toString() + ": Request sent to peer with peerId = " + unreachable2.peerID().toString());
        fd.awaitUninterruptibly();
        if (!fd.isSuccess()) {
            throw new Exception(fd.failedReason());
        }
        System.err.println(unreachable1.peerID().toString() + ": Answer received from peer with peerId = " + unreachable2.peerID().toString() + "!");
        System.err.println(unreachable1.peerID().toString() + ": Message = " + (String)fd.object());
        ExampleHoleP.shutdown();
    }

    private static void setUp(String[] args) throws IOException {
        if (args.length > 0) {
            if (args.length > 1) {
                try {
                    numberOfHoles = Integer.parseInt(args[0]);
                    numberOfPunches = Integer.parseInt(args[1]);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    numberOfHoles = Integer.parseInt(args[0]);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
        master = new PeerBuilder(Number160.createHash((int)RND.nextInt())).ports(4001).start();
        new PeerBuilderNAT(master).start();
        System.err.println("Relay peer with PeerAddress = " + master.peerAddress().toString() + "bootstrapped!");
        unreachable1 = ExampleHoleP.setUpRelayingWithNewPeer();
        unreachable2 = ExampleHoleP.setUpRelayingWithNewPeer();
        System.err.println("Bootstrap and Relay Setup Done!");
    }

    public static Peer setUpRelayingWithNewPeer() throws IOException {
        Peer unreachable = new PeerBuilder(Number160.createHash((int)RND.nextInt())).ports(4002).start();
        PeerAddress pa = unreachable.peerBean().serverPeerAddress();
        pa = pa.changeFirewalledTCP(true).changeFirewalledUDP(true);
        unreachable.peerBean().serverPeerAddress(pa);
        FutureBootstrap futureBootstrap = unreachable.bootstrap().peerAddress(master.peerAddress()).start();
        futureBootstrap.awaitUninterruptibly();
        PeerNAT uNat = new PeerBuilderNAT(unreachable).holePNumberOfHolePunches(numberOfPunches).holePNumberOfHoles(numberOfHoles).start();
        FutureRelayNAT frn = uNat.startRelay((RelayClientConfig)new TCPRelayClientConfig(), master.peerAddress());
        frn.awaitUninterruptibly();
        System.err.println("unreachable peer with PeerAddress = " + unreachable.peerAddress().toString() + " bootstrapped!");
        ExampleHoleP.setObjectDataReply(unreachable);
        return unreachable;
    }

    public static void setObjectDataReply(final Peer unreachable) {
        unreachable.objectDataReply(new ObjectDataReply(){

            public Object reply(PeerAddress sender, Object request) throws Exception {
                System.err.println(unreachable.peerID().toString() + ": New request received from Peer with peerId = " + sender.peerId().toString() + "!");
                System.err.println(unreachable.peerID().toString() + ": Message = " + (String)request);
                return "42";
            }
        });
    }

    public static void shutdown() {
        System.err.println("shutdown initiated!");
        BaseFuture bf0 = master.shutdown();
        bf0.awaitUninterruptibly();
        System.err.println("shutdown master done!");
        BaseFuture bf1 = unreachable1.shutdown();
        bf1.awaitUninterruptibly();
        System.err.println("shutdown unreachable1 done!");
        BaseFuture bf2 = unreachable2.shutdown();
        bf2.awaitUninterruptibly();
        System.err.println("shutdown unreachable 2 done!");
    }

    static {
        RND = new Random();
        numberOfHoles = 3;
        numberOfPunches = 3;
    }
}

