/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.message.TrackerData;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ObjectDataReply;
import net.tomp2p.storage.Data;
import net.tomp2p.tracker.FutureTracker;
import net.tomp2p.tracker.PeerBuilderTracker;
import net.tomp2p.tracker.PeerTracker;
import net.tomp2p.utils.Utils;

public final class ExampleTracker {
    private ExampleTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Peer[] peers = null;
        try {
            int peerNr = 100;
            int port = 4001;
            peers = ExampleUtils.createAndAttachNodes(100, 4001);
            ExampleUtils.bootstrap(peers);
            MyPeer[] myPeers = ExampleTracker.wrap(peers);
            ExampleTracker.example(myPeers);
        }
        finally {
            if (peers != null && peers[0] != null) {
                peers[0].shutdown();
            }
        }
    }

    private static MyPeer[] wrap(Peer[] peers) {
        MyPeer[] retVal = new MyPeer[peers.length];
        for (int i = 0; i < peers.length; ++i) {
            retVal[i] = new MyPeer(new PeerBuilderTracker(peers[i]).verifyPeersOnTracker(false).start());
        }
        return retVal;
    }

    private static void example(MyPeer[] peers) throws IOException, ClassNotFoundException {
        System.out.println("Setup: we have " + peers.length + " peers; peers[12] (Urs) knows Jan, peers[24] (Tom) knows Urs, peers[42] (Pat) knows Tom");
        int peer12 = 12;
        int peer24 = 24;
        int peer42 = 42;
        peers[12].announce("Urs", "Jan");
        peers[24].announce("Tom", "Urs");
        peers[42].announce("Pat", "Tom");
        System.out.println("peers[24] (Tom) wants to know the friends of Urs");
        peers[24].list("Urs");
    }

    private static class MyPeer {
        private final PeerTracker peer;
        private final Map<Number160, String> friends = new HashMap<Number160, String>();

        public MyPeer(PeerTracker peer) {
            this.peer = peer;
            this.setReplyHandler(peer);
        }

        public void announce(String nickName, String friendName) throws IOException {
            this.friends.put(Number160.createHash((String)nickName), friendName);
            this.announce();
        }

        public void announce() throws IOException {
            for (Map.Entry<Number160, String> entry : this.friends.entrySet()) {
                ArrayList<String> tmp = new ArrayList<String>(this.friends.values());
                this.peer.addTracker(entry.getKey()).attachement(new Data(Utils.encodeJavaObject((Object)tmp.toArray(new String[0])))).start().awaitUninterruptibly();
            }
        }

        public void list(String nickName) throws IOException, ClassNotFoundException {
            Number160 key = Number160.createHash((String)nickName);
            FutureTracker futureTracker = this.peer.getTracker(key).start();
            futureTracker.awaitUninterruptibly();
            System.err.println(futureTracker.failedReason());
            Collection trackerDatas = futureTracker.trackers();
            for (TrackerData trackerData : trackerDatas) {
                for (Data attachement : trackerData.peerAddresses().values()) {
                    String[] attachements;
                    for (String s1 : attachements = (String[])attachement.object()) {
                        System.out.println("this peers' (" + nickName + ") friend:" + s1);
                    }
                }
            }
            System.out.println("Tracker reports that " + trackerDatas.size() + " peer(s) are his friends");
        }

        private void setReplyHandler(PeerTracker peer) {
            peer.peer().objectDataReply(new ObjectDataReply(){

                public Object reply(PeerAddress sender, Object request) throws Exception {
                    if (request != null && request instanceof Number160) {
                        return MyPeer.this.friends.get((Number160)request);
                    }
                    return null;
                }
            });
        }
    }
}

