/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import net.tomp2p.dht.FutureDigest;
import net.tomp2p.dht.FuturePut;
import net.tomp2p.dht.PeerBuilderDHT;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.p2p.PeerBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.replication.IndirectReplication;
import net.tomp2p.storage.Data;

public final class ExampleIndirectReplication {
    private static final int ONE_SECOND = 1000;

    private ExampleIndirectReplication() {
    }

    public static void main(String[] args) throws Exception {
        ExampleIndirectReplication.exmpleIndirectReplication();
    }

    private static void exmpleIndirectReplication() throws IOException, InterruptedException {
        int port1 = 4001;
        boolean nr1 = true;
        int port2 = 4002;
        int nr2 = 2;
        int port3 = 4003;
        int nr3 = 4;
        PeerDHT peer1 = new PeerBuilderDHT(new PeerBuilder(new Number160(1)).ports(4001).start()).start();
        PeerDHT peer2 = new PeerBuilderDHT(new PeerBuilder(new Number160(2)).ports(4002).start()).start();
        PeerDHT peer3 = new PeerBuilderDHT(new PeerBuilder(new Number160(4)).ports(4003).start()).start();
        new IndirectReplication(peer1).start();
        new IndirectReplication(peer2).start();
        new IndirectReplication(peer3).start();
        PeerDHT[] peers = new PeerDHT[]{peer1, peer2, peer3};
        FuturePut futurePut = peer1.put(new Number160(4)).data(new Data((Object)"store on peer1")).start();
        futurePut.awaitUninterruptibly();
        FutureDigest futureDigest = peer1.digest(new Number160(4)).start();
        futureDigest.awaitUninterruptibly();
        System.out.println("we found the data on " + futureDigest.rawDigest().size() + " peers");
        peer1.peer().bootstrap().peerAddress(peer2.peerAddress()).start();
        peer1.peer().bootstrap().peerAddress(peer3.peerAddress()).start();
        Thread.sleep(1000L);
        futureDigest = peer1.digest(new Number160(4)).start();
        futureDigest.awaitUninterruptibly();
        System.out.println("we found the data on " + futureDigest.rawDigest().size() + " peers");
        ExampleIndirectReplication.shutdown(peers);
    }

    private static void shutdown(PeerDHT[] peers) {
        for (PeerDHT peer : peers) {
            peer.shutdown();
        }
    }
}

