/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import net.tomp2p.dht.FutureGet;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.futures.FutureDirect;
import net.tomp2p.message.TrackerData;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ObjectDataReply;
import net.tomp2p.storage.Data;
import net.tomp2p.tracker.FutureTracker;
import net.tomp2p.tracker.PeerTracker;

public class ExampleFastSS {
    public static void main(String[] args) throws Exception {
        PeerDHT[] peers1 = null;
        PeerTracker[] peers2 = null;
        try {
            peers1 = ExampleUtils.createAndAttachPeersDHT(100, 4001);
            peers2 = ExampleUtils.createAndAttachPeersTracker(peers1);
            ExampleUtils.bootstrap(peers1);
            ExampleFastSS.exampleFastSS(peers1, peers2);
        }
        finally {
            peers1[0].shutdown();
        }
    }

    private static void exampleFastSS(PeerDHT[] peers1, PeerTracker[] peers2) throws IOException, ClassNotFoundException {
        String title = "another great song";
        final Number160 key = Number160.createHash((String)"another great song");
        peers2[15].addTracker(key).start().awaitUninterruptibly();
        peers1[15].peer().objectDataReply(new ObjectDataReply(){

            public Object reply(PeerAddress sender, Object request) throws Exception {
                if (request instanceof Number160 && ((Number160)request).equals((Object)key)) {
                    return "another great song: and here comes the mp3 file";
                }
                return null;
            }
        });
        for (String word : "another great song".split(" ")) {
            for (String deletion : ExampleFastSS.deletion(word)) {
                Object[] tmp = new Object[]{key, word, deletion};
                peers1[15].put(Number160.createHash((String)deletion)).data(new Data((Object)tmp)).start().awaitUninterruptibly();
            }
        }
        System.out.println("we have indexed [another great song]");
        for (String deletion : ExampleFastSS.deletion("greet")) {
            FutureGet futureGet = (FutureGet)peers1[20].get(Number160.createHash((String)deletion)).start().awaitUninterruptibly();
            if (!futureGet.isSuccess()) continue;
            Object[] tmp = (Object[])futureGet.data().object();
            Number160 key1 = (Number160)tmp[0];
            FutureTracker futureTracker = peers2[20].getTracker(key1).start();
            futureTracker.awaitUninterruptibly();
            PeerAddress peerAddress = (PeerAddress)((TrackerData)futureTracker.trackers().iterator().next()).peerAddresses().keySet().iterator().next();
            FutureDirect futureDirect = peers1[20].peer().sendDirect(peerAddress).object((Object)key1).start();
            futureDirect.awaitUninterruptibly();
            System.out.println("we searched for \"greet\", and found [" + tmp[2] + "], ed(" + tmp[1] + ",greet)=" + ExampleFastSS.ld((String)tmp[1], "greet") + ". After downloading we get [" + futureDirect.object() + "]");
        }
    }

    private static Collection<String> deletion(String word) {
        HashSet<String> resultSet = new HashSet<String>();
        resultSet.add(word);
        StringBuilder sb = new StringBuilder(word);
        for (int i = 0; i < word.length(); ++i) {
            char c = sb.charAt(i);
            sb.deleteCharAt(i);
            resultSet.add(sb.toString());
            sb.insert(i, c);
        }
        return resultSet;
    }

    private static int ld(String s, String t) {
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        int i = 0;
        while (i <= n) {
            d[i][0] = i++;
        }
        int j = 1;
        while (j <= m) {
            d[0][j] = j++;
        }
        for (i = 1; i <= n; ++i) {
            char sc = s.charAt(i - 1);
            for (int j2 = 1; j2 <= m; ++j2) {
                int v = d[i - 1][j2 - 1];
                if (t.charAt(j2 - 1) != sc) {
                    ++v;
                }
                d[i][j2] = Math.min(Math.min(d[i - 1][j2] + 1, d[i][j2 - 1] + 1), v);
            }
        }
        return d[n][m];
    }
}

