/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.net.InetAddress;
import java.util.Random;
import net.tomp2p.futures.FutureDiscover;
import net.tomp2p.nat.FutureNAT;
import net.tomp2p.nat.FutureRelayNAT;
import net.tomp2p.nat.PeerBuilderNAT;
import net.tomp2p.nat.PeerNAT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.RelayClientConfig;
import net.tomp2p.relay.tcp.TCPRelayClientConfig;

public class ExampleNAT {
    private static final int PORT_SERVER = 4000;
    private static final int PORT_CLIENT = 4000;

    public static void startServer() throws Exception {
        Random r = new Random(42L);
        Peer peer = new PeerBuilder(new Number160(r)).ports(4000).start();
        System.out.println("peer started.");
        while (true) {
            for (PeerAddress pa : peer.peerBean().peerMap().all()) {
                System.out.println("peer online (TCP):" + pa);
            }
            Thread.sleep(2000L);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            ExampleNAT.startClientNAT(args[0]);
        } else {
            ExampleNAT.startServer();
        }
    }

    public static void startClientNAT(String ip) throws Exception {
        Random r = new Random(43L);
        Peer peer = new PeerBuilder(new Number160(r)).ports(4000).behindFirewall().start();
        PeerNAT peerNAT = new PeerBuilderNAT(peer).start();
        PeerAddress pa = new PeerAddress(Number160.ZERO, InetAddress.getByName(ip), 4000, 4000);
        FutureDiscover fd = peer.discover().peerAddress(pa).start();
        FutureNAT fn = peerNAT.startSetupPortforwarding(fd);
        FutureRelayNAT frn = peerNAT.startRelay((RelayClientConfig)new TCPRelayClientConfig(), fd, fn);
        frn.awaitUninterruptibly();
        if (fd.isSuccess()) {
            System.out.println("found that my outside address is " + fd.peerAddress());
        } else {
            System.out.println("failed " + fd.failedReason());
        }
        if (fn.isSuccess()) {
            System.out.println("NAT success: " + fn.peerAddress());
        } else {
            System.out.println("failed " + fn.failedReason());
        }
        peer.shutdown();
    }
}

