/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples.relay;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.tomp2p.dht.FutureGet;
import net.tomp2p.dht.FuturePut;
import net.tomp2p.dht.FutureRemove;
import net.tomp2p.dht.GetBuilder;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.dht.PutBuilder;
import net.tomp2p.dht.RemoveBuilder;
import net.tomp2p.examples.relay.DHTQueryStatistics;
import net.tomp2p.p2p.RequestP2PConfiguration;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.storage.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryNode {
    private static final Logger LOG = LoggerFactory.getLogger(QueryNode.class);
    private final Random random;
    private final long avgSleepTime;
    private final int avgBytes;
    private final List<Number160> validKeys;
    private final RoutingConfiguration routingConfig;
    private final RequestP2PConfiguration requestConfig;
    private final PeerDHT peerDHT;
    private final DHTQueryStatistics putStats;
    private final DHTQueryStatistics getStats;
    private final DHTQueryStatistics rmvStats;

    public QueryNode(PeerDHT peerDHT, long avgSleepTime, int avgBytes) {
        this.peerDHT = peerDHT;
        this.avgSleepTime = avgSleepTime;
        this.avgBytes = avgBytes;
        this.random = new Random();
        this.validKeys = new ArrayList<Number160>();
        this.routingConfig = new RoutingConfiguration(5, 1, 1);
        this.requestConfig = new RequestP2PConfiguration(1, 1, 0);
        this.putStats = new DHTQueryStatistics();
        this.getStats = new DHTQueryStatistics();
        this.rmvStats = new DHTQueryStatistics();
    }

    public void queryRandom() throws IOException, ClassNotFoundException {
        this.sleep();
        while (true) {
            if (this.random.nextBoolean()) {
                Number160 key = new Number160(this.random);
                this.put(key);
                this.sleep();
            }
            if (this.random.nextBoolean() && !this.validKeys.isEmpty()) {
                this.get(this.validKeys.get(this.random.nextInt(this.validKeys.size())));
                this.sleep();
            }
            if (this.random.nextBoolean() && !this.validKeys.isEmpty()) {
                this.remove(this.validKeys.get(this.random.nextInt(this.validKeys.size())));
                this.sleep();
            }
            this.printStats();
        }
    }

    public void querySpecific(Number640 key) throws IOException, ClassNotFoundException {
        this.sleep();
        while (true) {
            this.put(key);
            this.sleep();
            this.get(key);
            this.sleep();
            this.remove(key);
            this.sleep();
            this.printStats();
        }
    }

    private void printStats() {
        StringBuilder sb = new StringBuilder("*************************\n");
        sb.append("Stats of peer ").append(this.peerDHT.peer().peerID()).append(": \n");
        sb.append("PUT:  count: ").append(this.putStats.getCount()).append(" | avgtime: ").append(this.putStats.getAverageTime()).append("ms | success: ").append(this.putStats.getSuccessRate()).append("\n");
        sb.append("GET:  count: ").append(this.putStats.getCount()).append(" | avgtime: ").append(this.getStats.getAverageTime()).append("ms | success: ").append(this.getStats.getSuccessRate()).append("\n");
        sb.append("RMV:  count: ").append(this.putStats.getCount()).append(" | avgtime: ").append(this.rmvStats.getAverageTime()).append("ms | success: ").append(this.rmvStats.getSuccessRate());
        System.out.println(sb.toString());
    }

    private void put(Number160 key) {
        this.put(new Number640(key, Number160.ZERO, Number160.ZERO, Number160.ZERO));
        this.validKeys.add(key);
    }

    public boolean put(Number640 key) {
        Data data = this.generateRandomData();
        long startTime = System.currentTimeMillis();
        FuturePut futurePut = (FuturePut)((PutBuilder)((PutBuilder)this.peerDHT.put(key.locationKey()).domainKey(key.domainKey()).versionKey(key.versionKey()).data(key.contentKey(), data).routingConfiguration(this.routingConfig)).requestP2PConfiguration(this.requestConfig)).start().awaitUninterruptibly();
        this.putStats.report(System.currentTimeMillis() - startTime, futurePut.isSuccess());
        LOG.debug("Put of {} bytes is success = {}. Reason: {}", new Object[]{data.length(), futurePut.isSuccess(), futurePut.failedReason()});
        return futurePut.isSuccess();
    }

    private void get(Number160 key) {
        Data data = this.get(new Number640(key, Number160.ZERO, Number160.ZERO, Number160.ZERO));
        byte[] byteArray = new byte[]{};
        if (data != null) {
            byteArray = data.toBytes();
        }
        LOG.debug("Got {} bytes", (Object)byteArray.length);
    }

    public Data get(Number640 key) {
        long startTime = System.currentTimeMillis();
        FutureGet futureGet = (FutureGet)((GetBuilder)((GetBuilder)((GetBuilder)((GetBuilder)this.peerDHT.get(key.locationKey()).contentKey(key.contentKey()).domainKey(key.domainKey())).versionKey(key.versionKey())).routingConfiguration(this.routingConfig)).requestP2PConfiguration(this.requestConfig)).start().awaitUninterruptibly();
        this.putStats.report(System.currentTimeMillis() - startTime, futureGet.isSuccess());
        LOG.debug("Get is success {}. Reason: {}", (Object)futureGet.isSuccess(), (Object)futureGet.failedReason());
        if (futureGet.data() != null) {
            return futureGet.data();
        }
        return null;
    }

    private void remove(Number160 key) {
        if (this.remove(new Number640(key, Number160.ZERO, Number160.ZERO, Number160.ZERO))) {
            LOG.debug("Removed object {}", (Object)key);
            this.validKeys.remove(key);
        } else {
            LOG.warn("Could not remove object {}", (Object)key);
        }
    }

    public boolean remove(Number640 key) {
        long startTime = System.currentTimeMillis();
        FutureRemove remove = (FutureRemove)((RemoveBuilder)((RemoveBuilder)((RemoveBuilder)((RemoveBuilder)this.peerDHT.remove(key.locationKey()).contentKey(key.contentKey()).domainKey(key.domainKey())).versionKey(key.versionKey())).routingConfiguration(this.routingConfig)).requestP2PConfiguration(this.requestConfig)).start().awaitUninterruptibly();
        this.putStats.report(System.currentTimeMillis() - startTime, remove.isSuccess());
        LOG.debug("Remove is success {}. Reason: {}", (Object)remove.isSuccess(), (Object)remove.failedReason());
        return remove.isSuccess();
    }

    private void sleep() {
        long sleepTime = (long)((this.random.nextGaussian() + 1.0) * (double)this.avgSleepTime);
        if (sleepTime < 0L) {
            sleepTime = 0L;
        }
        LOG.debug("Sleeping for {}ms", (Object)sleepTime);
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Data generateRandomData() {
        int bytes = Math.abs((int)((this.random.nextGaussian() + 1.0) * (double)this.avgBytes));
        byte[] data = new byte[bytes];
        this.random.nextBytes(data);
        return new Data(data);
    }

    public String toString() {
        return "Query-Peer " + this.peerDHT.peerID();
    }
}

