/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples.relay;

import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.dht.FuturePut;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.dht.PutBuilder;
import net.tomp2p.examples.relay.DHTQueryStatistics;
import net.tomp2p.p2p.RequestP2PConfiguration;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.storage.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicQueryNode {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicQueryNode.class);
    private final Random random;
    private final RoutingConfiguration routingConfig;
    private final RequestP2PConfiguration requestConfig;
    private final PeerDHT peerDHT;
    private final DHTQueryStatistics putStats;
    private final long intervalMS;
    private final long durationMS;
    private final int numBytes;

    public PeriodicQueryNode(PeerDHT peerDHT, long intervalMS, long durationMS, int numBytes) {
        this.peerDHT = peerDHT;
        this.intervalMS = intervalMS;
        this.durationMS = durationMS;
        this.numBytes = numBytes;
        this.random = new Random();
        this.routingConfig = new RoutingConfiguration(5, 1, 1);
        this.requestConfig = new RequestP2PConfiguration(1, 1, 0);
        this.putStats = new DHTQueryStatistics();
    }

    public void start(Number160 locationKey) {
        Timer timer = new Timer();
        Putter putter = new Putter(locationKey);
        timer.scheduleAtFixedRate((TimerTask)putter, 0L, this.intervalMS);
        try {
            Thread.sleep(this.durationMS);
        }
        catch (InterruptedException e) {
            LOG.error("Cannot sleep", (Throwable)e);
        }
        timer.cancel();
        timer.purge();
        long timeout = this.peerDHT.peer().connectionBean().channelServer().channelServerConfiguration().slowResponseTimeoutSeconds() * 1000;
        try {
            Thread.sleep((long)((double)timeout * 1.2));
        }
        catch (InterruptedException e) {
            LOG.error("Cannot wait for last threads", (Throwable)e);
        }
        for (int i = 0; i < putter.getRunning(); ++i) {
            this.putStats.report(timeout, false);
        }
        this.printStats();
    }

    private void printStats() {
        StringBuilder sb = new StringBuilder("*************************\n");
        sb.append("Stats of peer ").append(this.peerDHT.peer().peerID()).append(": \n");
        sb.append("Duration: ").append(this.durationMS).append("ms").append(" | Interval: ").append(this.intervalMS).append("ms | Data size: ").append(this.numBytes).append("bytes\n");
        sb.append("PUT:  count: ").append(this.putStats.getCount()).append(" | avgtime: ").append(this.putStats.getAverageTime()).append("ms | success: ").append(this.putStats.getSuccessRate()).append("\n");
        System.out.println(sb.toString());
    }

    public boolean put(Number640 key) {
        Data data = this.generateRandomData();
        long startTime = System.currentTimeMillis();
        FuturePut futurePut = (FuturePut)((PutBuilder)((PutBuilder)this.peerDHT.put(key.locationKey()).domainKey(key.domainKey()).versionKey(key.versionKey()).data(key.contentKey(), data).routingConfiguration(this.routingConfig)).requestP2PConfiguration(this.requestConfig)).start().awaitUninterruptibly();
        this.putStats.report(System.currentTimeMillis() - startTime, futurePut.isSuccess());
        LOG.debug("Put of {} bytes is success = {}. Reason: {}", new Object[]{data.length(), futurePut.isSuccess(), futurePut.failedReason()});
        return futurePut.isSuccess();
    }

    private Data generateRandomData() {
        byte[] data = new byte[this.numBytes];
        this.random.nextBytes(data);
        return new Data(data);
    }

    public String toString() {
        return "Query-Peer " + this.peerDHT.peerID();
    }

    private class Putter
    extends TimerTask {
        private final Number160 locationKey;
        private final AtomicInteger running;

        public Putter(Number160 locationKey) {
            this.locationKey = locationKey;
            this.running = new AtomicInteger();
        }

        @Override
        public void run() {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Putter.this.running.incrementAndGet();
                    PeriodicQueryNode.this.put(new Number640(Putter.this.locationKey, Number160.ZERO, new Number160(PeriodicQueryNode.this.random), Number160.ZERO));
                    Putter.this.running.decrementAndGet();
                }
            }).start();
        }

        public int getRunning() {
            return this.running.get();
        }
    }
}

