/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples.relay;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.tomp2p.connection.ChannelServerConfiguration;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.Ports;
import net.tomp2p.dht.PeerBuilderDHT;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.dht.StorageLayer;
import net.tomp2p.examples.relay.LoggingStorageLayer;
import net.tomp2p.examples.relay.PeriodicQueryNode;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.nat.FutureRelayNAT;
import net.tomp2p.nat.PeerBuilderNAT;
import net.tomp2p.nat.PeerNAT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerBuilder;
import net.tomp2p.p2p.builder.BootstrapBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.RelayConfig;
import net.tomp2p.relay.RelayType;
import net.tomp2p.relay.android.MessageBufferConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleRelaySituation {
    private static final Logger LOG = LoggerFactory.getLogger(ExampleRelaySituation.class);
    private static final int NUM_RELAY_PEERS = 1;
    private static final int NUM_MOBILE_PEERS = 0;
    private static final int NUM_QUERY_PEERS = 1;
    private static final int RELAY_START_PORT = 4000;
    private static final int MOBILE_START_PORT = 8000;
    private static final int QUERY_START_PORT = 6000;
    private static final int MAX_MESSAGE_NUM = Integer.MAX_VALUE;
    private static final long MAX_BUFFER_SIZE = Long.MAX_VALUE;
    private static final long MAX_BUFFER_AGE = 15000L;
    private static final int GCM_SEND_RETIES = 5;
    private static final RelayType RELAY_TYPE = RelayType.ANDROID;
    private final String gcmKey;
    private static final long INTERVAL_MS = 2000L;
    private static final long DURATION_MS = 300000L;
    private static final int DATA_SIZE_BYTES = 128;
    private final List<PeerNAT> relays;
    private final List<PeerNAT> mobiles;
    private final List<PeriodicQueryNode> queries;
    private final MessageBufferConfiguration bufferConfig;

    public static void main(String[] args) throws IOException, InterruptedException {
        String gcmKey = null;
        if (args.length < 1) {
            LOG.warn("Need the GCM Authentication key as arguments when using with Android.");
        } else {
            LOG.debug("{} is the GCM key used", (Object)args[0]);
            gcmKey = args[0];
        }
        ExampleRelaySituation situation = new ExampleRelaySituation(gcmKey);
        situation.setupPeers();
        Thread.sleep(5000L);
        situation.startQueries();
    }

    public ExampleRelaySituation(String gcmKey) {
        this.gcmKey = gcmKey;
        assert (1 <= RELAY_TYPE.maxRelayCount());
        this.relays = new ArrayList<PeerNAT>(1);
        this.mobiles = new ArrayList<PeerNAT>(0);
        this.queries = new ArrayList<PeriodicQueryNode>(1);
        this.bufferConfig = new MessageBufferConfiguration().bufferAgeLimit(15000L).bufferCountLimit(Integer.MAX_VALUE).bufferSizeLimit(Long.MAX_VALUE);
    }

    public void setupPeers() throws IOException {
        Peer peer;
        int i;
        ConnectionBean.DEFAULT_CONNECTION_TIMEOUT_TCP = 10000;
        ConnectionBean.DEFAULT_TCP_IDLE_SECONDS = 10;
        ConnectionBean.DEFAULT_UDP_IDLE_SECONDS = 10;
        for (i = 0; i < 1; ++i) {
            peer = this.createPeer(4000 + i);
            new PeerBuilderDHT(peer).storageLayer((StorageLayer)new LoggingStorageLayer("RELAY", false)).start();
            PeerNAT peerNAT = new PeerBuilderNAT(peer).bufferConfiguration(this.bufferConfig).gcmAuthenticationKey(this.gcmKey).gcmSendRetries(5).start();
            this.relays.add(peerNAT);
            LOG.debug("Relay peer {} started", (Object)i);
        }
        for (i = 0; i < 0; ++i) {
            peer = this.createPeer(8000 + i);
            this.bootstrap(peer);
            new PeerBuilderDHT(peer).storageLayer((StorageLayer)new LoggingStorageLayer("UNREACHABLE", true)).start();
            LOG.debug("Connecting to Relay now");
            HashSet<PeerAddress> relayAddresses = new HashSet<PeerAddress>(1);
            for (PeerNAT relay : this.relays) {
                relayAddresses.add(relay.peer().peerAddress());
            }
            PeerBuilderNAT builder = new PeerBuilderNAT(peer);
            RelayConfig config = RELAY_TYPE == RelayType.ANDROID ? RelayConfig.Android((String)"abc").manualRelays(relayAddresses) : RelayConfig.OpenTCP();
            PeerNAT peerNat = builder.start();
            FutureRelayNAT futureRelayNAT = (FutureRelayNAT)peerNat.startRelay(config, this.relays.get(0).peer().peerAddress()).awaitUninterruptibly();
            if (!futureRelayNAT.isSuccess()) {
                LOG.error("Cannot connect to Relay(s). Reason: {}", (Object)futureRelayNAT.failedReason());
                return;
            }
            this.mobiles.add(peerNat);
            LOG.debug("Mobile peer {} connected to DHT and Relay(s)", (Object)i);
        }
        for (i = 0; i < 1; ++i) {
            peer = this.createPeer(6000 + i);
            this.bootstrap(peer);
            PeerDHT peerDHT = new PeerBuilderDHT(peer).storageLayer((StorageLayer)new LoggingStorageLayer("QUERY", false)).start();
            new PeerBuilderNAT(peer).start();
            this.queries.add(new PeriodicQueryNode(peerDHT, 2000L, 300000L, 128));
            LOG.debug("Query peer {} started", (Object)i);
        }
    }

    private Peer createPeer(int port) throws IOException {
        ChannelServerConfiguration csc = PeerBuilder.createDefaultChannelServerConfiguration();
        csc.ports(new Ports(port, port));
        csc.portsForwarding(new Ports(port, port));
        csc.connectionTimeoutTCPMillis(10000);
        csc.idleTCPSeconds(10);
        csc.idleUDPSeconds(10);
        return new PeerBuilder(new Number160(port)).ports(port).channelServerConfiguration(csc).start();
    }

    private boolean bootstrap(Peer peer) throws UnknownHostException {
        InetAddress bootstrapTo = InetAddress.getLocalHost();
        BootstrapBuilder bootstrapBuilder = peer.bootstrap().inetAddress(bootstrapTo).ports(4000);
        BaseFuture bootstrap = bootstrapBuilder.start().awaitUninterruptibly();
        if (bootstrap == null) {
            LOG.error("Cannot bootstrap");
            return false;
        }
        if (bootstrap.isFailed()) {
            LOG.error("Cannot bootstrap. Reason: {}", (Object)bootstrap.failedReason());
            return false;
        }
        LOG.debug("Peer has bootstrapped");
        return true;
    }

    public void startQueries() {
        for (PeriodicQueryNode queryPeer : this.queries) {
            queryPeer.start(this.getRandomUnreachable().peerId());
        }
    }

    private PeerAddress getRandomUnreachable() {
        Random rnd = new Random();
        if (this.mobiles.isEmpty()) {
            ArrayList<PeerNAT> relayCopy = new ArrayList<PeerNAT>(this.relays);
            while (!relayCopy.isEmpty()) {
                PeerNAT relay = (PeerNAT)relayCopy.remove(rnd.nextInt(relayCopy.size()));
                Set unreachablePeers = relay.relayRPC().unreachablePeers();
                Iterator iterator = unreachablePeers.iterator();
                if (!iterator.hasNext()) continue;
                return (PeerAddress)iterator.next();
            }
            return null;
        }
        return this.mobiles.get(rnd.nextInt(0)).peer().peerAddress();
    }
}

