/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.ChannelClientConfiguration;
import net.tomp2p.connection.StandardProtocolFamily;
import net.tomp2p.dht.FutureGet;
import net.tomp2p.dht.FuturePut;
import net.tomp2p.dht.FutureRemove;
import net.tomp2p.dht.PeerBuilderDHT;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.examples.SeedNodeForTesting;
import net.tomp2p.examples.utils.Repeat;
import net.tomp2p.examples.utils.RepeatRule;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.futures.FutureDirect;
import net.tomp2p.futures.FutureDiscover;
import net.tomp2p.futures.FuturePeerConnection;
import net.tomp2p.nat.FutureNAT;
import net.tomp2p.nat.FutureRelayNAT;
import net.tomp2p.nat.PeerBuilderNAT;
import net.tomp2p.nat.PeerNAT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapConfiguration;
import net.tomp2p.relay.RelayConfig;
import net.tomp2p.rpc.ObjectDataReply;
import net.tomp2p.storage.Data;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomP2PTests {
    private static final Logger log = LoggerFactory.getLogger(TomP2PTests.class);
    static final String BOOTSTRAP_NODE_ID = "seed";
    private static final String BOOTSTRAP_NODE_IP = "127.0.0.1";
    static final int BOOTSTRAP_NODE_PORT = 5000;
    private static final ConnectionType FORCED_CONNECTION_TYPE = ConnectionType.DIRECT;
    private static final PeerAddress BOOTSTRAP_NODE_ADDRESS;
    private static final int STRESS_TEST_COUNT = 10;
    private Peer peer;
    private PeerDHT peer1DHT;
    private PeerDHT peer2DHT;
    private int client1Port;
    private int client2Port;
    private ConnectionType resolvedConnectionType;
    @Rule
    public RepeatRule repeatRule = new RepeatRule();

    @Before
    public void setUp() {
        this.client1Port = 7777;
        this.client2Port = 7778;
    }

    @After
    public void tearDown() {
        BaseFuture future;
        if (this.peer1DHT != null) {
            future = this.peer1DHT.shutdown();
            future.awaitUninterruptibly();
            future.awaitListenersUninterruptibly();
        }
        if (this.peer2DHT != null) {
            future = this.peer2DHT.shutdown();
            future.awaitUninterruptibly();
            future.awaitListenersUninterruptibly();
        }
        if (this.peer != null) {
            future = this.peer.shutdown();
            future.awaitUninterruptibly();
            future.awaitListenersUninterruptibly();
        }
    }

    @Test
    @Repeat(value=10)
    public void bootstrapInUnknownMode() throws Exception {
        if (FORCED_CONNECTION_TYPE == ConnectionType.UNKNOWN) {
            this.peer = this.bootstrapInUnknownMode(this.client1Port);
            Assert.assertNotNull((Object)this.peer);
        }
    }

    @Test
    @Repeat(value=10)
    public void testBootstrapDirectConnection() throws Exception {
        if (FORCED_CONNECTION_TYPE == ConnectionType.DIRECT) {
            this.peer = this.bootstrapDirectConnection(this.client1Port);
            Assert.assertNotNull((Object)this.peer);
        }
    }

    @Test
    @Repeat(value=10)
    public void testBootstrapWithPortForwarding() throws Exception {
        if (FORCED_CONNECTION_TYPE == ConnectionType.NAT) {
            this.peer = this.bootstrapWithPortForwarding(this.client1Port);
            Assert.assertNotNull((Object)this.peer);
        }
    }

    @Test
    @Repeat(value=10)
    public void testBootstrapInRelayMode() throws Exception {
        if (FORCED_CONNECTION_TYPE == ConnectionType.RELAY) {
            this.peer = this.bootstrapInRelayMode(this.client1Port);
            Assert.assertNotNull((Object)this.peer);
        }
    }

    @Test
    @Repeat(value=10)
    public void testPut() throws Exception {
        this.peer1DHT = this.getDHTPeer(this.client1Port);
        FuturePut futurePut = this.peer1DHT.put(Number160.createHash((String)"key")).data(new Data((Object)"hallo")).start();
        futurePut.awaitUninterruptibly();
        Assert.assertTrue((boolean)futurePut.isSuccess());
    }

    @Test
    @Repeat(value=10)
    public void testPutGet() throws Exception {
        this.peer1DHT = this.getDHTPeer(this.client1Port);
        FuturePut futurePut = this.peer1DHT.put(Number160.createHash((String)"key")).data(new Data((Object)"hallo")).start();
        futurePut.awaitUninterruptibly();
        Assert.assertTrue((boolean)futurePut.isSuccess());
        this.peer2DHT = this.getDHTPeer(this.client2Port);
        FutureGet futureGet = this.peer2DHT.get(Number160.createHash((String)"key")).start();
        futureGet.awaitUninterruptibly();
        Assert.assertTrue((boolean)futureGet.isSuccess());
        Assert.assertEquals((Object)"hallo", (Object)futureGet.data().object());
    }

    @Test
    @Repeat(value=10)
    public void testAdd() throws Exception {
        this.peer1DHT = this.getDHTPeer(this.client1Port);
        FuturePut futurePut1 = this.peer1DHT.add(Number160.createHash((String)"locationKey")).data(new Data((Object)"hallo1")).start();
        futurePut1.awaitUninterruptibly();
        Assert.assertTrue((boolean)futurePut1.isSuccess());
    }

    @Test
    @Repeat(value=10)
    public void testAddGet() throws Exception {
        this.peer1DHT = this.getDHTPeer(this.client1Port);
        FuturePut futurePut1 = this.peer1DHT.add(Number160.createHash((String)"locationKey")).data(new Data((Object)"hallo1")).start();
        futurePut1.awaitUninterruptibly();
        Assert.assertTrue((boolean)futurePut1.isSuccess());
        FuturePut futurePut2 = this.peer1DHT.add(Number160.createHash((String)"locationKey")).data(new Data((Object)"hallo2")).start();
        futurePut2.awaitUninterruptibly();
        Assert.assertTrue((boolean)futurePut2.isSuccess());
        this.peer2DHT = this.getDHTPeer(this.client2Port);
        FutureGet futureGet = this.peer2DHT.get(Number160.createHash((String)"locationKey")).all().start();
        futureGet.awaitUninterruptibly();
        Assert.assertTrue((boolean)futureGet.isSuccess());
        Assert.assertTrue((boolean)futureGet.dataMap().values().contains(new Data((Object)"hallo1")));
        Assert.assertTrue((boolean)futureGet.dataMap().values().contains(new Data((Object)"hallo2")));
        Assert.assertTrue((futureGet.dataMap().values().size() == 2 ? 1 : 0) != 0);
    }

    @Test
    @Repeat(value=10)
    public void testAddGetWithReconnect() throws Exception {
        this.peer1DHT = this.getDHTPeer(this.client1Port);
        FuturePut futurePut1 = this.peer1DHT.add(Number160.createHash((String)"locationKey")).data(new Data((Object)"hallo1")).start();
        futurePut1.awaitUninterruptibly();
        Assert.assertTrue((boolean)futurePut1.isSuccess());
        FuturePut futurePut2 = this.peer1DHT.add(Number160.createHash((String)"locationKey")).data(new Data((Object)"hallo2")).start();
        futurePut2.awaitUninterruptibly();
        Assert.assertTrue((boolean)futurePut2.isSuccess());
        this.peer2DHT = this.getDHTPeer(this.client2Port);
        FutureGet futureGet = this.peer2DHT.get(Number160.createHash((String)"locationKey")).all().start();
        futureGet.awaitUninterruptibly();
        Assert.assertTrue((boolean)futureGet.isSuccess());
        Assert.assertTrue((boolean)futureGet.dataMap().values().contains(new Data((Object)"hallo1")));
        Assert.assertTrue((boolean)futureGet.dataMap().values().contains(new Data((Object)"hallo2")));
        Assert.assertTrue((futureGet.dataMap().values().size() == 2 ? 1 : 0) != 0);
        BaseFuture future = this.peer2DHT.shutdown();
        future.awaitUninterruptibly();
        future.awaitListenersUninterruptibly();
        this.peer2DHT = this.getDHTPeer(this.client2Port);
        futureGet = this.peer2DHT.get(Number160.createHash((String)"locationKey")).all().start();
        futureGet.awaitUninterruptibly();
        Assert.assertTrue((boolean)futureGet.isSuccess());
        Assert.assertTrue((boolean)futureGet.dataMap().values().contains(new Data((Object)"hallo1")));
        Assert.assertTrue((boolean)futureGet.dataMap().values().contains(new Data((Object)"hallo2")));
        Assert.assertTrue((futureGet.dataMap().values().size() == 2 ? 1 : 0) != 0);
        futureGet = this.peer1DHT.get(Number160.createHash((String)"locationKey")).all().start();
        futureGet.awaitUninterruptibly();
        Assert.assertTrue((boolean)futureGet.isSuccess());
        Assert.assertTrue((boolean)futureGet.dataMap().values().contains(new Data((Object)"hallo1")));
        Assert.assertTrue((boolean)futureGet.dataMap().values().contains(new Data((Object)"hallo2")));
        Assert.assertTrue((futureGet.dataMap().values().size() == 2 ? 1 : 0) != 0);
        future = this.peer2DHT.shutdown();
        future.awaitUninterruptibly();
        future.awaitListenersUninterruptibly();
        future = this.peer1DHT.shutdown();
        future.awaitUninterruptibly();
        future.awaitListenersUninterruptibly();
        this.peer1DHT = this.getDHTPeer(this.client1Port);
        futureGet = this.peer1DHT.get(Number160.createHash((String)"locationKey")).all().start();
        futureGet.awaitUninterruptibly();
        Assert.assertTrue((boolean)futureGet.isSuccess());
        Assert.assertTrue((boolean)futureGet.dataMap().values().contains(new Data((Object)"hallo1")));
        Assert.assertTrue((boolean)futureGet.dataMap().values().contains(new Data((Object)"hallo2")));
        Assert.assertTrue((futureGet.dataMap().values().size() == 2 ? 1 : 0) != 0);
        this.peer2DHT = this.getDHTPeer(this.client2Port);
        futureGet = this.peer2DHT.get(Number160.createHash((String)"locationKey")).all().start();
        futureGet.awaitUninterruptibly();
        Assert.assertTrue((boolean)futureGet.isSuccess());
        Assert.assertTrue((boolean)futureGet.dataMap().values().contains(new Data((Object)"hallo1")));
        Assert.assertTrue((boolean)futureGet.dataMap().values().contains(new Data((Object)"hallo2")));
        Assert.assertTrue((futureGet.dataMap().values().size() == 2 ? 1 : 0) != 0);
    }

    @Test
    @Repeat(value=10)
    public void testParallelStartupWithPutGet() throws IOException, ClassNotFoundException, InterruptedException {
        PeerMapConfiguration pmc1 = new PeerMapConfiguration(Number160.createHash((String)"peer1")).peerNoVerification();
        PeerMap pm1 = new PeerMap(pmc1);
        PeerDHT peer1 = new PeerBuilderDHT(new PeerBuilder(Number160.createHash((String)"peer1")).ports(3006).peerMap(pm1).start()).start();
        PeerMapConfiguration pmc2 = new PeerMapConfiguration(Number160.createHash((String)"peer2")).peerNoVerification();
        PeerMap pm2 = new PeerMap(pmc2);
        PeerDHT peer2 = new PeerBuilderDHT(new PeerBuilder(Number160.createHash((String)"peer2")).ports(3007).peerMap(pm2).start()).start();
        PeerAddress masterPeerAddress = new PeerAddress(Number160.createHash((String)BOOTSTRAP_NODE_ID), BOOTSTRAP_NODE_IP, 5000, 5000);
        FutureBootstrap fb1 = peer1.peer().bootstrap().peerAddress(masterPeerAddress).start();
        FutureBootstrap fb2 = peer2.peer().bootstrap().peerAddress(masterPeerAddress).start();
        final AtomicBoolean peer1Done = new AtomicBoolean();
        final AtomicBoolean peer2Done = new AtomicBoolean();
        fb1.addListener((BaseFutureListener)new BaseFutureListener<BaseFuture>(){

            public void operationComplete(BaseFuture future) throws Exception {
                peer1Done.set(true);
            }

            public void exceptionCaught(Throwable t) throws Exception {
            }
        });
        fb2.addListener((BaseFutureListener)new BaseFutureListener<BaseFuture>(){

            public void operationComplete(BaseFuture future) throws Exception {
                peer2Done.set(true);
            }

            public void exceptionCaught(Throwable t) throws Exception {
            }
        });
        while (!peer1Done.get() || !peer2Done.get()) {
            Thread.sleep(100L);
        }
        System.err.println(fb1.failedReason());
        Assert.assertTrue((boolean)fb1.isSuccess());
        System.err.println(fb2.failedReason());
        Assert.assertTrue((boolean)fb2.isSuccess());
        FuturePut fp = (FuturePut)peer1.put(Number160.ONE).object((Object)"test").start().awaitUninterruptibly();
        Assert.assertTrue((boolean)fp.isSuccess());
        FutureGet fg1 = (FutureGet)peer1.get(Number160.ONE).start().awaitUninterruptibly();
        Assert.assertTrue((boolean)fg1.isSuccess());
        Assert.assertEquals((Object)"test", (Object)fg1.data().object());
        FutureGet fg2 = (FutureGet)peer2.get(Number160.ONE).start().awaitUninterruptibly();
        Assert.assertTrue((boolean)fg2.isSuccess());
        Assert.assertEquals((Object)"test", (Object)fg2.data().object());
        peer1.shutdown().awaitUninterruptibly().awaitListenersUninterruptibly();
        peer2.shutdown().awaitUninterruptibly().awaitListenersUninterruptibly();
        peer1 = new PeerBuilderDHT(new PeerBuilder(Number160.createHash((String)"peer1")).ports(3005).start()).start();
        peer2 = new PeerBuilderDHT(new PeerBuilder(Number160.createHash((String)"peer2")).ports(3006).start()).start();
        fb1 = peer1.peer().bootstrap().peerAddress(masterPeerAddress).start();
        fb2 = peer2.peer().bootstrap().peerAddress(masterPeerAddress).start();
        peer1Done.set(false);
        peer2Done.set(false);
        final PeerDHT _peer1 = peer1;
        fb1.addListener((BaseFutureListener)new BaseFutureListener<BaseFuture>(){

            public void operationComplete(BaseFuture future) throws Exception {
                peer1Done.set(true);
                final FutureGet fg = _peer1.get(Number160.ONE).start();
                fg.addListener((BaseFutureListener)new BaseFutureListener<BaseFuture>(){

                    public void operationComplete(BaseFuture future) throws Exception {
                        Assert.assertTrue((boolean)fg.isSuccess());
                        Assert.assertEquals((Object)"test", (Object)fg.data().object());
                    }

                    public void exceptionCaught(Throwable t) throws Exception {
                    }
                });
            }

            public void exceptionCaught(Throwable t) throws Exception {
            }
        });
        final PeerDHT _peer2 = peer2;
        fb2.addListener((BaseFutureListener)new BaseFutureListener<BaseFuture>(){

            public void operationComplete(BaseFuture future) throws Exception {
                peer2Done.set(true);
                final FutureGet fg = _peer2.get(Number160.ONE).start();
                fg.addListener((BaseFutureListener)new BaseFutureListener<BaseFuture>(){

                    public void operationComplete(BaseFuture future) throws Exception {
                        Assert.assertTrue((boolean)fg.isSuccess());
                        Assert.assertEquals((Object)"test", (Object)fg.data().object());
                    }

                    public void exceptionCaught(Throwable t) throws Exception {
                    }
                });
            }

            public void exceptionCaught(Throwable t) throws Exception {
            }
        });
        while (!peer1Done.get() || !peer2Done.get()) {
            Thread.sleep(100L);
        }
        System.err.println(fb1.failedReason());
        Assert.assertTrue((boolean)fb1.isSuccess());
        System.err.println(fb2.failedReason());
        Assert.assertTrue((boolean)fb2.isSuccess());
        fg1 = (FutureGet)peer1.get(Number160.ONE).start().awaitUninterruptibly();
        Assert.assertTrue((boolean)fg1.isSuccess());
        Assert.assertEquals((Object)"test", (Object)fg1.data().object());
        fg2 = (FutureGet)peer2.get(Number160.ONE).start().awaitUninterruptibly();
        Assert.assertTrue((boolean)fg2.isSuccess());
        Assert.assertEquals((Object)"test", (Object)fg2.data().object());
        peer1.shutdown().awaitUninterruptibly();
        peer2.shutdown().awaitUninterruptibly();
    }

    @Test
    @Repeat(value=10)
    public void testAddRemove() throws Exception {
        if (FORCED_CONNECTION_TYPE == ConnectionType.DIRECT) {
            SeedNodeForTesting.main(null);
        }
        this.peer1DHT = this.getDHTPeer(this.client1Port);
        FuturePut futurePut1 = this.peer1DHT.add(Number160.createHash((String)"locationKey")).data(new Data((Object)"hallo1")).start();
        futurePut1.awaitUninterruptibly();
        futurePut1.awaitListenersUninterruptibly();
        Assert.assertTrue((boolean)futurePut1.isSuccess());
        FuturePut futurePut2 = this.peer1DHT.add(Number160.createHash((String)"locationKey")).data(new Data((Object)"hallo2")).start();
        futurePut2.awaitUninterruptibly();
        futurePut2.awaitListenersUninterruptibly();
        Assert.assertTrue((boolean)futurePut2.isSuccess());
        this.peer2DHT = this.getDHTPeer(this.client2Port);
        Number160 contentKey = new Data((Object)"hallo1").hash();
        FutureRemove futureRemove = this.peer2DHT.remove(Number160.createHash((String)"locationKey")).contentKey(contentKey).start();
        futureRemove.awaitUninterruptibly();
        futureRemove.awaitListenersUninterruptibly();
        Assert.assertTrue((boolean)futureRemove.isSuccess());
        FutureGet futureGet = this.peer2DHT.get(Number160.createHash((String)"locationKey")).all().start();
        futureGet.awaitUninterruptibly();
        Assert.assertTrue((boolean)futureGet.isSuccess());
        if (!futureGet.dataMap().values().contains(new Data((Object)"hallo2"))) {
            log.error("raw data has the value, the evaluated not!");
        }
        Assert.assertTrue((boolean)futureGet.dataMap().values().contains(new Data((Object)"hallo2")));
        Assert.assertTrue((futureGet.dataMap().values().size() == 1 ? 1 : 0) != 0);
        if (FORCED_CONNECTION_TYPE == ConnectionType.DIRECT) {
            SeedNodeForTesting.stop();
        }
    }

    @Test
    @Repeat(value=10)
    public void testSendDirectBetweenLocalPeers() throws Exception {
        if (FORCED_CONNECTION_TYPE != ConnectionType.NAT && this.resolvedConnectionType != ConnectionType.RELAY) {
            this.peer1DHT = this.getDHTPeer(this.client1Port);
            this.peer2DHT = this.getDHTPeer(this.client2Port);
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            final StringBuilder result = new StringBuilder();
            this.peer2DHT.peer().objectDataReply(new ObjectDataReply(){

                public Object reply(PeerAddress sender, Object request) throws Exception {
                    countDownLatch.countDown();
                    result.append(String.valueOf(request));
                    return "pong";
                }
            });
            FuturePeerConnection futurePeerConnection = this.peer1DHT.peer().createPeerConnection(this.peer2DHT.peer().peerAddress(), 500);
            FutureDirect futureDirect = this.peer1DHT.peer().sendDirect(futurePeerConnection).object((Object)"hallo").start();
            futureDirect.awaitUninterruptibly();
            countDownLatch.await(3L, TimeUnit.SECONDS);
            if (countDownLatch.getCount() > 0L) {
                Assert.fail((String)"The test method did not complete successfully!");
            }
            Assert.assertEquals((Object)"hallo", (Object)result.toString());
            Assert.assertTrue((boolean)futureDirect.isSuccess());
            log.debug(futureDirect.object().toString());
            Assert.assertEquals((Object)"pong", (Object)futureDirect.object());
        }
    }

    @Test
    @Repeat(value=10)
    public void testSendDirectToSeedNode() throws Exception {
        this.peer1DHT = this.getDHTPeer(this.client1Port);
        FuturePeerConnection futurePeerConnection = this.peer1DHT.peer().createPeerConnection(BOOTSTRAP_NODE_ADDRESS, 500);
        FutureDirect futureDirect = this.peer1DHT.peer().sendDirect(futurePeerConnection).object((Object)"hallo").start();
        futureDirect.awaitUninterruptibly();
        Assert.assertTrue((boolean)futureDirect.isSuccess());
        Assert.assertEquals((Object)"pong", (Object)futureDirect.object());
    }

    private Peer bootstrapDirectConnection(int clientPort) {
        Peer peer = null;
        Number160 peerId = new Number160(new Random(43L));
        PeerMapConfiguration pmc = new PeerMapConfiguration(peerId).peerNoVerification();
        PeerMap pm = new PeerMap(pmc);
        ChannelClientConfiguration cc = PeerBuilder.createDefaultChannelClientConfiguration();
        cc.maxPermitsTCP(100);
        cc.maxPermitsUDP(100);
        try {
            peer = new PeerBuilder(peerId).bindings(this.getBindings()).channelClientConfiguration(cc).peerMap(pm).ports(clientPort).start();
        }
        catch (IOException e) {
            log.warn("Discover with direct connection failed. Exception = " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        FutureDiscover futureDiscover = peer.discover().peerAddress(BOOTSTRAP_NODE_ADDRESS).start();
        futureDiscover.awaitUninterruptibly();
        if (futureDiscover.isSuccess()) {
            log.info("Discover with direct connection successful. Address = " + futureDiscover.peerAddress());
            FutureBootstrap futureBootstrap = peer.bootstrap().peerAddress(BOOTSTRAP_NODE_ADDRESS).start();
            futureBootstrap.awaitUninterruptibly();
            if (futureBootstrap.isSuccess()) {
                return peer;
            }
            log.warn("Bootstrap failed. Reason = " + futureBootstrap.failedReason());
            peer.shutdown().awaitUninterruptibly();
            return null;
        }
        log.warn("Discover with direct connection failed. Reason = " + futureDiscover.failedReason());
        peer.shutdown().awaitUninterruptibly();
        return null;
    }

    private Peer bootstrapWithPortForwarding(int clientPort) {
        Number160 peerId = new Number160(new Random(43L));
        Peer peer = null;
        try {
            peer = new PeerBuilder(peerId).bindings(this.getBindings()).behindFirewall().ports(clientPort).start();
        }
        catch (IOException e) {
            log.warn("Discover with automatic port forwarding failed. Exception = " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        PeerNAT peerNAT = new PeerBuilderNAT(peer).start();
        FutureDiscover futureDiscover = peer.discover().peerAddress(BOOTSTRAP_NODE_ADDRESS).start();
        FutureNAT futureNAT = peerNAT.startSetupPortforwarding(futureDiscover);
        futureNAT.awaitUninterruptibly();
        if (futureNAT.isSuccess()) {
            log.info("Automatic port forwarding is setup. Now we do a futureDiscover again. Address = " + futureNAT.peerAddress());
            futureDiscover = peer.discover().peerAddress(BOOTSTRAP_NODE_ADDRESS).start();
            futureDiscover.awaitUninterruptibly();
            if (futureDiscover.isSuccess()) {
                log.info("Discover with automatic port forwarding was successful. Address = " + futureDiscover.peerAddress());
                FutureBootstrap futureBootstrap = peer.bootstrap().peerAddress(BOOTSTRAP_NODE_ADDRESS).start();
                futureBootstrap.awaitUninterruptibly();
                if (futureBootstrap.isSuccess()) {
                    return peer;
                }
                log.warn("Bootstrap failed. Reason = " + futureBootstrap.failedReason());
                peer.shutdown().awaitUninterruptibly();
                return null;
            }
            log.warn("Discover with automatic port forwarding failed. Reason = " + futureDiscover.failedReason());
            peer.shutdown().awaitUninterruptibly();
            return null;
        }
        log.warn("StartSetupPortforwarding failed. Reason = " + futureNAT.failedReason());
        peer.shutdown().awaitUninterruptibly();
        return null;
    }

    private Peer bootstrapInRelayMode(int clientPort) {
        Number160 peerId = new Number160(new Random(43L));
        Peer peer = null;
        try {
            peer = new PeerBuilder(peerId).bindings(this.getBindings()).behindFirewall().ports(clientPort).start();
        }
        catch (IOException e) {
            log.error("Bootstrap using relay failed. Exception " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        PeerNAT peerNAT = new PeerBuilderNAT(peer).start();
        FutureDiscover futureDiscover = peer.discover().peerAddress(BOOTSTRAP_NODE_ADDRESS).start();
        FutureNAT futureNAT = peerNAT.startSetupPortforwarding(futureDiscover);
        FutureRelayNAT futureRelayNAT = peerNAT.startRelay(RelayConfig.OpenTCP(), futureDiscover, futureNAT);
        futureRelayNAT.awaitUninterruptibly();
        if (futureRelayNAT.isSuccess()) {
            log.info("Bootstrap using relay was successful. Address = " + peer.peerAddress());
            FutureBootstrap futureBootstrap = peer.bootstrap().peerAddress(BOOTSTRAP_NODE_ADDRESS).start();
            futureBootstrap.awaitUninterruptibly();
            if (futureBootstrap.isSuccess()) {
                return peer;
            }
            log.warn("Bootstrap failed. Reason = " + futureBootstrap.failedReason());
            peer.shutdown().awaitUninterruptibly();
            return null;
        }
        log.error("Bootstrap using relay failed " + futureRelayNAT.failedReason());
        futureRelayNAT.shutdown();
        peer.shutdown().awaitUninterruptibly();
        return null;
    }

    private Peer bootstrapInUnknownMode(int clientPort) {
        this.resolvedConnectionType = ConnectionType.DIRECT;
        Peer peer = this.bootstrapDirectConnection(clientPort);
        if (peer != null) {
            return peer;
        }
        this.resolvedConnectionType = ConnectionType.NAT;
        peer = this.bootstrapWithPortForwarding(clientPort);
        if (peer != null) {
            return peer;
        }
        this.resolvedConnectionType = ConnectionType.RELAY;
        peer = this.bootstrapInRelayMode(clientPort);
        if (peer != null) {
            return peer;
        }
        log.error("Bootstrapping in all modes failed. Is bootstrap node with address " + BOOTSTRAP_NODE_ADDRESS + "running?");
        this.resolvedConnectionType = null;
        return peer;
    }

    private PeerDHT getDHTPeer(int clientPort) {
        Peer peer = FORCED_CONNECTION_TYPE == ConnectionType.DIRECT ? this.bootstrapDirectConnection(clientPort) : (FORCED_CONNECTION_TYPE == ConnectionType.NAT ? this.bootstrapWithPortForwarding(clientPort) : (FORCED_CONNECTION_TYPE == ConnectionType.RELAY ? this.bootstrapInRelayMode(clientPort) : this.bootstrapInUnknownMode(clientPort)));
        if (peer == null) {
            Assert.fail((String)("Bootstrapping failed. forcedConnectionType= " + (Object)((Object)FORCED_CONNECTION_TYPE) + " resolvedConnectionType= " + (Object)((Object)this.resolvedConnectionType) + "." + " Is bootstrap node  with address " + BOOTSTRAP_NODE_ADDRESS + "running?"));
        }
        return new PeerBuilderDHT(peer).start();
    }

    private Bindings getBindings() {
        Bindings bindings = new Bindings();
        bindings.addProtocol(StandardProtocolFamily.INET);
        return bindings;
    }

    static {
        try {
            BOOTSTRAP_NODE_ADDRESS = new PeerAddress(Number160.createHash((String)BOOTSTRAP_NODE_ID), BOOTSTRAP_NODE_IP, 5000, 5000);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum ConnectionType {
        UNKNOWN,
        DIRECT,
        NAT,
        RELAY;

    }
}

