/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.examples.Query;
import net.tomp2p.futures.FutureGet;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.Data;

public class ExampleUnQL {
    private static final String QUERY_1 = "INSERT INTO abc VALUE 1234;";
    private static final String QUERY_2 = "INSERT INTO abc VALUE 3.141592653;";
    private static final String QUERY_3 = "INSERT INTO abc VALUE \"This is a string\";";
    private static final String QUERY_4 = "INSERT INTO abc VALUE [\"this\",\"is\",\"an\",\"array\"];";
    private static final String QUERY_5 = "INSERT INTO abc VALUE { \"type\": \"message\", \"content\": \"This is an object\" };";
    private static final String QUERY_6 = "SELECT FROM abc;";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Peer master = null;
        try {
            Peer[] peers = ExampleUtils.createAndAttachNodes(100, 4001);
            master = peers[0];
            ExampleUtils.bootstrap(peers);
            ExampleUnQL.exampleUnQL(peers);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            master.shutdown();
        }
    }

    private static void exampleUnQL(Peer[] peers) throws IOException, ClassNotFoundException {
        ExampleUnQL.execute(peers[22], new Query(QUERY_1));
        ExampleUnQL.execute(peers[23], new Query(QUERY_2));
        ExampleUnQL.execute(peers[24], new Query(QUERY_3));
        ExampleUnQL.execute(peers[25], new Query(QUERY_4));
        ExampleUnQL.execute(peers[26], new Query(QUERY_5));
        ExampleUnQL.execute(peers[27], new Query(QUERY_6));
    }

    public static void execute(Peer peer, String query) throws IOException, ClassNotFoundException {
        ExampleUnQL.execute(peer, new Query(query));
    }

    private static void execute(Peer peer, Query query) throws IOException, ClassNotFoundException {
        block6: {
            Number160 locationKey;
            block4: {
                block7: {
                    block5: {
                        locationKey = Number160.createHash((String)query.getCollectionName());
                        if (query.getQueryType() != Query.QueryType.INSERT) break block4;
                        if (query.getValueType() != Query.ValueType.SINGLE) break block5;
                        peer.add(locationKey).setData(new Data((Object)query.getValue())).start().awaitUninterruptibly();
                        break block6;
                    }
                    if (query.getValueType() != Query.ValueType.ARRAY) break block7;
                    for (String value : query.getValues()) {
                        peer.add(locationKey).setData(new Data((Object)value)).start().awaitUninterruptibly();
                    }
                    break block6;
                }
                if (query.getValueType() != Query.ValueType.MAP) break block6;
                HashMap<Number160, Data> dataMap = new HashMap<Number160, Data>();
                for (Map.Entry<String, String> entry : query.getValueMap().entrySet()) {
                    dataMap.put(Number160.createHash((String)entry.getKey()), new Data((Object)entry.getValue()));
                }
                peer.put(locationKey).setDataMapContent(dataMap).start().awaitUninterruptibly();
                break block6;
            }
            if (query.getQueryType() == Query.QueryType.SELECT) {
                FutureGet futureDHT = peer.get(locationKey).setAll().start();
                futureDHT.awaitUninterruptibly();
                for (Map.Entry entry : futureDHT.getDataMap().entrySet()) {
                    System.out.print("key: " + entry.getKey());
                    System.out.println(", value: " + ((Data)entry.getValue()).object());
                }
            }
        }
    }
}

