/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples.relay;

import java.security.PublicKey;
import net.tomp2p.dht.StorageLayer;
import net.tomp2p.dht.StorageMemory;
import net.tomp2p.peers.Number640;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingStorageLayer
extends StorageLayer {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingStorageLayer.class);
    private final String peerName;
    private final boolean accept;

    public LoggingStorageLayer(String peerName, boolean accept) {
        super((Storage)new StorageMemory());
        this.peerName = peerName;
        this.accept = accept;
    }

    public Enum<?> put(Number640 key, Data newData, PublicKey publicKey, boolean putIfAbsent, boolean domainProtection) {
        if (this.accept) {
            LOG.debug("{}: Putting data {} to key {}", new Object[]{this.peerName, newData, key});
            return super.put(key, newData, publicKey, putIfAbsent, domainProtection);
        }
        LOG.debug("{}: Denying to put data {} to key {}", new Object[]{this.peerName, newData, key});
        return StorageLayer.PutStatus.FAILED;
    }
}

