/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.tomp2p.dht.FutureGet;
import net.tomp2p.dht.FuturePut;
import net.tomp2p.dht.PeerBuilderDHT;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.dht.StorageLayer;
import net.tomp2p.dht.StorageMemory;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDirect;
import net.tomp2p.futures.FutureDiscover;
import net.tomp2p.futures.FuturePeerConnection;
import net.tomp2p.nat.FutureNAT;
import net.tomp2p.nat.FutureRelayNAT;
import net.tomp2p.nat.PeerBuilderNAT;
import net.tomp2p.nat.PeerNAT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ObjectDataReply;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.Storage;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicUsecasesInWANTest {
    private static final Logger log = LoggerFactory.getLogger(BasicUsecasesInWANTest.class);
    private static final String CLIENT_IP = "130.60.156.153";
    private static final String SERVER_ID = "tomp2p.net";
    private static final String SERVER_IP = "188.40.119.70";
    private static final int SERVER_PORT = 5000;
    private static final String CLIENT_1_ID = "alice";
    private static final String CLIENT_2_ID = "bob";
    private static final int CLIENT_1_PORT = 6503;
    private static final int CLIENT_2_PORT = 6504;
    private Thread serverThread;

    @Test
    @Ignore
    public void testBootstrap() throws Exception {
        PeerDHT peerDHT = this.startClient(CLIENT_1_ID, 6503);
        log.debug("############# tcpPort = " + peerDHT.peerAddress().tcpPort());
        log.debug("############# udpPort = " + peerDHT.peerAddress().udpPort());
        Assert.assertEquals((Object)"192.168.1.33", (Object)peerDHT.peerAddress().inetAddress().getHostAddress());
        peerDHT.shutdown().awaitUninterruptibly();
    }

    @Test
    @Ignore
    public void testDHT() throws Exception {
        PeerDHT peer1DHT = this.startClient(CLIENT_1_ID, 6503);
        PeerDHT peer2DHT = this.startClient(CLIENT_2_ID, 6504);
        FuturePut futurePut1 = peer1DHT.put(Number160.createHash((String)"key")).data(new Data((Object)"hallo1")).start();
        futurePut1.awaitUninterruptibly();
        FutureGet futureGet2 = peer1DHT.get(Number160.createHash((String)"key")).start();
        futureGet2.awaitUninterruptibly();
        Assert.assertTrue((boolean)futureGet2.isSuccess());
        Assert.assertNotNull((Object)futureGet2.data());
        Assert.assertEquals((Object)"hallo1", (Object)futureGet2.data().object());
        peer1DHT.shutdown().awaitUninterruptibly();
        peer2DHT.shutdown().awaitUninterruptibly();
    }

    @Test
    public void testSendDirect() throws Exception {
        PeerDHT peer1DHT = this.startClient(CLIENT_1_ID, 6503);
        PeerDHT peer2DHT = this.startClient(CLIENT_2_ID, 6504);
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final StringBuilder result = new StringBuilder();
        peer2DHT.peer().objectDataReply(new ObjectDataReply(){

            public Object reply(PeerAddress sender, Object request) throws Exception {
                countDownLatch.countDown();
                result.append(String.valueOf(request));
                return "world";
            }
        });
        log.debug("peer1DHT " + peer1DHT.peerAddress());
        log.debug("peer2DHT " + peer2DHT.peerAddress());
        FuturePeerConnection futurePeerConnection = peer1DHT.peer().createPeerConnection(peer2DHT.peer().peerAddress(), 500);
        FutureDirect futureDirect = peer1DHT.peer().sendDirect(peer2DHT.peer().peerAddress()).object((Object)"hallo").start();
        futureDirect.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDirect>(){

            public void operationComplete(FutureDirect future) throws Exception {
                if (future.isSuccess()) {
                    log.debug("isSuccess");
                } else {
                    log.debug("Failed");
                }
            }
        });
        futureDirect.awaitUninterruptibly();
        countDownLatch.await(5L, TimeUnit.SECONDS);
        if (countDownLatch.getCount() > 0L) {
            Assert.fail((String)"The test method did not complete successfully!");
        }
        peer1DHT.shutdown().awaitUninterruptibly();
        peer2DHT.shutdown().awaitUninterruptibly();
        Assert.assertEquals((Object)"world", (Object)futureDirect.object());
        Assert.assertEquals((Object)"hallo", (Object)result.toString());
    }

    private PeerDHT startClient(String clientId, int clientPort) throws Exception {
        try {
            Peer peer = new PeerBuilder(Number160.createHash((String)clientId)).ports(clientPort).behindFirewall().start();
            PeerDHT peerDHT = new PeerBuilderDHT(peer).storageLayer(new StorageLayer((Storage)new StorageMemory())).start();
            PeerAddress masterNodeAddress = new PeerAddress(Number160.createHash((String)SERVER_ID), SERVER_IP, 5000, 5000);
            FutureDiscover futureDiscover = peer.discover().peerAddress(masterNodeAddress).start();
            futureDiscover.awaitUninterruptibly();
            if (futureDiscover.isSuccess()) {
                log.info("Discover with direct connection successful. Address = " + futureDiscover.peerAddress());
                return peerDHT;
            }
            PeerNAT peerNAT = new PeerBuilderNAT(peer).start();
            FutureNAT futureNAT = peerNAT.startSetupPortforwarding(futureDiscover);
            futureNAT.awaitUninterruptibly();
            if (futureNAT.isSuccess()) {
                log.info("Automatic port forwarding is setup. Address = " + futureNAT.peerAddress());
                return peerDHT;
            }
            FutureRelayNAT futureRelayNAT = peerNAT.startRelay(futureDiscover, futureNAT);
            futureRelayNAT.awaitUninterruptibly();
            if (futureRelayNAT.isSuccess()) {
                log.info("Bootstrap using relay successful. Address = " + peer.peerAddress());
                futureRelayNAT.shutdown();
                peer.shutdown().awaitUninterruptibly();
                return peerDHT;
            }
            log.error("Bootstrap using relay failed " + futureRelayNAT.failedReason());
            Assert.fail((String)("Bootstrap using relay failed " + futureRelayNAT.failedReason()));
            futureRelayNAT.shutdown();
            peer.shutdown().awaitUninterruptibly();
            return null;
        }
        catch (IOException e) {
            log.error("Bootstrap in relay mode failed " + e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Bootstrap in relay mode failed " + e.getMessage()));
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        new BasicUsecasesInWANTest().startBootstrappingSeedNode();
    }

    public void startBootstrappingSeedNode() throws Exception {
        Peer peer = null;
        try {
            peer = new PeerBuilder(Number160.createHash((String)SERVER_ID)).ports(5000).start();
            new PeerBuilderDHT(peer).start();
            new PeerBuilderNAT(peer).start();
            System.out.println("peer started.");
            while (true) {
                for (PeerAddress pa : peer.peerBean().peerMap().all()) {
                    System.out.println("peer online (TCP):" + pa);
                }
                Thread.sleep(2000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

