/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import net.tomp2p.dht.FutureGet;
import net.tomp2p.dht.FuturePut;
import net.tomp2p.dht.GetBuilder;
import net.tomp2p.dht.PeerBuilderDHT;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.dht.PutBuilder;
import net.tomp2p.dht.StorageLayer;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.p2p.PeerBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.Data;
import net.tomp2p.utils.Utils;

public class ExampleDomainProtection {
    final Random rnd = new Random(42L);

    public static void main(String[] args) throws NoSuchAlgorithmException, IOException, ClassNotFoundException {
        ExampleDomainProtection.exampleAllMaster();
        ExampleDomainProtection.exampleNoneMaster();
    }

    public static void exampleAllMaster() throws NoSuchAlgorithmException, IOException, ClassNotFoundException {
        KeyPairGenerator gen = KeyPairGenerator.getInstance("DSA");
        KeyPair pair1 = gen.generateKeyPair();
        KeyPair pair2 = gen.generateKeyPair();
        KeyPair pair3 = gen.generateKeyPair();
        Number160 peer2Owner = Utils.makeSHAHash((byte[])pair2.getPublic().getEncoded());
        PeerDHT peer1 = new PeerBuilderDHT(new PeerBuilder(pair1).ports(4001).start()).start();
        PeerDHT peer2 = new PeerBuilderDHT(new PeerBuilder(pair2).ports(4002).start()).start();
        PeerDHT peer3 = new PeerBuilderDHT(new PeerBuilder(pair3).ports(4003).start()).start();
        PeerDHT[] peers = new PeerDHT[]{peer1, peer2, peer3};
        ExampleUtils.bootstrap(peers);
        ExampleDomainProtection.setProtection(peers, StorageLayer.ProtectionEnable.ALL, StorageLayer.ProtectionMode.MASTER_PUBLIC_KEY);
        FuturePut futurePut = ((PutBuilder)peer1.put(Number160.ONE).data(new Data((Object)"test")).domainKey(peer2Owner).protectDomain()).start();
        futurePut.awaitUninterruptibly();
        System.out.println("stored: " + futurePut.isSuccess() + " -> because no one claimed this domain");
        futurePut = ((PutBuilder)peer3.put(Number160.ONE).data(new Data((Object)"hello")).domainKey(peer2Owner).protectDomain()).start();
        futurePut.awaitUninterruptibly();
        System.out.println("stored: " + futurePut.isSuccess() + " -> becaues peer1 already claimed this domain");
        futurePut = ((PutBuilder)peer2.put(Number160.ONE).data(new Data((Object)"MINE!")).domainKey(peer2Owner).protectDomain()).start();
        futurePut.awaitUninterruptibly();
        System.out.println("stored: " + futurePut.isSuccess() + " -> becaues peer2 is the owner");
        FutureGet futureGet = ((GetBuilder)peer1.get(Number160.ONE).domainKey(peer2Owner)).start();
        futureGet.awaitUninterruptibly();
        System.out.println("we got " + futureGet.data().object());
        ExampleDomainProtection.shutdown(peers);
    }

    public static void exampleNoneMaster() throws NoSuchAlgorithmException, IOException, ClassNotFoundException {
        KeyPairGenerator gen = KeyPairGenerator.getInstance("DSA");
        KeyPair pair1 = gen.generateKeyPair();
        KeyPair pair2 = gen.generateKeyPair();
        KeyPair pair3 = gen.generateKeyPair();
        Number160 peer2Owner = Utils.makeSHAHash((byte[])pair2.getPublic().getEncoded());
        PeerDHT peer1 = new PeerBuilderDHT(new PeerBuilder(pair1).ports(4001).start()).start();
        PeerDHT peer2 = new PeerBuilderDHT(new PeerBuilder(pair2).ports(4002).start()).start();
        PeerDHT peer3 = new PeerBuilderDHT(new PeerBuilder(pair3).ports(4003).start()).start();
        PeerDHT[] peers = new PeerDHT[]{peer1, peer2, peer3};
        ExampleUtils.bootstrap(peers);
        ExampleDomainProtection.setProtection(peers, StorageLayer.ProtectionEnable.NONE, StorageLayer.ProtectionMode.MASTER_PUBLIC_KEY);
        FuturePut futurePut = ((PutBuilder)peer1.put(Number160.ONE).data(new Data((Object)"test")).protectDomain()).domainKey(peer2Owner).start();
        futurePut.awaitUninterruptibly();
        System.out.println("stored: " + futurePut.isSuccess() + " -> because no one can claim domains except the owner, storage ok but no protection");
        futurePut = ((PutBuilder)peer3.put(Number160.ONE).data(new Data((Object)"hello")).protectDomain()).domainKey(peer2Owner).start();
        futurePut.awaitUninterruptibly();
        System.out.println("stored: " + futurePut.isSuccess() + " -> because no one can claim domains except the owner, storage ok but no protection");
        futurePut = ((PutBuilder)peer2.put(Number160.ONE).data(new Data((Object)"MINE!")).protectDomain()).domainKey(peer2Owner).start();
        futurePut.awaitUninterruptibly();
        System.out.println("stored: " + futurePut.isSuccess() + " -> becaues peer2 is the owner");
        FutureGet futureGet = ((GetBuilder)peer1.get(Number160.ONE).domainKey(peer2Owner)).start();
        futureGet.awaitUninterruptibly();
        System.out.println("we got " + futureGet.data().object());
        futurePut = peer3.put(Number160.ONE).domainKey(peer2Owner).data(new Data((Object)"hello")).start();
        futurePut.awaitUninterruptibly();
        System.out.println("stored: " + futurePut.isSuccess() + " -> because this domain is claimed by peer2");
        ExampleDomainProtection.shutdown(peers);
    }

    private static void shutdown(PeerDHT[] peers) {
        for (PeerDHT peer : peers) {
            peer.shutdown();
        }
    }

    private static void setProtection(PeerDHT[] peers, StorageLayer.ProtectionEnable protectionEnable, StorageLayer.ProtectionMode protectionMode) {
        for (PeerDHT peer : peers) {
            peer.storageLayer().protection(protectionEnable, protectionMode, protectionEnable, protectionMode);
        }
    }
}

