/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.StandardProtocolFamily;
import java.util.List;
import java.util.Random;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.connection.DiscoverNetworks;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDiscover;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;

public class ExampleDiscover {
    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            ExampleDiscover.startClient(args[0]);
        } else {
            ExampleDiscover.startServer();
        }
    }

    public static void startServer() throws Exception {
        Random rnd = new Random(43L);
        Bindings b = new Bindings().addProtocol(StandardProtocolFamily.INET).addAddress(InetAddress.getByName("127.0.0.1"));
        Peer master = new PeerBuilder(new Number160(rnd)).ports(4000).bindings(b).start();
        System.out.println("Server started Listening to: " + DiscoverNetworks.discoverInterfaces((Bindings)b));
        System.out.println("address visible to outside is " + master.peerAddress());
        while (true) {
            for (PeerAddress pa : master.peerBean().peerMap().all()) {
                System.out.println("PeerAddress: " + pa);
                FutureChannelCreator fcc = master.connectionBean().reservation().create(1, 1);
                fcc.awaitUninterruptibly();
                ChannelCreator cc = fcc.channelCreator();
                FutureResponse fr1 = master.pingRPC().pingTCP(pa, cc, (ConnectionConfiguration)new DefaultConnectionConfiguration());
                fr1.awaitUninterruptibly();
                if (fr1.isSuccess()) {
                    System.out.println("peer online T:" + pa);
                } else {
                    System.out.println("offline " + pa);
                }
                FutureResponse fr2 = master.pingRPC().pingUDP(pa, cc, (ConnectionConfiguration)new DefaultConnectionConfiguration());
                fr2.awaitUninterruptibly();
                cc.shutdown();
                if (fr2.isSuccess()) {
                    System.out.println("peer online U:" + pa);
                    continue;
                }
                System.out.println("offline " + pa);
            }
            Thread.sleep(1500L);
        }
    }

    public static void startClient(String ipAddress) throws Exception {
        Random rnd = new Random();
        Bindings b = new Bindings().addProtocol(StandardProtocolFamily.INET).addAddress(InetAddress.getByName("127.0.0.1"));
        Peer client = new PeerBuilder(new Number160(rnd)).ports(4001).bindings(b).start();
        System.out.println("Client started and Listening to: " + DiscoverNetworks.discoverInterfaces((Bindings)b));
        System.out.println("address visible to outside is " + client.peerAddress());
        InetAddress address = Inet4Address.getByName(ipAddress);
        int masterPort = 4000;
        PeerAddress pa = new PeerAddress(Number160.ZERO, address, masterPort, masterPort);
        System.out.println("PeerAddress: " + pa);
        FutureDiscover futureDiscover = client.discover().inetAddress(address).ports(masterPort).start();
        futureDiscover.awaitUninterruptibly();
        FutureBootstrap futureBootstrap = client.bootstrap().inetAddress(address).ports(masterPort).start();
        futureBootstrap.awaitUninterruptibly();
        List addressList = client.peerBean().peerMap().all();
        System.out.println(addressList.size());
        if (futureDiscover.isSuccess()) {
            System.out.println("found that my outside address is " + futureDiscover.peerAddress());
        } else {
            System.out.println("failed " + futureDiscover.failedReason());
        }
        client.shutdown();
    }
}

