/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Random;
import net.tomp2p.connection.Bindings;
import net.tomp2p.dht.FutureGet;
import net.tomp2p.dht.FuturePut;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.nat.FutureRelayNAT;
import net.tomp2p.nat.PeerNAT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.Data;

public class ExampleRelay {
    private static final Random rnd = new Random();
    private static final int PORT = 7777;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            Bindings b = new Bindings();
            Peer peer = new PeerBuilder(Number160.createHash((String)"boot")).enableMaintenance(false).ports(7777).bindings(b).start();
            System.err.println("bootstrap peer id: " + peer.peerAddress().peerId());
            new PeerNAT(peer);
            System.err.println("bootstrap peer is running");
            while (true) {
                Thread.sleep(10000L);
                System.err.println(peer.peerBean().peerMap().peerMapVerified());
            }
        }
        if (args.length == 3) {
            int port = rnd.nextInt() % 10000 + 10000;
            PeerDHT peer = new PeerDHT(new PeerBuilder(Number160.createHash((String)args[1])).ports(port).enableMaintenance(false).start());
            System.err.println("put peer id: " + peer.peerAddress().peerId());
            PeerNAT pnat = new PeerNAT(peer.peer());
            InetAddress address = Inet4Address.getByName(args[0]);
            FutureRelayNAT fbn = pnat.bootstrapBuilder(peer.peer().bootstrap().inetAddress(address).ports(7777)).startRelay();
            fbn.awaitUninterruptibly();
            if (fbn.isSuccess()) {
                System.err.println("Successfuly set up relays");
                Thread.sleep(1000L);
            }
            FuturePut fp = peer.put(Number160.createHash((String)args[1])).data(new Data((Object)args[2].toUpperCase())).start();
            System.err.println("hash:" + Number160.createHash((String)args[1]));
            fp.awaitUninterruptibly();
            if (fp.isSuccess()) {
                System.err.println("Successfully stored " + args[1] + ":" + args[2]);
            }
        } else if (args.length == 2) {
            int port = rnd.nextInt() % 10000 + 10000;
            PeerDHT peer = new PeerDHT(new PeerBuilder(Number160.createHash((String)"bla")).enableMaintenance(false).ports(port).start());
            System.err.println("get peer id: " + peer.peerAddress().peerId());
            System.err.println("hash:" + Number160.createHash((String)args[1]));
            PeerNAT pnat = new PeerNAT(peer.peer());
            InetAddress address = Inet4Address.getByName(args[0]);
            FutureRelayNAT fbn = pnat.bootstrapBuilder(peer.peer().bootstrap().inetAddress(address).ports(7777)).startRelay();
            fbn.awaitUninterruptibly();
            if (fbn.isSuccess()) {
                System.err.println("Successfuly set up relays");
            }
            FutureGet fg = peer.get(Number160.createHash((String)args[1])).start();
            fg.awaitUninterruptibly();
            if (fg.isSuccess()) {
                System.err.println("Received: " + fg.data().object());
            } else {
                System.err.println(fg.failedReason());
            }
        }
    }
}

