/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.dht.PutBuilder;
import net.tomp2p.dht.RemoveBuilder;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.p2p.AutomaticFuture;
import net.tomp2p.p2p.Shutdown;
import net.tomp2p.p2p.builder.Builder;
import net.tomp2p.peers.Number160;
import net.tomp2p.replication.DirectReplication;
import net.tomp2p.storage.Data;

public final class ExampleDirectReplication {
    private static final int NINE_SECONDS = 9000;

    private ExampleDirectReplication() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        PeerDHT[] peers = null;
        try {
            int nrPeers = 100;
            int port = 4001;
            peers = ExampleUtils.createAndAttachPeersDHT(100, 4001);
            ExampleUtils.bootstrap(peers);
            ExampleDirectReplication.exmpleDirectReplication(peers);
        }
        finally {
            if (peers != null && peers[0] != null) {
                peers[0].shutdown();
            }
        }
    }

    private static void exmpleDirectReplication(PeerDHT[] peers) throws IOException, InterruptedException {
        PutBuilder putBuilder = peers[1].put(Number160.ONE).data(new Data((Object)"test"));
        DirectReplication replication = new DirectReplication(peers[1].peer());
        Shutdown shutdown = replication.direct((Builder)putBuilder, 1000, -1, new AutomaticFuture(){

            public void futureCreated(BaseFuture future) {
                System.out.println("put again...");
            }
        });
        Thread.sleep(9000L);
        System.out.println("stop replication");
        shutdown.shutdown();
        RemoveBuilder removeBuilder = peers[1].remove(Number160.ONE);
        replication.direct((Builder)removeBuilder, 1000, 9, new AutomaticFuture(){

            public void futureCreated(BaseFuture future) {
                System.out.println("remove again...");
            }
        });
        Thread.sleep(9000L);
        System.out.println("done");
        replication.shutdown().awaitUninterruptibly();
    }
}

