/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import net.tomp2p.dht.FutureGet;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.p2p.PeerBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;

public class ExampleDNS {
    private final PeerDHT peer;

    public ExampleDNS(int nodeId) throws Exception {
        this.peer = new PeerDHT(new PeerBuilder(Number160.createHash((int)nodeId)).ports(4000 + nodeId).start());
        FutureBootstrap fb = this.peer.peer().bootstrap().broadcast(true).ports(4001).start();
        fb.awaitUninterruptibly();
        if (fb.isSuccess()) {
            this.peer.peer().discover().peerAddress((PeerAddress)fb.bootstrapTo().iterator().next()).start().awaitUninterruptibly();
        }
    }

    public static void main(String[] args) throws NumberFormatException, Exception {
        ExampleDNS dns = new ExampleDNS(Integer.parseInt(args[0]));
        if (args.length == 3) {
            dns.store(args[1], args[2]);
        }
        if (args.length == 2) {
            System.out.println("Name:" + args[1] + " IP:" + dns.get(args[1]));
        }
    }

    private String get(String name) throws ClassNotFoundException, IOException {
        FutureGet futureGet = this.peer.get(Number160.createHash((String)name)).start();
        futureGet.awaitUninterruptibly();
        if (futureGet.isSuccess()) {
            return ((Data)futureGet.dataMap().values().iterator().next()).object().toString();
        }
        return "not found";
    }

    private void store(String name, String ip) throws IOException {
        this.peer.put(Number160.createHash((String)name)).data(new Data((Object)ip)).start().awaitUninterruptibly();
    }
}

