/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import net.tomp2p.dht.FutureGet;
import net.tomp2p.dht.FuturePut;
import net.tomp2p.dht.GetBuilder;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.dht.PutBuilder;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.p2p.PeerBuilder;
import net.tomp2p.p2p.RequestP2PConfiguration;
import net.tomp2p.p2p.Statistics;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.storage.Data;

public final class ExampleConsistency {
    private static final Random RND = new Random(5467656537115L);
    private static final RequestP2PConfiguration REQUEST_3 = new RequestP2PConfiguration(3, 10, 0);
    private static final RequestP2PConfiguration REQUEST_6 = new RequestP2PConfiguration(6, 10, 0);

    private ExampleConsistency() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        PeerDHT master = null;
        try {
            int peerNr = 100;
            int port = 4001;
            PeerDHT[] peers = ExampleUtils.createAndAttachPeersDHT(100, 4001);
            master = peers[0];
            ExampleUtils.bootstrap(peers);
            Number160 key1 = new Number160(RND);
            ExampleConsistency.exampleConsistency(key1, peers);
            ExampleConsistency.exampleAttack(key1, peers);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (master != null) {
                master.shutdown();
            }
        }
    }

    private static void exampleConsistency(Number160 key1, PeerDHT[] peers) throws IOException, ClassNotFoundException {
        System.out.println("key is " + key1);
        TreeSet<PeerAddress> set = new TreeSet<PeerAddress>(PeerMap.createComparator((Number160)key1));
        for (PeerDHT peer : peers) {
            set.add(peer.peerAddress());
        }
        System.out.println("closest peer " + set.first());
        int peerStore1 = 22;
        ((PutBuilder)peers[22].put(key1).requestP2PConfiguration(REQUEST_3)).data(new Data((Object)"Test 1")).start().awaitUninterruptibly();
        System.out.println("the following peers go offline");
        int peerOffline1 = 67;
        int peerOffline2 = 40;
        int peerOffline3 = 39;
        System.out.println(peers[67].peerAddress());
        System.out.println(peers[40].peerAddress());
        System.out.println(peers[39].peerAddress());
        peers[67].shutdown().awaitListenersUninterruptibly();
        peers[40].shutdown().awaitListenersUninterruptibly();
        peers[39].shutdown().awaitListenersUninterruptibly();
        int peerGet = 33;
        FuturePut futurePut = ((PutBuilder)peers[22].put(key1).requestP2PConfiguration(REQUEST_3)).data(new Data((Object)"Test 2")).start();
        futurePut.awaitUninterruptibly();
        System.out.println("stored [Test 2] on " + futurePut.rawResult().keySet());
        FutureGet futureGet = peers[33].get(key1).all().start();
        futureGet.awaitUninterruptibly();
        System.out.println("peer[33] got [" + futureGet.data().object() + "] should be [Test 2]");
        peers[67] = new PeerDHT(new PeerBuilder(peers[67].peerID()).masterPeer(peers[0].peer()).start());
        peers[40] = new PeerDHT(new PeerBuilder(peers[40].peerID()).masterPeer(peers[0].peer()).start());
        peers[39] = new PeerDHT(new PeerBuilder(peers[39].peerID()).masterPeer(peers[0].peer()).start());
        peers[67].peer().bootstrap().peerAddress(peers[0].peerAddress()).start().awaitUninterruptibly();
        peers[40].peer().bootstrap().peerAddress(peers[0].peerAddress()).start().awaitUninterruptibly();
        peers[39].peer().bootstrap().peerAddress(peers[0].peerAddress()).start().awaitUninterruptibly();
        System.out.println("The 3 peers are now onlyne again, with the old data");
        Number640 key = new Number640(key1, Number160.ZERO, Number160.ZERO, Number160.ZERO);
        peers[67].storageLayer().put(key, new Data((Object)"Test 1"), null, false, false);
        peers[40].storageLayer().put(key, new Data((Object)"Test 1"), null, false, false);
        peers[39].storageLayer().put(key, new Data((Object)"Test 1"), null, false, false);
        FutureGet futureGet2 = ((GetBuilder)peers[0].get(key1).requestP2PConfiguration(REQUEST_3)).all().start();
        futureGet2.awaitUninterruptibly();
        System.out.println("peer[0] got [" + futureGet2.data().object() + "] should be [Test 2]");
        FutureGet futureGet3 = ((GetBuilder)peers[33].get(key1).requestP2PConfiguration(REQUEST_3)).all().start();
        futureGet3.awaitUninterruptibly();
        System.out.println("peer[33] got [" + futureGet3.data().object() + "] should be [Test 2]");
    }

    private static void exampleAttack(Number160 key1, PeerDHT[] peers) throws IOException, ClassNotFoundException, InterruptedException {
        System.out.println("Lets ATTACK!");
        PeerDHT mpeer1 = new PeerDHT(new PeerBuilder(new Number160("0x4bca44fd09461db1981e387e99e41e7d22d06893")).masterPeer(peers[0].peer()).start());
        PeerDHT mpeer2 = new PeerDHT(new PeerBuilder(new Number160("0x4bca44fd09461db1981e387e99e41e7d22d06892")).masterPeer(peers[0].peer()).start());
        PeerDHT mpeer3 = new PeerDHT(new PeerBuilder(new Number160("0x4bca44fd09461db1981e387e99e41e7d22d06895")).masterPeer(peers[0].peer()).start());
        mpeer1.peer().bootstrap().peerAddress(peers[0].peerAddress()).start().awaitUninterruptibly();
        mpeer2.peer().bootstrap().peerAddress(peers[0].peerAddress()).start().awaitUninterruptibly();
        mpeer3.peer().bootstrap().peerAddress(peers[0].peerAddress()).start().awaitUninterruptibly();
        Number640 key = new Number640(key1, Number160.ZERO, Number160.ZERO, Number160.ZERO);
        mpeer1.storageLayer().put(key, new Data((Object)"attack, attack, attack!"), null, false, false);
        mpeer2.storageLayer().put(key, new Data((Object)"attack, attack, attack!"), null, false, false);
        Thread.sleep(3000L);
        FutureGet futureGet = ((GetBuilder)peers[0].get(key1).all().requestP2PConfiguration(REQUEST_3)).start();
        futureGet.awaitUninterruptibly();
        System.out.println("peer[0] got " + futureGet.data().object());
        for (Map.Entry entry : futureGet.rawData().entrySet()) {
            System.out.print("got from (3)" + entry.getKey());
            System.out.println(entry.getValue());
        }
        FutureGet futureGet1 = ((GetBuilder)peers[0].get(key1).all().requestP2PConfiguration(REQUEST_6)).start();
        futureGet1.awaitUninterruptibly();
        System.out.println("peer[0] got " + futureGet1.data().object());
        Statistics statistics = new Statistics(peers[0].peerBean().peerMap());
        System.out.println("average distance: " + statistics.avgGap());
        for (Map.Entry entry : futureGet1.rawData().entrySet()) {
            System.out.print("got from (6)" + entry.getKey());
            System.out.print(" distance: " + key1.xor(((PeerAddress)entry.getKey()).peerId()).doubleValue());
            System.out.println(" " + entry.getValue());
        }
    }
}

