/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureGet;
import net.tomp2p.futures.FuturePut;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.GetBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.Data;

public final class ExamplePutGet {
    private static final Random RND = new Random(42L);
    private static final int PEER_NR_1 = 30;
    private static final int PEER_NR_2 = 77;

    private ExamplePutGet() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Peer master = null;
        int nrPeers = 100;
        int port = 4001;
        int waitingTime = 250;
        try {
            Peer[] peers = ExampleUtils.createAndAttachNodes(100, 4001);
            ExampleUtils.bootstrap(peers);
            master = peers[0];
            Number160 nr = new Number160(RND);
            ExamplePutGet.examplePutGet(peers, nr);
            ExamplePutGet.examplePutGetConfig(peers, nr);
            ExamplePutGet.exampleGetBlocking(peers, nr);
            ExamplePutGet.exampleGetNonBlocking(peers, nr);
            Thread.sleep(250L);
            ExamplePutGet.exampleAddGet(peers);
        }
        finally {
            if (master != null) {
                master.shutdown();
            }
        }
    }

    private static void examplePutGet(Peer[] peers, Number160 nr) throws IOException, ClassNotFoundException {
        FuturePut futurePut = peers[30].put(nr).setData(new Data((Object)"hallo")).start();
        futurePut.awaitUninterruptibly();
        System.out.println("peer 30 stored [key: " + nr + ", value: \"hallo\"]");
        FutureGet futureGet = peers[77].get(nr).start();
        futureGet.awaitUninterruptibly();
        System.out.println("peer 77 got: \"" + futureGet.getData().object() + "\" for the key " + nr);
    }

    private static void examplePutGetConfig(Peer[] peers, Number160 nr2) throws IOException, ClassNotFoundException {
        Number160 nr = new Number160(RND);
        FuturePut futurePut = peers[30].put(nr).setData(new Number160(11), new Data((Object)"hallo")).setDomainKey(Number160.createHash((String)"my_domain")).start();
        futurePut.awaitUninterruptibly();
        System.out.println("peer 30 stored [key: " + nr + ", value: \"hallo\"]");
        FutureGet futureGet = peers[77].get(nr).setAll().start();
        futureGet.awaitUninterruptibly();
        System.out.println("peer 77 got: \"" + futureGet.getData() + "\" for the key " + nr);
        futureGet = (FutureGet)((GetBuilder)peers[77].get(nr).setAll().setDomainKey(Number160.createHash((String)"my_domain"))).start().awaitUninterruptibly();
        System.out.println("peer 77 got: \"" + futureGet.getData().object() + "\" for the key " + nr);
    }

    private static void exampleAddGet(Peer[] peers) throws IOException, ClassNotFoundException {
        Number160 nr = new Number160(RND);
        String toStore1 = "hallo1";
        String toStore2 = "hallo2";
        Data data1 = new Data((Object)toStore1);
        Data data2 = new Data((Object)toStore2);
        FuturePut futurePut = peers[30].add(nr).setData(data1).start();
        futurePut.awaitUninterruptibly();
        System.out.println("added: " + toStore1 + " (" + futurePut.isSuccess() + ")");
        futurePut = peers[50].add(nr).setData(data2).start();
        futurePut.awaitUninterruptibly();
        System.out.println("added: " + toStore2 + " (" + futurePut.isSuccess() + ")");
        FutureGet futureGet = peers[77].get(nr).setAll().start();
        futureGet.awaitUninterruptibly();
        System.out.println("size" + futureGet.getDataMap().size());
        Iterator iterator = futureGet.getDataMap().values().iterator();
        System.out.println("got: " + ((Data)iterator.next()).object() + " (" + futureGet.isSuccess() + ")");
        System.out.println("got: " + ((Data)iterator.next()).object() + " (" + futureGet.isSuccess() + ")");
    }

    private static void exampleGetBlocking(Peer[] peers, Number160 nr) throws ClassNotFoundException, IOException {
        FutureGet futureGet = peers[77].get(nr).start();
        futureGet.awaitUninterruptibly();
        System.out.println("result blocking: " + futureGet.getData().object());
        System.out.println("this may *not* happen before printing the result");
    }

    private static void exampleGetNonBlocking(Peer[] peers, Number160 nr) {
        FutureGet futureGet = peers[77].get(nr).start();
        futureGet.addListener((BaseFutureListener)new BaseFutureAdapter<FutureGet>(){

            public void operationComplete(FutureGet future) throws Exception {
                System.out.println("result non-blocking: " + future.getData().object());
            }
        });
        System.out.println("this may happen before printing the result");
    }
}

