/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import java.util.Iterator;
import java.util.NavigableMap;
import java.util.TreeMap;

public final class RangeLock<K extends Comparable<K>> {
    private final Object lockInternal = new Object();
    private final NavigableMap<K, Long> cache = new TreeMap<K, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Range lock(K fromKey, K toKey) {
        long id = Thread.currentThread().getId();
        Object object = this.lockInternal;
        synchronized (object) {
            NavigableMap<K, Long> subMap = this.cache.subMap(fromKey, true, toKey, true);
            while (subMap.size() > 0 && this.mapSizeFiltered(id, subMap) != 0) {
                try {
                    this.lockInternal.wait();
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            this.cache.put(fromKey, id);
            this.cache.put(toKey, id);
        }
        return new Range(this, (Comparable)fromKey, (Comparable)toKey, this);
    }

    private int mapSizeFiltered(long id, NavigableMap<K, Long> subMap) {
        int counter = 0;
        Iterator iterator = subMap.values().iterator();
        while (iterator.hasNext()) {
            long longValue = (Long)iterator.next();
            if (longValue == id) continue;
            ++counter;
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Range lock) {
        Object object = this.lockInternal;
        synchronized (object) {
            this.cache.remove(lock.fromKey);
            this.cache.remove(lock.toKey);
            this.lockInternal.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lockInternal;
        synchronized (object) {
            return this.cache.size();
        }
    }

    public static final class Range {
        private final K fromKey;
        private final K toKey;
        private final RangeLock<K> ref;
        final /* synthetic */ RangeLock this$0;

        private Range(K fromKey, K toKey, RangeLock<K> ref) {
            this.this$0 = this$0;
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.ref = ref;
        }

        public void unlock() {
            this.ref.unlock(this);
        }
    }
}

