/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.Responder;
import net.tomp2p.dht.AddBuilder;
import net.tomp2p.dht.DigestBuilder;
import net.tomp2p.dht.GetBuilder;
import net.tomp2p.dht.PutBuilder;
import net.tomp2p.dht.RemoveBuilder;
import net.tomp2p.dht.ReplicationListener;
import net.tomp2p.dht.StorageLayer;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.DataMap;
import net.tomp2p.message.KeyCollection;
import net.tomp2p.message.KeyMap640Keys;
import net.tomp2p.message.KeyMapByte;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.BloomfilterFactory;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;
import net.tomp2p.utils.Pair;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageRPC
extends DispatchHandler {
    public static final SimpleBloomFilter<Number160> EMPTY_FILTER = new SimpleBloomFilter(0, 0);
    public static final SimpleBloomFilter<Number160> FULL_FILTER = new SimpleBloomFilter(8, 1).setAll();
    private static final Logger LOG = LoggerFactory.getLogger(StorageRPC.class);
    private static final Random RND = new Random();
    private final BloomfilterFactory factory;
    private final StorageLayer storageLayer;
    private ReplicationListener replicationListener = null;

    public StorageRPC(PeerBean peerBean, ConnectionBean connectionBean, StorageLayer storageLayer) {
        super(peerBean, connectionBean);
        this.register(new int[]{RPC.Commands.PUT.getNr(), RPC.Commands.GET.getNr(), RPC.Commands.ADD.getNr(), RPC.Commands.REMOVE.getNr(), RPC.Commands.DIGEST.getNr(), RPC.Commands.DIGEST_BLOOMFILTER.getNr(), RPC.Commands.DIGEST_ALL_BLOOMFILTER.getNr(), RPC.Commands.PUT_META.getNr(), RPC.Commands.DIGEST_META_VALUES.getNr(), RPC.Commands.PUT_CONFIRM.getNr(), RPC.Commands.GET_LATEST.getNr(), RPC.Commands.GET_LATEST_WITH_DIGEST.getNr(), RPC.Commands.REPLICA_PUT.getNr()});
        this.factory = peerBean.bloomfilterFactory();
        this.storageLayer = storageLayer;
    }

    public StorageRPC replicationListener(ReplicationListener replicationListener) {
        this.replicationListener = replicationListener;
        return this;
    }

    public ReplicationListener replicationListener() {
        return this.replicationListener;
    }

    public FutureResponse put(PeerAddress remotePeer, PutBuilder putBuilder, ChannelCreator channelCreator) {
        Message.Type request = putBuilder.isProtectDomain() ? Message.Type.REQUEST_2 : Message.Type.REQUEST_1;
        return this.put(remotePeer, putBuilder, request, RPC.Commands.PUT, channelCreator);
    }

    public FutureResponse putIfAbsent(PeerAddress remotePeer, PutBuilder putBuilder, ChannelCreator channelCreator) {
        Message.Type request = putBuilder.isProtectDomain() ? Message.Type.REQUEST_4 : Message.Type.REQUEST_3;
        return this.put(remotePeer, putBuilder, request, RPC.Commands.PUT, channelCreator);
    }

    public FutureResponse putReplica(PeerAddress remotePeer, PutBuilder putBuilder, ChannelCreator channelCreator) {
        return this.put(remotePeer, putBuilder, Message.Type.REQUEST_1, RPC.Commands.REPLICA_PUT, channelCreator);
    }

    private FutureResponse put(PeerAddress remotePeer, PutBuilder putBuilder, Message.Type type, RPC.Commands rpcCommand, ChannelCreator channelCreator) {
        Utils.nullCheck((Object[])new Object[]{remotePeer});
        DataMap dataMap = putBuilder.dataMap() != null ? new DataMap(putBuilder.dataMap()) : new DataMap(putBuilder.locationKey(), putBuilder.domainKey(), putBuilder.versionKey(), putBuilder.dataMapContent());
        Message message = this.createMessage(remotePeer, rpcCommand.getNr(), type);
        if (putBuilder.isSign()) {
            message.publicKeyAndSign(putBuilder.keyPair());
        }
        message.setDataMap(dataMap);
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler request = new RequestHandler(futureResponse, this.peerBean(), this.connectionBean(), (ConnectionConfiguration)putBuilder);
        if (!putBuilder.isForceUDP()) {
            return request.sendTCP(channelCreator);
        }
        return request.sendUDP(channelCreator);
    }

    public FutureResponse putMeta(PeerAddress remotePeer, PutBuilder putBuilder, ChannelCreator channelCreator) {
        Utils.nullCheck((Object[])new Object[]{remotePeer});
        DataMap dataMap = putBuilder.dataMap() != null ? new DataMap(putBuilder.dataMap()) : new DataMap(putBuilder.locationKey(), putBuilder.domainKey(), putBuilder.versionKey(), putBuilder.dataMapContent());
        Message.Type type = putBuilder.changePublicKey() != null ? Message.Type.REQUEST_2 : Message.Type.REQUEST_1;
        Message message = this.createMessage(remotePeer, RPC.Commands.PUT_META.getNr(), type);
        if (putBuilder.isSign()) {
            message.publicKeyAndSign(putBuilder.keyPair());
        } else if (type == Message.Type.REQUEST_2) {
            throw new IllegalAccessError("can only change public key if message is signed");
        }
        if (putBuilder.changePublicKey() != null) {
            message.key(putBuilder.locationKey());
            message.key(putBuilder.domainKey());
            message.publicKey(putBuilder.changePublicKey());
        } else {
            message.setDataMap(dataMap);
        }
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler request = new RequestHandler(futureResponse, this.peerBean(), this.connectionBean(), (ConnectionConfiguration)putBuilder);
        if (!putBuilder.isForceUDP()) {
            return request.sendTCP(channelCreator);
        }
        return request.sendUDP(channelCreator);
    }

    public FutureResponse putConfirm(PeerAddress remotePeer, PutBuilder putBuilder, ChannelCreator channelCreator) {
        Utils.nullCheck((Object[])new Object[]{remotePeer});
        DataMap dataMap = putBuilder.dataMap() != null ? new DataMap(putBuilder.dataMap()) : new DataMap(putBuilder.locationKey(), putBuilder.domainKey(), putBuilder.versionKey(), putBuilder.dataMapContent());
        Message message = this.createMessage(remotePeer, RPC.Commands.PUT_CONFIRM.getNr(), Message.Type.REQUEST_1);
        if (putBuilder.isSign()) {
            message.publicKeyAndSign(putBuilder.keyPair());
        }
        message.setDataMap(dataMap);
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler request = new RequestHandler(futureResponse, this.peerBean(), this.connectionBean(), (ConnectionConfiguration)putBuilder);
        if (!putBuilder.isForceUDP()) {
            return request.sendTCP(channelCreator);
        }
        return request.sendUDP(channelCreator);
    }

    public FutureResponse add(PeerAddress remotePeer, AddBuilder addBuilder, ChannelCreator channelCreator) {
        Utils.nullCheck((Object[])new Object[]{remotePeer, addBuilder.locationKey(), addBuilder.domainKey()});
        Message.Type type = addBuilder.isProtectDomain() ? (addBuilder.isList() ? Message.Type.REQUEST_4 : Message.Type.REQUEST_2) : (addBuilder.isList() ? Message.Type.REQUEST_3 : Message.Type.REQUEST_1);
        TreeMap<Number160, Data> dataMap = new TreeMap<Number160, Data>();
        if (addBuilder.dataSet() != null) {
            for (Data data : addBuilder.dataSet()) {
                if (addBuilder.isList()) {
                    Number160 hash = new Number160(addBuilder.random());
                    while (dataMap.containsKey(hash)) {
                        hash = new Number160(addBuilder.random());
                    }
                    dataMap.put(hash, data);
                    continue;
                }
                dataMap.put(data.hash(), data);
            }
        }
        Message message = this.createMessage(remotePeer, RPC.Commands.ADD.getNr(), type);
        if (addBuilder.isSign()) {
            message.publicKeyAndSign(addBuilder.keyPair());
        }
        message.setDataMap(new DataMap(addBuilder.locationKey(), addBuilder.domainKey(), addBuilder.versionKey(), dataMap));
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler request = new RequestHandler(futureResponse, this.peerBean(), this.connectionBean(), (ConnectionConfiguration)addBuilder);
        if (!addBuilder.isForceUDP()) {
            return request.sendTCP(channelCreator);
        }
        return request.sendUDP(channelCreator);
    }

    public FutureResponse digest(PeerAddress remotePeer, DigestBuilder getBuilder, ChannelCreator channelCreator) {
        Byte command = getBuilder.isReturnBloomFilter() ? Byte.valueOf(RPC.Commands.DIGEST_BLOOMFILTER.getNr()) : (getBuilder.isReturnMetaValues() ? Byte.valueOf(RPC.Commands.DIGEST_META_VALUES.getNr()) : (getBuilder.isReturnAllBloomFilter() ? Byte.valueOf(RPC.Commands.DIGEST_ALL_BLOOMFILTER.getNr()) : Byte.valueOf(RPC.Commands.DIGEST.getNr())));
        Message.Type type = getBuilder.isAscending() && getBuilder.isBloomFilterAnd() ? Message.Type.REQUEST_1 : (!getBuilder.isAscending() && getBuilder.isBloomFilterAnd() ? Message.Type.REQUEST_2 : (getBuilder.isAscending() && !getBuilder.isBloomFilterAnd() ? Message.Type.REQUEST_3 : Message.Type.REQUEST_4));
        Message message = this.createMessage(remotePeer, command, type);
        if (getBuilder.isSign()) {
            message.publicKeyAndSign(getBuilder.keyPair());
        }
        if (getBuilder.to() != null && getBuilder.from() != null) {
            ArrayList<Number640> keys = new ArrayList<Number640>(2);
            keys.add(getBuilder.from());
            keys.add(getBuilder.to());
            message.intValue(getBuilder.returnNr());
            message.keyCollection(new KeyCollection(keys));
        } else if (getBuilder.keys() == null) {
            if (getBuilder.locationKey() == null || getBuilder.domainKey() == null) {
                throw new IllegalArgumentException("Null not allowed in location or domain");
            }
            message.key(getBuilder.locationKey());
            message.key(getBuilder.domainKey());
            if (getBuilder.contentKeys() != null) {
                message.keyCollection(new KeyCollection(getBuilder.locationKey(), getBuilder.domainKey(), getBuilder.versionKey(), getBuilder.contentKeys()));
            } else {
                message.intValue(getBuilder.returnNr());
                if (getBuilder.keyBloomFilter() != null || getBuilder.contentBloomFilter() != null) {
                    if (getBuilder.keyBloomFilter() != null) {
                        message.bloomFilter(getBuilder.keyBloomFilter());
                    }
                    if (getBuilder.contentBloomFilter() != null) {
                        message.bloomFilter(getBuilder.contentBloomFilter());
                    }
                }
            }
        } else {
            message.keyCollection(new KeyCollection(getBuilder.keys()));
        }
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler request = new RequestHandler(futureResponse, this.peerBean(), this.connectionBean(), (ConnectionConfiguration)getBuilder);
        if (!getBuilder.isForceUDP()) {
            return request.sendTCP(channelCreator);
        }
        return request.sendUDP(channelCreator);
    }

    public FutureResponse get(PeerAddress remotePeer, GetBuilder getBuilder, ChannelCreator channelCreator) {
        Message.Type type = getBuilder.isAscending() && getBuilder.isBloomFilterAnd() ? Message.Type.REQUEST_1 : (!getBuilder.isAscending() && getBuilder.isBloomFilterAnd() ? Message.Type.REQUEST_2 : (getBuilder.isAscending() && !getBuilder.isBloomFilterAnd() ? Message.Type.REQUEST_3 : Message.Type.REQUEST_4));
        Message message = this.createMessage(remotePeer, RPC.Commands.GET.getNr(), type);
        if (getBuilder.isSign()) {
            message.publicKeyAndSign(getBuilder.keyPair());
        }
        if (getBuilder.to() != null && getBuilder.from() != null) {
            ArrayList<Number640> keys = new ArrayList<Number640>(2);
            keys.add(getBuilder.from());
            keys.add(getBuilder.to());
            message.intValue(getBuilder.returnNr());
            message.keyCollection(new KeyCollection(keys));
        } else if (getBuilder.keys() == null) {
            if (getBuilder.locationKey() == null || getBuilder.domainKey() == null) {
                throw new IllegalArgumentException("Null not allowed in location or domain");
            }
            message.key(getBuilder.locationKey());
            message.key(getBuilder.domainKey());
            if (getBuilder.contentKeys() != null) {
                message.keyCollection(new KeyCollection(getBuilder.locationKey(), getBuilder.domainKey(), getBuilder.versionKey(), getBuilder.contentKeys()));
            } else {
                message.intValue(getBuilder.returnNr());
                if (getBuilder.contentKeyBloomFilter() != null) {
                    message.bloomFilter(getBuilder.contentKeyBloomFilter());
                } else if (getBuilder.isBloomFilterAnd()) {
                    message.bloomFilter(FULL_FILTER);
                } else {
                    message.bloomFilter(EMPTY_FILTER);
                }
                if (getBuilder.versionKeyBloomFilter() != null) {
                    message.bloomFilter(getBuilder.versionKeyBloomFilter());
                } else if (getBuilder.isBloomFilterAnd()) {
                    message.bloomFilter(FULL_FILTER);
                } else {
                    message.bloomFilter(EMPTY_FILTER);
                }
                if (getBuilder.contentBloomFilter() != null) {
                    message.bloomFilter(getBuilder.contentBloomFilter());
                } else if (getBuilder.isBloomFilterAnd()) {
                    message.bloomFilter(FULL_FILTER);
                } else {
                    message.bloomFilter(EMPTY_FILTER);
                }
            }
        } else {
            message.keyCollection(new KeyCollection(getBuilder.keys()));
        }
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler request = new RequestHandler(futureResponse, this.peerBean(), this.connectionBean(), (ConnectionConfiguration)getBuilder);
        if (!getBuilder.isForceUDP()) {
            return request.sendTCP(channelCreator);
        }
        return request.sendUDP(channelCreator);
    }

    public FutureResponse getLatest(PeerAddress remotePeer, GetBuilder getBuilder, ChannelCreator channelCreator, RPC.Commands command) {
        Message.Type type = Message.Type.REQUEST_1;
        Message message = this.createMessage(remotePeer, command.getNr(), type);
        if (getBuilder.isSign()) {
            message.publicKeyAndSign(getBuilder.keyPair());
        }
        message.key(getBuilder.locationKey());
        message.key(getBuilder.domainKey());
        message.key(getBuilder.contentKey());
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler request = new RequestHandler(futureResponse, this.peerBean(), this.connectionBean(), (ConnectionConfiguration)getBuilder);
        if (!getBuilder.isForceUDP()) {
            return request.sendTCP(channelCreator);
        }
        return request.sendUDP(channelCreator);
    }

    public FutureResponse remove(PeerAddress remotePeer, RemoveBuilder removeBuilder, ChannelCreator channelCreator) {
        Message message = this.createMessage(remotePeer, RPC.Commands.REMOVE.getNr(), removeBuilder.isReturnResults() ? Message.Type.REQUEST_2 : Message.Type.REQUEST_1);
        if (removeBuilder.isSign()) {
            message.publicKeyAndSign(removeBuilder.keyPair());
        }
        if (removeBuilder.to() != null && removeBuilder.from() != null) {
            ArrayList<Number640> keys = new ArrayList<Number640>(2);
            keys.add(removeBuilder.from());
            keys.add(removeBuilder.to());
            message.intValue(0);
            message.keyCollection(new KeyCollection(keys));
        } else if (removeBuilder.keys() == null) {
            if (removeBuilder.locationKey() == null || removeBuilder.domainKey() == null) {
                throw new IllegalArgumentException("Null not allowed in location or domain");
            }
            message.key(removeBuilder.locationKey());
            message.key(removeBuilder.domainKey());
            if (removeBuilder.contentKeys() != null) {
                message.keyCollection(new KeyCollection(removeBuilder.locationKey(), removeBuilder.domainKey(), removeBuilder.versionKey(), removeBuilder.contentKeys()));
            }
        } else {
            message.keyCollection(new KeyCollection(removeBuilder.keys()));
        }
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler request = new RequestHandler(futureResponse, this.peerBean(), this.connectionBean(), (ConnectionConfiguration)removeBuilder);
        if (!removeBuilder.isForceUDP()) {
            return request.sendTCP(channelCreator);
        }
        return request.sendUDP(channelCreator);
    }

    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        Message responseMessage = this.createResponseMessage(message, Message.Type.OK);
        if (message.command() == RPC.Commands.ADD.getNr()) {
            this.handleAdd(message, responseMessage, this.isDomainProtected(message));
        } else if (message.command() == RPC.Commands.PUT.getNr() || message.command() == RPC.Commands.REPLICA_PUT.getNr()) {
            this.handlePut(message, responseMessage, this.isStoreIfAbsent(message), this.isDomainProtected(message), this.isReplicaPut(message));
        } else if (message.command() == RPC.Commands.PUT_CONFIRM.getNr()) {
            this.handlePutConfirm(message, responseMessage);
        } else if (message.command() == RPC.Commands.GET.getNr()) {
            this.handleGet(message, responseMessage);
        } else if (message.command() == RPC.Commands.GET_LATEST.getNr()) {
            this.handleGetLatest(message, responseMessage, false);
        } else if (message.command() == RPC.Commands.GET_LATEST_WITH_DIGEST.getNr()) {
            this.handleGetLatest(message, responseMessage, true);
        } else if (message.command() == RPC.Commands.DIGEST.getNr() || message.command() == RPC.Commands.DIGEST_BLOOMFILTER.getNr() || message.command() == RPC.Commands.DIGEST_META_VALUES.getNr() || message.command() == RPC.Commands.DIGEST_ALL_BLOOMFILTER.getNr()) {
            this.handleDigest(message, responseMessage);
        } else if (message.command() == RPC.Commands.REMOVE.getNr()) {
            this.handleRemove(message, responseMessage, message.type() == Message.Type.REQUEST_2);
        } else if (message.command() == RPC.Commands.PUT_META.getNr()) {
            this.handlePutMeta(message, responseMessage, message.type() == Message.Type.REQUEST_2);
        } else {
            throw new IllegalArgumentException("Message content is wrong " + message.command());
        }
        if (sign) {
            responseMessage.publicKeyAndSign(this.peerBean().getKeyPair());
        }
        LOG.debug("response for storage request: {}", (Object)responseMessage);
        responder.response(responseMessage);
    }

    private boolean isReplicaPut(Message message) {
        return message.command() == RPC.Commands.REPLICA_PUT.getNr();
    }

    private boolean isDomainProtected(Message message) {
        return message.publicKey(0) != null && (message.type() == Message.Type.REQUEST_2 || message.type() == Message.Type.REQUEST_4);
    }

    private boolean isStoreIfAbsent(Message message) {
        return message.type() == Message.Type.REQUEST_3 || message.type() == Message.Type.REQUEST_4;
    }

    private boolean isList(Message message) {
        return message.type() == Message.Type.REQUEST_3 || message.type() == Message.Type.REQUEST_4;
    }

    private boolean isAscending(Message message) {
        return message.type() == Message.Type.REQUEST_1 || message.type() == Message.Type.REQUEST_3;
    }

    private boolean isBloomFilterAnd(Message message) {
        return message.type() == Message.Type.REQUEST_1 || message.type() == Message.Type.REQUEST_2;
    }

    private void handlePutMeta(Message message, Message responseMessage, boolean isDomain) {
        HashMap<Object, Byte> result;
        int dataSize;
        LOG.debug("handlePutMeta {}", (Object)message);
        PublicKey publicKey = message.publicKey(0);
        DataMap toStore = message.dataMap(0);
        if (isDomain) {
            dataSize = 1;
            result = new HashMap<Object, Byte>(1);
            LOG.debug("received meta request to change domain");
            Number160 locationKey = message.key(0);
            Number160 domainKey = message.key(1);
            Number640 key = new Number640(locationKey, domainKey, Number160.ZERO, Number160.ZERO);
            PublicKey publicKeyChange = message.publicKey(1);
            Enum<?> status = this.storageLayer.updateMeta(key.locationAndDomainKey(), publicKey, publicKeyChange);
            result.put(key, (byte)status.ordinal());
        } else {
            dataSize = toStore.size();
            result = new HashMap(dataSize);
            LOG.debug("received meta request to change entry");
            for (Map.Entry entry : toStore.dataMap().entrySet()) {
                ((Data)entry.getValue()).meta();
                Enum<?> status = this.storageLayer.updateMeta(publicKey, (Number640)entry.getKey(), (Data)entry.getValue());
                result.put(entry.getKey(), (byte)status.ordinal());
            }
        }
        responseMessage.type(result.size() == dataSize ? Message.Type.OK : Message.Type.PARTIALLY_OK);
        responseMessage.keyMapByte(new KeyMapByte(result));
    }

    private Message handlePut(Message message, Message responseMessage, boolean putIfAbsent, boolean protectDomain, boolean replicaPut) throws IOException {
        LOG.debug("handlePut {}", (Object)message);
        PublicKey publicKey = message.publicKey(0);
        DataMap toStore = message.dataMap(0);
        int dataSize = toStore.size();
        HashMap<Number640, Byte> result = new HashMap<Number640, Byte>(dataSize);
        Map<Number640, Enum<?>> storeRes = this.storageLayer.putAll(toStore.dataMap(), publicKey, putIfAbsent, protectDomain, message.isSendSelf());
        HashSet<Number160> affectedKeys = new HashSet<Number160>();
        for (Map.Entry<Number640, Enum<?>> entry : storeRes.entrySet()) {
            result.put(entry.getKey(), (byte)entry.getValue().ordinal());
            if (entry.getValue() != StorageLayer.PutStatus.OK && entry.getValue() != StorageLayer.PutStatus.VERSION_FORK && entry.getValue() != StorageLayer.PutStatus.DELETED) continue;
            affectedKeys.add(entry.getKey().locationKey());
        }
        if (this.replicationListener != null) {
            for (Number160 locationKey : affectedKeys) {
                this.replicationListener.dataInserted(locationKey);
            }
        }
        responseMessage.type(result.size() == dataSize ? Message.Type.OK : Message.Type.PARTIALLY_OK);
        responseMessage.keyMapByte(new KeyMapByte(result));
        return responseMessage;
    }

    private void handlePutConfirm(Message message, Message responseMessage) throws IOException {
        LOG.debug("handlePutConfirm {}", (Object)message);
        PublicKey publicKey = message.publicKey(0);
        DataMap toStore = message.dataMap(0);
        int dataSize = toStore.size();
        HashMap result = new HashMap(dataSize);
        LOG.debug("Received put confirmation.");
        for (Map.Entry entry : toStore.dataMap().entrySet()) {
            Enum<?> status = this.storageLayer.putConfirm(publicKey, (Number640)entry.getKey(), (Data)entry.getValue());
            result.put(entry.getKey(), (byte)status.ordinal());
            if (status != StorageLayer.PutStatus.OK && status != StorageLayer.PutStatus.VERSION_FORK || this.replicationListener == null) continue;
            this.replicationListener.dataInserted(((Number640)entry.getKey()).locationKey());
        }
        responseMessage.type(result.size() == dataSize ? Message.Type.OK : Message.Type.PARTIALLY_OK);
        responseMessage.keyMapByte(new KeyMapByte(result));
    }

    private Message handleAdd(Message message, Message responseMessage, boolean protectDomain) {
        LOG.debug("handleAdd {}", (Object)message);
        Utils.nullCheck((Object[])new Object[]{message.dataMap(0)});
        HashMap<Number640, Byte> result = new HashMap<Number640, Byte>();
        DataMap dataMap = message.dataMap(0);
        PublicKey publicKey = message.publicKey(0);
        boolean list = this.isList(message);
        for (Map.Entry<Number640, Data> entry : dataMap.dataMap().entrySet()) {
            Enum<?> status = StorageRPC.doAdd(protectDomain, entry, publicKey, list, this.storageLayer, this.peerBean().serverPeerAddress(), message.isSendSelf());
            result.put(entry.getKey(), (byte)status.ordinal());
            if (entry.getValue().hasPrepareFlag() || status != StorageLayer.PutStatus.OK || this.replicationListener == null) continue;
            this.replicationListener.dataInserted(entry.getKey().locationKey());
        }
        responseMessage.keyMapByte(new KeyMapByte(result));
        return responseMessage;
    }

    private static Enum<?> doAdd(boolean protectDomain, Map.Entry<Number640, Data> entry, PublicKey publicKey, boolean list, StorageLayer storageLayer, PeerAddress serverPeerAddress, boolean sendSelf) {
        LOG.debug("add list data with key {} on {}", (Object)entry.getKey(), (Object)serverPeerAddress);
        if (list) {
            Enum<?> status;
            Number160 contentKey2 = new Number160(RND);
            Number640 key = new Number640(entry.getKey().locationKey(), entry.getKey().domainKey(), contentKey2, entry.getKey().versionKey());
            while ((status = storageLayer.put(key, entry.getValue(), publicKey, true, protectDomain, sendSelf)) == StorageLayer.PutStatus.FAILED_NOT_ABSENT) {
                contentKey2 = new Number160(RND);
            }
            return status;
        }
        return storageLayer.put(entry.getKey(), entry.getValue(), publicKey, false, protectDomain, sendSelf);
    }

    private Message handleGet(Message message, Message responseMessage) {
        LOG.debug("handleGet {}", (Object)message);
        Number160 locationKey = message.key(0);
        Number160 domainKey = message.key(1);
        KeyCollection contentKeys = message.keyCollection(0);
        SimpleBloomFilter contentKeyBloomFilter = message.bloomFilter(0);
        SimpleBloomFilter versionBloomFilter = message.bloomFilter(1);
        SimpleBloomFilter contentBloomFilter = message.bloomFilter(2);
        Integer returnNr = message.intAt(0);
        int limit = returnNr == null ? -1 : returnNr;
        boolean ascending = this.isAscending(message);
        boolean isRange = contentKeys != null && returnNr != null;
        boolean isCollection = contentKeys != null && returnNr == null;
        boolean isBloomFilterAnd = this.isBloomFilterAnd(message);
        NavigableMap<Number640, Data> result = this.doGet(locationKey, domainKey, contentKeys, (SimpleBloomFilter<Number160>)contentKeyBloomFilter, (SimpleBloomFilter<Number160>)versionBloomFilter, (SimpleBloomFilter<Number160>)contentBloomFilter, limit, ascending, isRange, isCollection, isBloomFilterAnd);
        responseMessage.setDataMap(new DataMap(result));
        return responseMessage;
    }

    private NavigableMap<Number640, Data> doGet(Number160 locationKey, Number160 domainKey, KeyCollection contentKeys, SimpleBloomFilter<Number160> contentKeyBloomFilter, SimpleBloomFilter<Number160> versionBloomFilter, SimpleBloomFilter<Number160> contentBloomFilter, int limit, boolean ascending, boolean isRange, boolean isCollection, boolean isBloomFilterAnd) {
        NavigableMap<Number640, Data> result;
        if (isCollection) {
            result = new TreeMap<Number640, Data>();
            for (Number640 key : contentKeys.keys()) {
                Data data = this.storageLayer.get(key);
                if (data == null) continue;
                result.put(key, data);
            }
        } else if (isRange) {
            Iterator iterator = contentKeys.keys().iterator();
            Number640 min = (Number640)iterator.next();
            Number640 max = (Number640)iterator.next();
            result = this.storageLayer.get(min, max, limit, ascending);
        } else if (contentKeyBloomFilter != null && versionBloomFilter != null && contentBloomFilter != null) {
            Number640 min = new Number640(locationKey, domainKey, Number160.ZERO, Number160.ZERO);
            Number640 max = new Number640(locationKey, domainKey, Number160.MAX_VALUE, Number160.MAX_VALUE);
            result = this.storageLayer.get(min, max, contentKeyBloomFilter, versionBloomFilter, contentBloomFilter, limit, ascending, isBloomFilterAnd);
        } else {
            Number640 min = new Number640(locationKey, domainKey, Number160.ZERO, Number160.ZERO);
            Number640 max = new Number640(locationKey, domainKey, Number160.MAX_VALUE, Number160.MAX_VALUE);
            result = this.storageLayer.get(min, max, limit, ascending);
        }
        return result;
    }

    private Message handleGetLatest(Message message, Message responseMessage, boolean withDigest) {
        LOG.debug("handleGetLatest {}", (Object)message);
        Number160 locationKey = message.key(0);
        Number160 domainKey = message.key(1);
        Number160 contentKey = message.key(2);
        Number640 key = new Number640(locationKey, domainKey, contentKey, Number160.ZERO);
        NavigableMap<Number640, Data> result = this.storageLayer.getLatestVersion(key);
        responseMessage.setDataMap(new DataMap(result));
        if (withDigest) {
            DigestInfo digestInfo = this.storageLayer.digest(key.minVersionKey(), key.maxVersionKey(), -1, true);
            responseMessage.keyMap640Keys(new KeyMap640Keys(digestInfo.digests()));
        }
        return responseMessage;
    }

    private Message handleDigest(Message message, Message responseMessage) {
        boolean isReturnMetaValues;
        LOG.debug("handleDigest {}", (Object)message);
        Number160 locationKey = message.key(0);
        Number160 domainKey = message.key(1);
        KeyCollection contentKeys = message.keyCollection(0);
        SimpleBloomFilter contentKeyBloomFilter = message.bloomFilter(0);
        SimpleBloomFilter versionBloomFilter = message.bloomFilter(1);
        SimpleBloomFilter contentBloomFilter = message.bloomFilter(2);
        Integer returnNr = message.intAt(0);
        int limit = returnNr == null ? -1 : returnNr;
        boolean ascending = this.isAscending(message);
        boolean isRange = contentKeys != null && returnNr != null;
        boolean isCollection = contentKeys != null && returnNr == null;
        boolean isBloomFilterAnd = this.isBloomFilterAnd(message);
        boolean isReturnBloomfilter = message.command() == RPC.Commands.DIGEST_BLOOMFILTER.getNr();
        boolean isReturnAllBloomfilter = message.command() == RPC.Commands.DIGEST_ALL_BLOOMFILTER.getNr();
        boolean bl = isReturnMetaValues = message.command() == RPC.Commands.DIGEST_META_VALUES.getNr();
        if (isReturnMetaValues || isReturnAllBloomfilter) {
            NavigableMap<Number640, Data> result = this.doGet(locationKey, domainKey, contentKeys, (SimpleBloomFilter<Number160>)contentKeyBloomFilter, (SimpleBloomFilter<Number160>)versionBloomFilter, (SimpleBloomFilter<Number160>)contentBloomFilter, limit, ascending, isRange, isCollection, isBloomFilterAnd);
            if (!isReturnAllBloomfilter) {
                DataMap dataMap = new DataMap(result, true);
                responseMessage.setDataMap(dataMap);
            } else {
                SimpleBloomFilter sbfContentKey = this.factory.createContentKeyBloomFilter();
                SimpleBloomFilter sbfVersion = this.factory.createVersionKeyBloomFilter();
                SimpleBloomFilter sbfContent = this.factory.createContentBloomFilter();
                for (Map.Entry entry : result.entrySet()) {
                    sbfContentKey.add((Object)((Number640)entry.getKey()).contentKey());
                    sbfVersion.add((Object)((Number640)entry.getKey()).versionKey());
                    sbfContent.add((Object)((Data)entry.getValue()).hash());
                }
                responseMessage.bloomFilter(sbfContentKey);
                responseMessage.bloomFilter(sbfVersion);
                responseMessage.bloomFilter(sbfContent);
            }
        } else {
            DigestInfo digestInfo = this.doDigest(locationKey, domainKey, contentKeys, (SimpleBloomFilter<Number160>)contentKeyBloomFilter, (SimpleBloomFilter<Number160>)versionBloomFilter, limit, ascending, isRange, isCollection, isBloomFilterAnd);
            if (isReturnBloomfilter) {
                SimpleBloomFilter sbfContentKey = this.factory.createContentKeyBloomFilter();
                SimpleBloomFilter sbfVersion = this.factory.createVersionKeyBloomFilter();
                for (Number640 key : digestInfo.mapDigests().keySet()) {
                    sbfContentKey.add((Object)key.contentKey());
                    sbfVersion.add((Object)key.versionKey());
                }
                responseMessage.bloomFilter(sbfContentKey);
                responseMessage.bloomFilter(sbfVersion);
                responseMessage.bloomFilter(FULL_FILTER);
            } else {
                responseMessage.keyMap640Keys(new KeyMap640Keys(digestInfo.digests()));
            }
        }
        return responseMessage;
    }

    private DigestInfo doDigest(Number160 locationKey, Number160 domainKey, KeyCollection contentKeys, SimpleBloomFilter<Number160> contentKeyBloomFilter, SimpleBloomFilter<Number160> versionBloomFilter, int limit, boolean ascending, boolean isRange, boolean isCollection, boolean isBloomFilterAnd) {
        DigestInfo digestInfo;
        if (isCollection) {
            digestInfo = this.storageLayer.digest(contentKeys.keys());
        } else if (isRange) {
            Iterator iterator = contentKeys.keys().iterator();
            Number640 min = (Number640)iterator.next();
            Number640 max = (Number640)iterator.next();
            digestInfo = this.storageLayer.digest(min, max, limit, ascending);
        } else if (contentKeyBloomFilter != null || versionBloomFilter != null) {
            Number320 locationAndDomainKey = new Number320(locationKey, domainKey);
            digestInfo = this.storageLayer.digest(locationAndDomainKey, contentKeyBloomFilter, versionBloomFilter, limit, ascending, isBloomFilterAnd);
        } else {
            Number640 min = new Number640(locationKey, domainKey, Number160.ZERO, Number160.ZERO);
            Number640 max = new Number640(locationKey, domainKey, Number160.MAX_VALUE, Number160.MAX_VALUE);
            digestInfo = this.storageLayer.digest(min, max, limit, ascending);
        }
        return digestInfo;
    }

    private Message handleRemove(Message message, Message responseMessage, boolean sendBackResults) {
        boolean isCollection;
        LOG.debug("handleRemove {}", (Object)message);
        Number160 locationKey = message.key(0);
        Number160 domainKey = message.key(1);
        KeyCollection keys = message.keyCollection(0);
        PublicKey publicKey = message.publicKey(0);
        NavigableMap<Object, Object> result1 = null;
        Map<Object, Object> result2 = null;
        Integer returnNr = message.intAt(0);
        boolean isRange = keys != null && returnNr != null;
        boolean bl = isCollection = keys != null && returnNr == null;
        if (isCollection) {
            Pair<Data, Enum<?>> data;
            if (sendBackResults) {
                result1 = new TreeMap();
                for (Number640 number640 : keys.keys()) {
                    data = this.storageLayer.remove(number640, publicKey, sendBackResults);
                    this.notifyRemoveResponsibility(number640.locationKey(), (Enum)data.element1());
                    if (data.element0() == null) continue;
                    result1.put(number640, data.element0());
                }
            } else {
                result2 = new HashMap(keys.size());
                for (Number640 number640 : keys.keys()) {
                    data = this.storageLayer.remove(number640, publicKey, sendBackResults);
                    this.notifyRemoveResponsibility(number640.locationKey(), (Enum)data.element1());
                    result2.put(number640, (byte)((Enum)data.element1()).ordinal());
                }
            }
        } else if (isRange) {
            Iterator iterator = keys.keys().iterator();
            Number640 number640 = (Number640)iterator.next();
            Number640 to = (Number640)iterator.next();
            if (sendBackResults) {
                result1 = this.storageLayer.removeReturnData(number640, to, publicKey);
            } else {
                result2 = this.storageLayer.removeReturnStatus(number640, to, publicKey);
            }
        } else if (locationKey != null && domainKey != null) {
            Number640 from = new Number640(locationKey, domainKey, Number160.ZERO, Number160.ZERO);
            Number640 number640 = new Number640(locationKey, domainKey, Number160.MAX_VALUE, Number160.MAX_VALUE);
            if (sendBackResults) {
                result1 = this.storageLayer.removeReturnData(from, number640, publicKey);
            } else {
                result2 = this.storageLayer.removeReturnStatus(from, number640, publicKey);
            }
        } else {
            throw new IllegalArgumentException("Either two keys or a key set are necessary");
        }
        if (!sendBackResults) {
            for (Map.Entry entry : result2.entrySet()) {
                this.notifyRemoveResponsibility(((Number640)entry.getKey()).locationKey(), StorageLayer.PutStatus.values()[(Byte)entry.getValue()]);
            }
            responseMessage.keyMapByte(new KeyMapByte(result2));
        } else {
            for (Map.Entry entry : result1.entrySet()) {
                this.notifyRemoveResponsibility(((Number640)entry.getKey()).locationKey(), StorageLayer.PutStatus.OK);
            }
            responseMessage.setDataMap(new DataMap(result1));
        }
        return responseMessage;
    }

    private void notifyRemoveResponsibility(Number160 locationKey, Enum<?> status) {
        if (status == StorageLayer.PutStatus.OK && this.replicationListener != null) {
            this.replicationListener.dataRemoved(locationKey);
        }
    }
}

