/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import java.util.Map;
import net.tomp2p.dht.DHTBuilder;
import net.tomp2p.dht.EvaluatingSchemeDHT;
import net.tomp2p.dht.FutureDHT;
import net.tomp2p.dht.VotingSchemeDHT;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DigestResult;

public class FutureDigest
extends FutureDHT<FutureDigest> {
    private final int min;
    private final EvaluatingSchemeDHT evaluationScheme;
    private Map<PeerAddress, DigestResult> rawDigest;
    private boolean minReached;

    public FutureDigest(DHTBuilder<?> builder) {
        this(builder, 0, new VotingSchemeDHT());
    }

    public FutureDigest(DHTBuilder<?> builder, int min, EvaluatingSchemeDHT evaluationScheme) {
        super(builder);
        this.min = min;
        this.evaluationScheme = evaluationScheme;
        this.self((BaseFuture)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedDigest(Map<PeerAddress, DigestResult> rawDigest, FutureDone<Void> futuresCompleted) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.completedAndNotify()) {
                return;
            }
            this.rawDigest = rawDigest;
            this.futuresCompleted = futuresCompleted;
            int size = rawDigest.size();
            this.minReached = size >= this.min;
            this.type = size > 0 ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = size > 0 ? "Minimum number of results reached" : "Expected >0 result, but got " + size;
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, DigestResult> rawDigest() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawDigest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigestResult digest() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate5(this.rawDigest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMinReached() {
        Object object = this.lock;
        synchronized (object) {
            return this.minReached;
        }
    }
}

