/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import java.util.Map;
import net.tomp2p.dht.DHTBuilder;
import net.tomp2p.dht.EvaluatingSchemeDHT;
import net.tomp2p.dht.FutureDHT;
import net.tomp2p.dht.StorageLayer;
import net.tomp2p.dht.VotingSchemeDHT;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DigestResult;
import net.tomp2p.storage.Data;

public class FutureGet
extends FutureDHT<FutureGet> {
    private final int min;
    private final EvaluatingSchemeDHT evaluationScheme;
    private Map<PeerAddress, Map<Number640, Data>> rawData;
    private Map<PeerAddress, DigestResult> rawDigest;
    private Map<PeerAddress, Byte> rawStatus;
    private boolean minReached;

    public FutureGet(DHTBuilder<?> builder) {
        this(builder, 0, new VotingSchemeDHT());
    }

    public FutureGet(DHTBuilder<?> builder, int min, EvaluatingSchemeDHT evaluationScheme) {
        super(builder);
        this.min = min;
        this.evaluationScheme = evaluationScheme;
        this.self((BaseFuture)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedData(Map<PeerAddress, Map<Number640, Data>> rawData, Map<PeerAddress, DigestResult> rawDigest, Map<PeerAddress, Byte> rawStatus, FutureDone<Void> futuresCompleted) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.completedAndNotify()) {
                return;
            }
            this.rawData = rawData;
            this.rawDigest = rawDigest;
            this.rawStatus = rawStatus;
            this.futuresCompleted = futuresCompleted;
            int size = rawStatus.size();
            this.minReached = size >= this.min;
            this.type = size > 0 ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = size > 0 ? "Minimum number of answers reached" : "Expected >0 answers, but got " + size;
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Map<Number640, Data>> rawData() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, DigestResult> rawDigest() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawDigest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Byte> rawStatus() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigestResult digest() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate5(this.rawDigest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Number640, Data> dataMap() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate2(this.rawData);
        }
    }

    public Data data() {
        Map<Number640, Data> dataMap = this.dataMap();
        if (dataMap.size() == 0) {
            return null;
        }
        return dataMap.values().iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMinReached() {
        Object object = this.lock;
        synchronized (object) {
            return this.minReached;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            for (byte b : this.rawStatus.values()) {
                if (b != StorageLayer.PutStatus.OK.ordinal()) continue;
                return false;
            }
            return true;
        }
    }
}

