/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.tomp2p.dht.RangeLock;
import net.tomp2p.dht.Storage;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.Number640;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.DigestStorage;
import net.tomp2p.utils.Pair;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageLayer
implements DigestStorage {
    private static final Logger LOG = LoggerFactory.getLogger(StorageLayer.class);
    private ProtectionMode protectionDomainMode = ProtectionMode.MASTER_PUBLIC_KEY;
    private ProtectionEnable protectionDomainEnable = ProtectionEnable.ALL;
    private ProtectionMode protectionEntryMode = ProtectionMode.MASTER_PUBLIC_KEY;
    private ProtectionEnable protectionEntryEnable = ProtectionEnable.ALL;
    private final Collection<Number160> removedDomains = new HashSet<Number160>();
    private final RangeLock<Number640> rangeLock = new RangeLock();
    private final RangeLock<Number640> responsibilityLock = new RangeLock();
    private final Storage backend;

    public StorageLayer(Storage backend) {
        this.backend = backend;
    }

    public void protection(ProtectionEnable protectionDomainEnable, ProtectionMode protectionDomainMode, ProtectionEnable protectionEntryEnable, ProtectionMode protectionEntryMode) {
        this.protectionDomainEnable(protectionDomainEnable);
        this.protectionDomainMode(protectionDomainMode);
        this.protectionEntryEnable(protectionEntryEnable);
        this.protectionEntryMode(protectionEntryMode);
    }

    public void protectionDomainMode(ProtectionMode protectionDomainMode) {
        this.protectionDomainMode = protectionDomainMode;
    }

    public ProtectionMode protectionDomainMode() {
        return this.protectionDomainMode;
    }

    public void protectionDomainEnable(ProtectionEnable protectionDomainEnable) {
        this.protectionDomainEnable = protectionDomainEnable;
    }

    public ProtectionEnable protectionDomainEnable() {
        return this.protectionDomainEnable;
    }

    public void protectionEntryMode(ProtectionMode protectionEntryMode) {
        this.protectionEntryMode = protectionEntryMode;
    }

    public ProtectionMode protectionEntryMode() {
        return this.protectionEntryMode;
    }

    public void protectionEntryEnable(ProtectionEnable protectionEntryEnable) {
        this.protectionEntryEnable = protectionEntryEnable;
    }

    public ProtectionEnable protectionEntryEnable() {
        return this.protectionEntryEnable;
    }

    public void removeDomainProtection(Number160 removeDomain) {
        this.removedDomains.add(removeDomain);
    }

    boolean isDomainRemoved(Number160 domain) {
        return this.removedDomains.contains(domain);
    }

    private RangeLock.Range lock(Number640 min, Number640 max) {
        return this.rangeLock.lock(min, max);
    }

    private RangeLock.Range lock(Number640 number640) {
        return this.rangeLock.lock(number640, number640);
    }

    private RangeLock.Range lock(Number480 number480) {
        return this.rangeLock.lock(new Number640(number480, Number160.ZERO), new Number640(number480, Number160.MAX_VALUE));
    }

    private RangeLock.Range lock(Number320 number320) {
        return this.rangeLock.lock(new Number640(number320, Number160.ZERO, Number160.ZERO), new Number640(number320, Number160.MAX_VALUE, Number160.MAX_VALUE));
    }

    private RangeLock.Range lock(Number160 number160) {
        return this.rangeLock.lock(new Number640(number160, Number160.ZERO, Number160.ZERO, Number160.ZERO), new Number640(number160, Number160.MAX_VALUE, Number160.MAX_VALUE, Number160.MAX_VALUE));
    }

    private RangeLock.Range lockResponsibility(Number160 number160) {
        return this.responsibilityLock.lock(new Number640(number160, Number160.ZERO, Number160.ZERO, Number160.ZERO), new Number640(number160, Number160.MAX_VALUE, Number160.MAX_VALUE, Number160.MAX_VALUE));
    }

    private RangeLock.Range lock() {
        return this.rangeLock.lock(new Number640(Number160.ZERO, Number160.ZERO, Number160.ZERO, Number160.ZERO), new Number640(Number160.MAX_VALUE, Number160.MAX_VALUE, Number160.MAX_VALUE, Number160.MAX_VALUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Number640, Enum<?>> putAll(NavigableMap<Number640, Data> dataMap, PublicKey publicKey, boolean putIfAbsent, boolean domainProtection, boolean sendSelf) {
        if (dataMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Number640 min = (Number640)dataMap.firstKey();
        Number640 max = (Number640)dataMap.lastKey();
        HashMap<Number640, PutStatus> retVal = new HashMap<Number640, PutStatus>();
        HashSet<Number480> keysToCheck = new HashSet<Number480>();
        RangeLock.Range lock = this.lock(min, max);
        try {
            for (Map.Entry entry : dataMap.entrySet()) {
                Data oldData;
                Number640 key = (Number640)entry.getKey();
                keysToCheck.add(key.locationAndDomainAndContentKey());
                Data newData = (Data)entry.getValue();
                if (!this.securityDomainCheck(key.locationAndDomainKey(), publicKey, publicKey, domainProtection)) {
                    retVal.put(key, PutStatus.FAILED_SECURITY);
                    continue;
                }
                PublicKey dataKey = sendSelf && newData.publicKey() == null ? publicKey : newData.publicKey();
                if (!this.securityEntryCheck(key.locationAndDomainAndContentKey(), publicKey, dataKey, newData.isProtectedEntry())) {
                    retVal.put(key, PutStatus.FAILED_SECURITY);
                    continue;
                }
                boolean contains = this.backend.contains(key);
                if (contains) {
                    if (putIfAbsent) {
                        retVal.put(key, PutStatus.FAILED_NOT_ABSENT);
                        continue;
                    }
                    oldData = this.backend.get(key);
                    if (oldData.isDeleted()) {
                        retVal.put(key, PutStatus.DELETED);
                        continue;
                    }
                    if (!oldData.basedOnSet().equals(newData.basedOnSet())) {
                        retVal.put(key, PutStatus.VERSION_FORK);
                        continue;
                    }
                }
                oldData = this.backend.put(key, newData);
                long expiration = newData.expirationMillis();
                this.backend.addTimeout(key, expiration);
                if (newData.hasPrepareFlag()) {
                    retVal.put(key, PutStatus.OK_PREPARED);
                    continue;
                }
                if (newData.equals((Object)oldData)) {
                    retVal.put(key, PutStatus.OK_UNCHANGED);
                    continue;
                }
                retVal.put(key, PutStatus.OK);
            }
            for (Number480 key : keysToCheck) {
                Number640 maxVersion;
                Number640 minVersion = new Number640(key, Number160.ZERO);
                NavigableMap<Number640, Data> tmp = this.backend.subMap(minVersion, maxVersion = new Number640(key, Number160.MAX_VALUE), -1, true);
                NavigableMap<Number640, Data> heads = this.getLatestInternal(tmp);
                if (heads.size() <= 1) continue;
                for (Number640 fork : heads.keySet()) {
                    if (!retVal.containsKey(fork)) continue;
                    retVal.put(fork, PutStatus.VERSION_FORK);
                }
            }
            HashMap<Number640, PutStatus> hashMap = retVal;
            return hashMap;
        }
        finally {
            lock.unlock();
        }
    }

    public Enum<?> put(Number640 key, Data newData, PublicKey publicKey, boolean putIfAbsent, boolean domainProtection, boolean sendSelf) {
        TreeMap<Number640, Data> dataMap = new TreeMap<Number640, Data>();
        dataMap.put(key, newData);
        Map<Number640, Enum<?>> putStatus = this.putAll(dataMap, publicKey, putIfAbsent, domainProtection, sendSelf);
        Enum<?> retVal = putStatus.get(key);
        if (retVal == null) {
            return PutStatus.FAILED;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Enum<?> putOld(Number640 key, Data newData, PublicKey publicKey, boolean putIfAbsent, boolean domainProtection, boolean sendSelf) {
        RangeLock.Range lock = this.lock(key.locationAndDomainAndContentKey());
        try {
            if (!this.securityDomainCheck(key.locationAndDomainKey(), publicKey, publicKey, domainProtection)) {
                PutStatus putStatus = PutStatus.FAILED_SECURITY;
                return putStatus;
            }
            PublicKey dataKey = sendSelf && newData.publicKey() == null ? publicKey : newData.publicKey();
            if (!this.securityEntryCheck(key.locationAndDomainAndContentKey(), publicKey, dataKey, newData.isProtectedEntry())) {
                PutStatus putStatus = PutStatus.FAILED_SECURITY;
                return putStatus;
            }
            boolean contains = this.backend.contains(key);
            if (contains) {
                if (putIfAbsent) {
                    PutStatus putStatus = PutStatus.FAILED_NOT_ABSENT;
                    return putStatus;
                }
                Data oldData = this.backend.get(key);
                if (oldData.isDeleted()) {
                    PutStatus putStatus = PutStatus.DELETED;
                    return putStatus;
                }
            }
            NavigableMap<Number640, Data> tmp = this.backend.subMap(key.minVersionKey(), key.maxVersionKey(), -1, true);
            tmp.put(key, newData);
            boolean versionFork = this.getLatestInternal(tmp).size() > 1;
            Data oldData = this.backend.put(key, newData);
            long expiration = newData.expirationMillis();
            this.backend.addTimeout(key, expiration);
            if (versionFork) {
                PutStatus putStatus = PutStatus.VERSION_FORK;
                return putStatus;
            }
            if (newData.equals((Object)oldData)) {
                PutStatus putStatus = PutStatus.OK_UNCHANGED;
                return putStatus;
            }
            PutStatus putStatus = PutStatus.OK;
            return putStatus;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Data, Enum<?>> remove(Number640 key, PublicKey publicKey, boolean returnData) {
        RangeLock.Range lock = this.lock(key);
        try {
            if (!this.canClaimDomain(key.locationAndDomainKey(), publicKey)) {
                Pair pair = new Pair(null, (Object)PutStatus.FAILED_SECURITY);
                return pair;
            }
            if (!this.canClaimEntry(key.locationAndDomainAndContentKey(), publicKey)) {
                Pair pair = new Pair(null, (Object)PutStatus.FAILED_SECURITY);
                return pair;
            }
            if (!this.backend.contains(key)) {
                Pair pair = new Pair(null, (Object)PutStatus.NOT_FOUND);
                return pair;
            }
            this.backend.removeTimeout(key);
            Pair pair = new Pair((Object)this.backend.remove(key, returnData), (Object)PutStatus.OK);
            return pair;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data get(Number640 key) {
        RangeLock.Range lock = this.lock(key);
        try {
            Data data = this.getInternal(key);
            return data;
        }
        finally {
            lock.unlock();
        }
    }

    private Data getInternal(Number640 key) {
        Data data = this.backend.get(key);
        if (data != null && !data.hasPrepareFlag()) {
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableMap<Number640, Data> get(Number640 from, Number640 to, int limit, boolean ascending) {
        RangeLock.Range lock = this.rangeLock.lock(from, to);
        try {
            NavigableMap<Number640, Data> tmp = this.backend.subMap(from, to, limit, ascending);
            this.removePrepared(tmp);
            NavigableMap<Number640, Data> navigableMap = tmp;
            return navigableMap;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableMap<Number640, Data> getLatestVersion(Number640 key) {
        RangeLock.Range lock = this.lock(key.locationAndDomainAndContentKey());
        try {
            NavigableMap<Number640, Data> tmp = this.backend.subMap(key.minVersionKey(), key.maxVersionKey(), -1, true);
            this.removePrepared(tmp);
            NavigableMap<Number640, Data> navigableMap = this.getLatestInternal(tmp);
            return navigableMap;
        }
        finally {
            lock.unlock();
        }
    }

    private NavigableMap<Number640, Data> getLatestInternal(NavigableMap<Number640, Data> tmp) {
        TreeMap<Number640, Data> result = new TreeMap<Number640, Data>();
        while (!tmp.isEmpty()) {
            Map.Entry<Number640, Data> latest = tmp.lastEntry();
            result.put(latest.getKey(), latest.getValue());
            this.deletePredecessors(latest.getKey(), tmp);
        }
        return result;
    }

    private void removePrepared(NavigableMap<Number640, Data> tmp) {
        Iterator iterator = tmp.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((Data)entry.getValue()).hasPrepareFlag()) continue;
            iterator.remove();
        }
    }

    @Deprecated
    private void deletePredecessors2(Number640 key, NavigableMap<Number640, Data> sortedMap) {
        Data version = (Data)sortedMap.remove(key);
        if (version == null) {
            return;
        }
        if (version.basedOnSet().isEmpty()) {
            return;
        }
        for (Number160 basedOnKey : version.basedOnSet()) {
            this.deletePredecessors(new Number640(key.locationAndDomainAndContentKey(), basedOnKey), sortedMap);
        }
    }

    private void deletePredecessors(Number640 key, NavigableMap<Number640, Data> sortedMap) {
        ArrayList<Number640> toRemove = new ArrayList<Number640>();
        toRemove.add(key);
        while (!toRemove.isEmpty()) {
            Data version = (Data)sortedMap.remove(toRemove.remove(0));
            if (version == null || version.basedOnSet().isEmpty()) continue;
            for (Number160 basedOnKey : version.basedOnSet()) {
                toRemove.add(new Number640(key.locationAndDomainAndContentKey(), basedOnKey));
            }
        }
    }

    public NavigableMap<Number640, Data> get() {
        RangeLock.Range lock = this.lock();
        try {
            NavigableMap<Number640, Data> navigableMap = this.backend.map();
            return navigableMap;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Number640 key) {
        RangeLock.Range lock = this.lock(key);
        try {
            boolean bl = this.backend.contains(key);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableMap<Number640, Data> get(Number640 from, Number640 to, SimpleBloomFilter<Number160> contentBloomFilter, SimpleBloomFilter<Number160> versionBloomFilter, int limit, boolean ascending, boolean isBloomFilterAnd) {
        RangeLock.Range lock = this.rangeLock.lock(from, to);
        try {
            NavigableMap<Number640, Data> tmp = this.backend.subMap(from, to, limit, ascending);
            Iterator iterator = tmp.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (((Data)entry.getValue()).hasPrepareFlag()) {
                    iterator.remove();
                    continue;
                }
                if (isBloomFilterAnd) {
                    if (contentBloomFilter != null && !contentBloomFilter.contains((Object)((Number640)entry.getKey()).contentKey())) {
                        iterator.remove();
                        continue;
                    }
                    if (versionBloomFilter == null || versionBloomFilter.contains((Object)((Data)entry.getValue()).hash())) continue;
                    iterator.remove();
                    continue;
                }
                if (contentBloomFilter != null && contentBloomFilter.contains((Object)((Number640)entry.getKey()).contentKey())) {
                    iterator.remove();
                    continue;
                }
                if (versionBloomFilter == null || !versionBloomFilter.contains((Object)((Data)entry.getValue()).hash())) continue;
                iterator.remove();
            }
            NavigableMap<Number640, Data> navigableMap = tmp;
            return navigableMap;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableMap<Number640, Data> removeReturnData(Number640 from, Number640 to, PublicKey publicKey) {
        RangeLock.Range lock = this.rangeLock.lock(from, to);
        try {
            NavigableMap<Number640, Data> tmp = this.backend.subMap(from, to, -1, true);
            for (Number640 key : tmp.keySet()) {
                if (!this.canClaimDomain(key.locationAndDomainKey(), publicKey)) {
                    NavigableMap<Number640, Data> navigableMap = null;
                    return navigableMap;
                }
                if (this.canClaimEntry(key.locationAndDomainAndContentKey(), publicKey)) continue;
                NavigableMap<Number640, Data> navigableMap = null;
                return navigableMap;
            }
            NavigableMap<Number640, Data> result = this.backend.remove(from, to, true);
            for (Map.Entry entry : result.entrySet()) {
                Data data = (Data)entry.getValue();
                if (data.publicKey() != null && !data.publicKey().equals(publicKey)) continue;
                this.backend.removeTimeout((Number640)entry.getKey());
            }
            NavigableMap<Number640, Data> navigableMap = result;
            return navigableMap;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<Number640, Byte> removeReturnStatus(Number640 from, Number640 to, PublicKey publicKey) {
        RangeLock.Range lock = this.rangeLock.lock(from, to);
        try {
            NavigableMap<Number640, Data> tmp = this.backend.subMap(from, to, -1, true);
            TreeMap<Number640, Byte> result = new TreeMap<Number640, Byte>();
            for (Number640 key : tmp.keySet()) {
                Pair<Data, Enum<?>> pair = this.remove(key, publicKey, false);
                result.put(key, (byte)((Enum)pair.element1()).ordinal());
            }
            TreeMap<Number640, Byte> treeMap = result;
            return treeMap;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTimeout() {
        long time = System.currentTimeMillis();
        Collection<Number640> toRemove = this.backend.subMapTimeout(time);
        for (Number640 key : toRemove) {
            RangeLock.Range lock = this.lock(key);
            try {
                this.backend.remove(key, false);
                this.backend.removeTimeout(key);
                Number160 locationKey = key.locationKey();
                RangeLock.Range lockResp = this.lockResponsibility(locationKey);
                try {
                    if (!this.isEmpty(locationKey)) continue;
                    this.backend.removeResponsibility(locationKey);
                }
                finally {
                    lockResp.unlock();
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private boolean isEmpty(Number160 locationKey) {
        Number640 from = new Number640(locationKey, Number160.ZERO, Number160.ZERO, Number160.ZERO);
        Number640 to = new Number640(locationKey, Number160.MAX_VALUE, Number160.MAX_VALUE, Number160.MAX_VALUE);
        NavigableMap<Number640, Data> tmp = this.backend.subMap(from, to, 1, false);
        return tmp.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigestInfo digest(Number640 from, Number640 to, int limit, boolean ascending) {
        DigestInfo digestInfo = new DigestInfo();
        RangeLock.Range lock = this.rangeLock.lock(from, to);
        try {
            NavigableMap<Number640, Data> tmp = this.backend.subMap(from, to, limit, ascending);
            for (Map.Entry entry : tmp.entrySet()) {
                if (((Data)entry.getValue()).hasPrepareFlag()) continue;
                digestInfo.put((Number640)entry.getKey(), (Collection)((Data)entry.getValue()).basedOnSet());
            }
            DigestInfo digestInfo2 = digestInfo;
            return digestInfo2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigestInfo digest(Number320 locationAndDomainKey, SimpleBloomFilter<Number160> keyBloomFilter, SimpleBloomFilter<Number160> contentBloomFilter, int limit, boolean ascending, boolean isBloomFilterAnd) {
        DigestInfo digestInfo = new DigestInfo();
        RangeLock.Range lock = this.lock(locationAndDomainKey);
        try {
            Number640 from = new Number640(locationAndDomainKey, Number160.ZERO, Number160.ZERO);
            Number640 to = new Number640(locationAndDomainKey, Number160.MAX_VALUE, Number160.MAX_VALUE);
            NavigableMap<Number640, Data> tmp = this.backend.subMap(from, to, limit, ascending);
            for (Map.Entry entry : tmp.entrySet()) {
                if (isBloomFilterAnd) {
                    if (keyBloomFilter != null && !keyBloomFilter.contains((Object)((Number640)entry.getKey()).contentKey()) || contentBloomFilter != null && !contentBloomFilter.contains((Object)((Data)entry.getValue()).hash()) || ((Data)entry.getValue()).hasPrepareFlag()) continue;
                    digestInfo.put((Number640)entry.getKey(), (Collection)((Data)entry.getValue()).basedOnSet());
                    continue;
                }
                if (keyBloomFilter != null && keyBloomFilter.contains((Object)((Number640)entry.getKey()).contentKey()) || contentBloomFilter != null && contentBloomFilter.contains((Object)((Data)entry.getValue()).hash()) || ((Data)entry.getValue()).hasPrepareFlag()) continue;
                digestInfo.put((Number640)entry.getKey(), (Collection)((Data)entry.getValue()).basedOnSet());
            }
            DigestInfo digestInfo2 = digestInfo;
            return digestInfo2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigestInfo digest(Collection<Number640> number640s) {
        DigestInfo digestInfo = new DigestInfo();
        for (Number640 number640 : number640s) {
            RangeLock.Range lock = this.lock(number640);
            try {
                Data data;
                if (!this.backend.contains(number640) || (data = this.getInternal(number640)) == null) continue;
                digestInfo.put(number640, (Collection)data.basedOnSet());
            }
            finally {
                lock.unlock();
            }
        }
        return digestInfo;
    }

    private boolean securityDomainCheck(Number320 key, PublicKey publicKey, PublicKey newPublicKey, boolean domainProtection) {
        boolean domainProtectedByOthers = this.backend.isDomainProtectedByOthers(key, publicKey);
        if (!domainProtection) {
            LOG.debug("no domain protection requested {} for domain {}", (Object)Utils.hash((PublicKey)newPublicKey), (Object)key);
            return !domainProtectedByOthers;
        }
        LOG.debug("domain protection requested {} for domain {}", (Object)Utils.hash((PublicKey)newPublicKey), (Object)key);
        if (this.canClaimDomain(key, publicKey)) {
            if (this.canProtectDomain(key.domainKey(), publicKey)) {
                LOG.debug("set domain protection");
                return this.backend.protectDomain(key, newPublicKey);
            }
            return true;
        }
        return false;
    }

    private boolean securityEntryCheck(Number480 key, PublicKey publicKeyMessage, PublicKey publicKeyData, boolean entryProtection) {
        boolean entryProtectedByOthers = this.backend.isEntryProtectedByOthers(key, publicKeyMessage);
        if (!entryProtection) {
            return !entryProtectedByOthers;
        }
        if (this.canClaimEntry(key, publicKeyMessage) || this.canClaimEntry(key, publicKeyData)) {
            if (this.canProtectEntry(key.domainKey(), publicKeyMessage)) {
                return this.backend.protectEntry(key, publicKeyData);
            }
            return true;
        }
        return false;
    }

    private boolean foreceOverrideDomain(Number160 domainKey, PublicKey publicKey) {
        if (this.protectionDomainMode() == ProtectionMode.MASTER_PUBLIC_KEY && publicKey != null) {
            return StorageLayer.isMine(domainKey, publicKey);
        }
        return false;
    }

    private boolean foreceOverrideEntry(Number160 entryKey, PublicKey publicKey) {
        if (this.protectionEntryMode() == ProtectionMode.MASTER_PUBLIC_KEY && publicKey != null && publicKey.getEncoded() != null) {
            return StorageLayer.isMine(entryKey, publicKey);
        }
        return false;
    }

    private boolean canClaimDomain(Number320 key, PublicKey publicKey) {
        boolean domainProtectedByOthers = this.backend.isDomainProtectedByOthers(key, publicKey);
        boolean domainOverridableByMe = this.foreceOverrideDomain(key.domainKey(), publicKey);
        return !domainProtectedByOthers || domainOverridableByMe;
    }

    private boolean canClaimEntry(Number480 key, PublicKey publicKey) {
        boolean entryProtectedByOthers = this.backend.isEntryProtectedByOthers(key, publicKey);
        boolean entryOverridableByMe = this.foreceOverrideEntry(key.contentKey(), publicKey);
        return !entryProtectedByOthers || entryOverridableByMe;
    }

    private boolean canProtectDomain(Number160 domainKey, PublicKey publicKey) {
        if (this.isDomainRemoved(domainKey)) {
            return false;
        }
        if (this.protectionDomainEnable() == ProtectionEnable.ALL) {
            return true;
        }
        if (this.protectionDomainEnable() == ProtectionEnable.NONE) {
            return this.foreceOverrideDomain(domainKey, publicKey);
        }
        return false;
    }

    private boolean canProtectEntry(Number160 contentKey, PublicKey publicKey) {
        if (this.protectionEntryEnable() == ProtectionEnable.ALL) {
            return true;
        }
        if (this.protectionEntryEnable() == ProtectionEnable.NONE) {
            return this.foreceOverrideEntry(contentKey, publicKey);
        }
        return false;
    }

    private static boolean isMine(Number160 key, PublicKey publicKey) {
        return key.equals((Object)Utils.makeSHAHash((byte[])publicKey.getEncoded()));
    }

    public RangeLock<Number640> rangeLock() {
        return this.rangeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Number160> findContentForResponsiblePeerID(Number160 peerID) {
        RangeLock.Range lockResp = this.lockResponsibility(peerID);
        try {
            Collection<Number160> contentIDs = this.backend.findContentForResponsiblePeerID(peerID);
            if (contentIDs == null) {
                List<Number160> list = Collections.emptyList();
                return list;
            }
            ArrayList<Number160> arrayList = new ArrayList<Number160>(contentIDs);
            return arrayList;
        }
        finally {
            lockResp.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number160 findPeerIDsForResponsibleContent(Number160 locationKey) {
        RangeLock.Range lockResp = this.lockResponsibility(locationKey);
        try {
            Number160 number160 = this.backend.findPeerIDsForResponsibleContent(locationKey);
            return number160;
        }
        finally {
            lockResp.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateResponsibilities(Number160 locationKey, Number160 peerId) {
        RangeLock.Range lockResp1 = this.lockResponsibility(peerId);
        RangeLock.Range lockResp2 = this.lockResponsibility(locationKey);
        try {
            boolean bl = this.backend.updateResponsibilities(locationKey, peerId);
            return bl;
        }
        finally {
            lockResp1.unlock();
            lockResp2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResponsibility(Number160 locationKey, boolean keepData) {
        RangeLock.Range lockResp = this.lockResponsibility(locationKey);
        try {
            if (!keepData) {
                RangeLock.Range lock = this.lock(locationKey);
                try {
                    NavigableMap<Number640, Data> removed = this.backend.remove(new Number640(locationKey, Number160.ZERO, Number160.ZERO, Number160.ZERO), new Number640(locationKey, Number160.MAX_VALUE, Number160.MAX_VALUE, Number160.MAX_VALUE), false);
                    for (Number640 rem : removed.keySet()) {
                        this.backend.removeTimeout(rem);
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            this.backend.removeResponsibility(locationKey);
        }
        finally {
            lockResp.unlock();
        }
    }

    public void start(ScheduledExecutorService timer, int storageIntervalMillis) {
        timer.scheduleAtFixedRate(new StorageMaintenanceTask(), storageIntervalMillis, storageIntervalMillis, TimeUnit.MILLISECONDS);
    }

    public Enum<?> updateMeta(Number320 locationAndDomainKey, PublicKey publicKey, PublicKey newPublicKey) {
        if (!this.securityDomainCheck(locationAndDomainKey, publicKey, newPublicKey, true)) {
            return PutStatus.FAILED_SECURITY;
        }
        return PutStatus.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enum<?> updateMeta(PublicKey publicKey, Number640 key, Data newData) {
        RangeLock.Range lock = this.lock(key);
        try {
            if (!this.securityEntryCheck(key.locationAndDomainAndContentKey(), publicKey, newData.publicKey(), newData.isProtectedEntry())) {
                PutStatus putStatus = PutStatus.FAILED_SECURITY;
                return putStatus;
            }
            Data data = this.backend.get(key);
            boolean changed = false;
            if (data != null && newData.publicKey() != null) {
                data.publicKey(newData.publicKey());
                changed = true;
            }
            if (data != null && newData.isSigned()) {
                data.signature(newData.signature());
                changed = true;
            }
            if (data != null) {
                data.validFromMillis(newData.validFromMillis());
                data.ttlSeconds(newData.ttlSeconds());
                changed = true;
            }
            if (changed) {
                long expiration = data.expirationMillis();
                this.backend.addTimeout(key, expiration);
                this.backend.put(key, data);
                PutStatus putStatus = PutStatus.OK;
                return putStatus;
            }
            PutStatus putStatus = PutStatus.NOT_FOUND;
            return putStatus;
        }
        finally {
            lock.unlock();
        }
    }

    public int storageCheckIntervalMillis() {
        return this.backend.storageCheckIntervalMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enum<?> putConfirm(PublicKey publicKey, Number640 key, Data newData) {
        RangeLock.Range lock = this.lock(key);
        try {
            if (!this.securityEntryCheck(key.locationAndDomainAndContentKey(), publicKey, newData.publicKey(), newData.isProtectedEntry())) {
                PutStatus putStatus = PutStatus.FAILED_SECURITY;
                return putStatus;
            }
            Data data = this.backend.get(key);
            if (data != null) {
                data.prepareFlag(false);
                data.validFromMillis(newData.validFromMillis());
                data.ttlSeconds(newData.ttlSeconds());
                long expiration = data.expirationMillis();
                this.backend.addTimeout(key, expiration);
                this.backend.put(key, data);
                PutStatus putStatus = PutStatus.OK;
                return putStatus;
            }
            PutStatus putStatus = PutStatus.NOT_FOUND;
            return putStatus;
        }
        finally {
            lock.unlock();
        }
    }

    private class StorageMaintenanceTask
    implements Runnable {
        private StorageMaintenanceTask() {
        }

        @Override
        public void run() {
            StorageLayer.this.checkTimeout();
        }
    }

    public static enum PutStatus {
        OK,
        OK_PREPARED,
        OK_UNCHANGED,
        FAILED_NOT_ABSENT,
        FAILED_SECURITY,
        FAILED,
        VERSION_FORK,
        NOT_FOUND,
        DELETED;

    }

    public static enum ProtectionMode {
        NO_MASTER,
        MASTER_PUBLIC_KEY;

    }

    public static enum ProtectionEnable {
        ALL,
        NONE;

    }
}

