/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import net.tomp2p.connection.PeerBean;
import net.tomp2p.dht.AddBuilder;
import net.tomp2p.dht.DigestBuilder;
import net.tomp2p.dht.DistributedHashTable;
import net.tomp2p.dht.GetBuilder;
import net.tomp2p.dht.ParallelRequestBuilder;
import net.tomp2p.dht.PutBuilder;
import net.tomp2p.dht.RemoveBuilder;
import net.tomp2p.dht.SendBuilder;
import net.tomp2p.dht.StorageLayer;
import net.tomp2p.dht.StorageRPC;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;

public class PeerDHT {
    private final Peer peer;
    private final StorageRPC storageRPC;
    private final DistributedHashTable dht;
    private final StorageLayer storageLayer;

    PeerDHT(Peer peer, StorageLayer storageLayer, DistributedHashTable dht, StorageRPC storageRPC) {
        this.peer = peer;
        this.storageLayer = storageLayer;
        this.dht = dht;
        this.storageRPC = storageRPC;
    }

    public Peer peer() {
        return this.peer;
    }

    public StorageRPC storeRPC() {
        return this.storageRPC;
    }

    public DistributedHashTable distributedHashTable() {
        return this.dht;
    }

    public StorageLayer storageLayer() {
        return this.storageLayer;
    }

    public AddBuilder add(Number160 locationKey) {
        return new AddBuilder(this, locationKey);
    }

    public PutBuilder put(Number160 locationKey) {
        return new PutBuilder(this, locationKey);
    }

    public GetBuilder get(Number160 locationKey) {
        return new GetBuilder(this, locationKey);
    }

    public DigestBuilder digest(Number160 locationKey) {
        return new DigestBuilder(this, locationKey);
    }

    public RemoveBuilder remove(Number160 locationKey) {
        return new RemoveBuilder(this, locationKey);
    }

    public SendBuilder send(Number160 locationKey) {
        return new SendBuilder(this, locationKey);
    }

    public ParallelRequestBuilder<?> parallelRequest(Number160 locationKey) {
        return new ParallelRequestBuilder(this, locationKey);
    }

    public BaseFuture shutdown() {
        return this.peer.shutdown();
    }

    public PeerBean peerBean() {
        return this.peer.peerBean();
    }

    public Number160 peerID() {
        return this.peer.peerID();
    }

    public PeerAddress peerAddress() {
        return this.peer.peerAddress();
    }
}

