/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.tomp2p.dht.DHTBuilder;
import net.tomp2p.dht.EvaluatingSchemeDHT;
import net.tomp2p.dht.FutureDHT;
import net.tomp2p.dht.StorageLayer;
import net.tomp2p.dht.VotingSchemeDHT;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;

public class FutureRemove
extends FutureDHT<FutureRemove> {
    private final EvaluatingSchemeDHT evaluationScheme;
    private Map<PeerAddress, Map<Number640, Byte>> rawKeys640;
    private Map<PeerAddress, Map<Number640, Data>> rawData;
    private Map<Number640, Integer> result;

    public FutureRemove(DHTBuilder<?> builder) {
        this(builder, new VotingSchemeDHT());
    }

    public FutureRemove(DHTBuilder<?> builder, EvaluatingSchemeDHT evaluationScheme) {
        super(builder);
        this.evaluationScheme = evaluationScheme;
        this.self((BaseFuture)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storedKeys(Map<PeerAddress, Map<Number640, Byte>> rawKeys640, FutureDone<Void> futuresCompleted) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.completedAndNotify()) {
                return;
            }
            this.rawKeys640 = rawKeys640;
            this.futuresCompleted = futuresCompleted;
            int size = rawKeys640 == null ? 0 : rawKeys640.size();
            this.type = size > 0 ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = size > 0 ? "Minimum number of results reached" : "Expected > 0 result, but got " + size;
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double avgStoredKeys() {
        Object object = this.lock;
        synchronized (object) {
            int size = this.rawKeys640.size();
            int total = 0;
            for (Map<Number640, Byte> map : this.rawKeys640.values()) {
                if (map == null) continue;
                total += map.size();
            }
            return (double)total / (double)size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedData(Map<PeerAddress, Map<Number640, Data>> rawData, FutureDone<Void> futuresCompleted) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.completedAndNotify()) {
                return;
            }
            this.rawData = rawData;
            this.futuresCompleted = futuresCompleted;
            int size = rawData.size();
            this.type = size > 0 ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = size > 0 ? "Minimum number of results reached" : "Expected >0 result, but got " + size;
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Map<Number640, Byte>> rawKeys() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawKeys640;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Number640> evalKeys() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate6(this.rawKeys640);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Map<Number640, Data>> rawData() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Number640, Data> dataMap() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate2(this.rawData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Number640, Integer> result() {
        Object object = this.lock;
        synchronized (object) {
            if (this.result == null) {
                if (this.rawKeys640 != null) {
                    this.result = this.evaluate0(this.rawKeys640);
                } else if (this.rawData != null) {
                    this.result = this.evaluate1(this.rawData);
                } else {
                    return Collections.emptyMap();
                }
            }
            return this.result;
        }
    }

    private Map<Number640, Integer> evaluate0(Map<PeerAddress, Map<Number640, Byte>> rawResult2) {
        HashMap<Number640, Integer> result = new HashMap<Number640, Integer>();
        for (Map<Number640, Byte> map : rawResult2.values()) {
            for (Map.Entry<Number640, Byte> entry : map.entrySet()) {
                if (entry.getValue().intValue() != StorageLayer.PutStatus.OK.ordinal()) continue;
                Integer integer = (Integer)result.get(entry.getKey());
                if (integer == null) {
                    result.put(entry.getKey(), 1);
                    continue;
                }
                result.put(entry.getKey(), integer + 1);
            }
        }
        return result;
    }

    private Map<Number640, Integer> evaluate1(Map<PeerAddress, Map<Number640, Data>> rawData) {
        HashMap<Number640, Integer> result = new HashMap<Number640, Integer>();
        for (Map<Number640, Data> map : rawData.values()) {
            for (Map.Entry<Number640, Data> entry : map.entrySet()) {
                Integer integer = (Integer)result.get(entry.getKey());
                if (integer == null) {
                    result.put(entry.getKey(), 1);
                    continue;
                }
                result.put(entry.getKey(), integer + 1);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRemoved() {
        Object object = this.lock;
        synchronized (object) {
            if (this.rawKeys640 != null) {
                return this.checkAtLeastOneSuccess();
            }
            if (this.rawData != null) {
                return this.checkAtLeastOneSuccessData();
            }
        }
        return false;
    }

    private boolean checkAtLeastOneSuccess() {
        for (Map.Entry<PeerAddress, Map<Number640, Byte>> entry : this.rawKeys640.entrySet()) {
            for (Map.Entry<Number640, Byte> entry2 : entry.getValue().entrySet()) {
                if (entry2.getValue().byteValue() != StorageLayer.PutStatus.OK.ordinal()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkAtLeastOneSuccessData() {
        for (Map.Entry<PeerAddress, Map<Number640, Data>> entry : this.rawData.entrySet()) {
            for (Map.Entry<Number640, Data> entry2 : entry.getValue().entrySet()) {
                if (entry2.getValue() == null || entry2.getValue().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

