/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.tomp2p.dht.DHTBuilder;
import net.tomp2p.dht.FuturePut;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.Data;

public class AddBuilder
extends DHTBuilder<AddBuilder> {
    private static final FuturePut FUTURE_SHUTDOWN = (FuturePut)new FuturePut(null, 0, 0).failed("add builder - peer is shutting down");
    private Collection<Data> dataSet;
    private Data data;
    private boolean list = false;
    private Random rnd;

    public AddBuilder(PeerDHT peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    public Collection<Data> dataSet() {
        return this.dataSet;
    }

    public AddBuilder dataSet(Collection<Data> dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    public Data data() {
        return this.data;
    }

    public AddBuilder data(Data data) {
        this.data = data;
        return this;
    }

    public AddBuilder object(Object object) throws IOException {
        return this.data(new Data(object));
    }

    public boolean isList() {
        return this.list;
    }

    public AddBuilder list(boolean list) {
        this.list = list;
        return this;
    }

    public AddBuilder list() {
        this.list = true;
        return this;
    }

    public AddBuilder random(Random rnd) {
        this.rnd = rnd;
        return this;
    }

    public Random random() {
        return this.rnd;
    }

    public FuturePut start() {
        if (this.peer.peer().isShutdown()) {
            return FUTURE_SHUTDOWN;
        }
        this.preBuild("add-builder");
        if (this.dataSet == null) {
            this.dataSet = new ArrayList<Data>(1);
        }
        if (this.data != null) {
            this.dataSet.add(this.data);
        }
        if (this.dataSet.size() == 0) {
            throw new IllegalArgumentException("You must either set data via setDataMap() or setData(). Cannot add nothing.");
        }
        if (this.rnd == null) {
            this.rnd = new Random();
        }
        return this.peer.distributedHashTable().add(this);
    }
}

