/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import net.tomp2p.dht.DHTBuilder;
import net.tomp2p.dht.FutureSend;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.futures.ProgressListener;
import net.tomp2p.message.Buffer;
import net.tomp2p.peers.Number160;
import net.tomp2p.rpc.SendDirectBuilderI;

public class SendBuilder
extends DHTBuilder<SendBuilder>
implements SendDirectBuilderI {
    private static final FutureSend FUTURE_SHUTDOWN = (FutureSend)new FutureSend(null).failed("send builder - peer is shutting down");
    private Buffer buffer;
    private Object object;
    private boolean cancelOnFinish = false;
    private boolean streaming = false;
    private ProgressListener progressListener;

    public SendBuilder(PeerDHT peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    public Buffer buffer() {
        return this.buffer;
    }

    public SendBuilder buffer(Buffer buffer) {
        this.buffer = buffer;
        return this;
    }

    public Object object() {
        return this.object;
    }

    public SendBuilder object(Object object) {
        this.object = object;
        return this;
    }

    public boolean isCancelOnFinish() {
        return this.cancelOnFinish;
    }

    public SendBuilder cancelOnFinish(boolean cancelOnFinish) {
        this.cancelOnFinish = cancelOnFinish;
        return this;
    }

    public SendBuilder cancelOnFinish() {
        this.cancelOnFinish = true;
        return this;
    }

    public boolean isRaw() {
        return this.object == null;
    }

    @Override
    public SendBuilder streaming(boolean streaming) {
        this.streaming = streaming;
        return this;
    }

    @Override
    public boolean isStreaming() {
        return this.streaming;
    }

    @Override
    public SendBuilder streaming() {
        this.streaming = true;
        return this;
    }

    public FutureSend start() {
        if (this.peer.peer().isShutdown()) {
            return FUTURE_SHUTDOWN;
        }
        this.preBuild("send-builder");
        return this.peer.distributedHashTable().direct(this);
    }

    public SendBuilder progressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    public ProgressListener progressListener() {
        return this.progressListener;
    }
}

