/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import net.tomp2p.dht.DistributedHashTable;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.dht.StorageLayer;
import net.tomp2p.dht.StorageMemory;
import net.tomp2p.dht.StorageRPC;
import net.tomp2p.p2p.Peer;
import net.tomp2p.storage.DigestStorage;
import net.tomp2p.storage.Storage;

public class PeerBuilderDHT {
    private final Peer peer;
    private StorageRPC storageRPC;
    private DistributedHashTable dht;
    private StorageLayer storageLayer;
    private Storage storage;

    public PeerBuilderDHT(Peer peer) {
        this.peer = peer;
    }

    public Peer peer() {
        return this.peer;
    }

    public StorageRPC storeRPC() {
        return this.storageRPC;
    }

    public PeerBuilderDHT storeRPC(StorageRPC storeRPC) {
        this.storageRPC = storeRPC;
        return this;
    }

    public DistributedHashTable distributedHashTable() {
        return this.dht;
    }

    public PeerBuilderDHT distributedHashTable(DistributedHashTable dht) {
        this.dht = dht;
        return this;
    }

    public StorageLayer storageLayer() {
        return this.storageLayer;
    }

    public PeerBuilderDHT storageLayer(StorageLayer storageLayer) {
        this.storageLayer = storageLayer;
        return this;
    }

    public Storage storage() {
        return this.storage;
    }

    public PeerBuilderDHT storage(Storage storage) {
        this.storage = storage;
        return this;
    }

    public PeerDHT start() {
        if (this.storage == null) {
            this.storage = new StorageMemory();
        }
        if (this.storageLayer == null) {
            this.storageLayer = new StorageLayer(this.storage);
            this.storageLayer.start(this.peer.connectionBean().timer(), this.storageLayer.storageCheckIntervalMillis());
        }
        if (this.peer.peerBean().digestStorage() == null) {
            this.peer.peerBean().digestStorage((DigestStorage)this.storageLayer);
        }
        if (this.storageRPC == null) {
            this.storageRPC = new StorageRPC(this.peer.peerBean(), this.peer.connectionBean(), this.storageLayer);
        }
        if (this.dht == null) {
            this.dht = new DistributedHashTable(this.peer.distributedRouting(), this.storageRPC, this.peer.directDataRPC());
        }
        return new PeerDHT(this.peer, this.storageLayer, this.dht, this.storageRPC);
    }
}

