/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import java.util.ArrayList;
import java.util.Collection;
import net.tomp2p.dht.DHTBuilder;
import net.tomp2p.dht.FutureGet;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.p2p.EvaluatingSchemeDHT;
import net.tomp2p.p2p.VotingSchemeDHT;
import net.tomp2p.p2p.builder.SearchableBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.rpc.SimpleBloomFilter;

public class GetBuilder
extends DHTBuilder<GetBuilder>
implements SearchableBuilder {
    private static final FutureGet FUTURE_SHUTDOWN = (FutureGet)new FutureGet(null).failed("get builder - peer is shutting down");
    private static final Collection<Number160> NUMBER_ZERO_CONTENT_KEYS = new ArrayList<Number160>(1);
    private Collection<Number160> contentKeys;
    private Collection<Number640> keys;
    private Number160 contentKey;
    private SimpleBloomFilter<Number160> keyBloomFilter;
    private SimpleBloomFilter<Number160> contentBloomFilter;
    private EvaluatingSchemeDHT evaluationScheme;
    private Number640 from;
    private Number640 to;
    private boolean isGetLatest = false;
    private boolean withDigest = false;
    private boolean all = false;
    private boolean returnBloomFilter = false;
    private boolean ascending = true;
    private boolean bloomFilterAnd = true;
    private int returnNr = -1;

    public GetBuilder(PeerDHT peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    public Collection<Number160> contentKeys() {
        return this.contentKeys;
    }

    public GetBuilder contentKeys(Collection<Number160> contentKeys) {
        this.contentKeys = contentKeys;
        return this;
    }

    public Collection<Number640> keys() {
        return this.keys;
    }

    public GetBuilder key(Collection<Number640> keys) {
        this.keys = keys;
        return this;
    }

    public Number160 contentKey() {
        return this.contentKey;
    }

    public GetBuilder contentKey(Number160 contentKey) {
        this.contentKey = contentKey;
        return this;
    }

    public SimpleBloomFilter<Number160> keyBloomFilter() {
        return this.keyBloomFilter;
    }

    public GetBuilder keyBloomFilter(SimpleBloomFilter<Number160> keyBloomFilter) {
        this.keyBloomFilter = keyBloomFilter;
        return this;
    }

    public SimpleBloomFilter<Number160> contentBloomFilter() {
        return this.contentBloomFilter;
    }

    public GetBuilder contentBloomFilter(SimpleBloomFilter<Number160> contentBloomFilter) {
        this.contentBloomFilter = contentBloomFilter;
        return this;
    }

    public EvaluatingSchemeDHT evaluationScheme() {
        return this.evaluationScheme;
    }

    public GetBuilder evaluationScheme(EvaluatingSchemeDHT evaluationScheme) {
        this.evaluationScheme = evaluationScheme;
        return this;
    }

    public boolean isAll() {
        return this.all;
    }

    public GetBuilder all(boolean all) {
        this.all = all;
        return this;
    }

    public GetBuilder all() {
        this.all = true;
        return this;
    }

    public boolean isGetLatest() {
        return this.isGetLatest;
    }

    public GetBuilder getLates(boolean getLatest) {
        this.isGetLatest = getLatest;
        return this;
    }

    public GetBuilder getLatest() {
        this.isGetLatest = true;
        return this;
    }

    public boolean isWithDigest() {
        return this.withDigest;
    }

    public GetBuilder withDigest(boolean withDigest) {
        this.withDigest = withDigest;
        return this;
    }

    public GetBuilder withDigest() {
        this.withDigest = true;
        return this;
    }

    public boolean isReturnBloomFilter() {
        return this.returnBloomFilter;
    }

    public GetBuilder returnBloomFilter(boolean returnBloomFilter) {
        this.returnBloomFilter = returnBloomFilter;
        return this;
    }

    public GetBuilder returnBloomFilter() {
        this.returnBloomFilter = true;
        return this;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public GetBuilder ascending(boolean ascending) {
        this.ascending = ascending;
        return this;
    }

    public GetBuilder ascending() {
        this.ascending = true;
        return this;
    }

    public boolean isDescending() {
        return !this.ascending;
    }

    public GetBuilder descending() {
        this.ascending = false;
        return this;
    }

    public boolean isBloomFilterAnd() {
        return this.bloomFilterAnd;
    }

    public GetBuilder bloomFilterAnd(boolean bloomFilterAnd) {
        this.bloomFilterAnd = bloomFilterAnd;
        return this;
    }

    public GetBuilder bloomFilterAnd() {
        this.bloomFilterAnd = true;
        return this;
    }

    public boolean isBloomFilterIntersect() {
        return !this.bloomFilterAnd;
    }

    public GetBuilder bloomFilterIntersect() {
        this.bloomFilterAnd = false;
        return this;
    }

    public GetBuilder returnNr(int returnNr) {
        this.returnNr = returnNr;
        return this;
    }

    public int returnNr() {
        return this.returnNr;
    }

    public GetBuilder from(Number640 from) {
        this.from = from;
        return this;
    }

    public Number640 from() {
        return this.from;
    }

    public GetBuilder to(Number640 to) {
        this.to = to;
        return this;
    }

    public Number640 to() {
        return this.to;
    }

    public boolean isRange() {
        return this.from != null && this.to != null;
    }

    public FutureGet start() {
        if (this.peer.peer().isShutdown()) {
            return FUTURE_SHUTDOWN;
        }
        this.preBuild("get-builder");
        if (this.all) {
            this.contentKeys = null;
        } else if (this.contentKeys == null && !this.all) {
            if (this.contentKey == null) {
                this.contentKeys = NUMBER_ZERO_CONTENT_KEYS;
            } else {
                this.contentKeys = new ArrayList<Number160>(1);
                this.contentKeys.add(this.contentKey);
            }
        }
        if (this.evaluationScheme == null) {
            this.evaluationScheme = new VotingSchemeDHT();
        }
        if (this.isGetLatest && this.contentKey == null) {
            throw new IllegalArgumentException("Content key must be set.");
        }
        return this.peer.distributedHashTable().get(this);
    }

    static {
        NUMBER_ZERO_CONTENT_KEYS.add(Number160.ZERO);
    }
}

