/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.ArrayList;
import java.util.List;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.p2p.PeerReachable;
import net.tomp2p.p2p.PeerReceivedBroadcastPing;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PingRPC.class);
    public static final int WAIT_TIME = 10000;
    private final List<PeerReachable> reachableListeners = new ArrayList<PeerReachable>(1);
    private final List<PeerReceivedBroadcastPing> receivedBroadcastPingListeners = new ArrayList<PeerReceivedBroadcastPing>(1);
    private final boolean enable;
    private final boolean wait;

    public PingRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        this(peerBean, connectionBean, true, true, false);
    }

    PingRPC(PeerBean peerBean, ConnectionBean connectionBean, boolean enable, boolean register, boolean wait) {
        super(peerBean, connectionBean);
        this.enable = enable;
        this.wait = wait;
        if (register) {
            connectionBean.dispatcher().registerIoHandler(peerBean.serverPeerAddress().peerId(), peerBean.serverPeerAddress().peerId(), this, RPC.Commands.PING.getNr());
        }
    }

    public RequestHandler<FutureResponse> ping(PeerAddress remotePeer, ConnectionConfiguration configuration) {
        return this.createHandler(remotePeer, Message.Type.REQUEST_1, configuration);
    }

    public FutureResponse pingUDP(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        LOG.debug("Pinging UDP the remote peer {}.", (Object)remotePeer);
        return this.ping(remotePeer, configuration).sendUDP(channelCreator);
    }

    public FutureResponse pingBroadcastUDP(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        return this.createHandler(remotePeer, Message.Type.REQUEST_4, configuration).sendBroadcastUDP(channelCreator);
    }

    public FutureResponse pingTCP(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        LOG.debug("ping the remote peer {}", (Object)remotePeer);
        return this.ping(remotePeer, configuration).sendTCP(channelCreator);
    }

    public FutureResponse fireUDP(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        return this.createHandler(remotePeer, Message.Type.REQUEST_FF_1, configuration).fireAndForgetUDP(channelCreator);
    }

    public FutureResponse fireTCP(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        return this.createHandler(remotePeer, Message.Type.REQUEST_FF_1, configuration).sendTCP(channelCreator);
    }

    public FutureResponse pingUDPDiscover(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        FutureResponse futureResponse = this.createDiscoverHandler(remotePeer);
        return new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration).sendUDP(channelCreator);
    }

    public FutureResponse pingTCPDiscover(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        FutureResponse futureResponse = this.createDiscoverHandler(remotePeer);
        return new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration).sendTCP(channelCreator);
    }

    public FutureResponse pingUDPProbe(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        Message message = this.createMessage(remotePeer, RPC.Commands.PING.getNr(), Message.Type.REQUEST_3);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration).sendUDP(channelCreator);
    }

    public FutureResponse pingTCPProbe(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        Message message = this.createMessage(remotePeer, RPC.Commands.PING.getNr(), Message.Type.REQUEST_3);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration).sendTCP(channelCreator);
    }

    private RequestHandler<FutureResponse> createHandler(PeerAddress remotePeer, Message.Type type, ConnectionConfiguration configuration) {
        Message message = this.createMessage(remotePeer, RPC.Commands.PING.getNr(), type);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration);
    }

    private FutureResponse createDiscoverHandler(PeerAddress remotePeer) {
        Message message = this.createMessage(remotePeer, RPC.Commands.PING.getNr(), Message.Type.REQUEST_2);
        message.neighborsSet(this.createNeighborSet(this.peerBean().serverPeerAddress()));
        return new FutureResponse(message);
    }

    private NeighborSet createNeighborSet(PeerAddress ... self) {
        ArrayList<PeerAddress> tmp = new ArrayList<PeerAddress>(self.length);
        for (int i = 0; i < self.length; ++i) {
            tmp.add(self[i]);
        }
        return new NeighborSet(-1, tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleResponse(final Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        Message responseMessage;
        if (message.type() != Message.Type.REQUEST_FF_1 && message.type() != Message.Type.REQUEST_1 && message.type() != Message.Type.REQUEST_2 && message.type() != Message.Type.REQUEST_3 && message.type() != Message.Type.REQUEST_4 || message.command() != RPC.Commands.PING.getNr()) {
            throw new IllegalArgumentException("Request message type or command is wrong for this handler.");
        }
        if (message.type() == Message.Type.REQUEST_3) {
            LOG.debug("Respond to probing. Firing message to {}.", (Object)message.sender());
            responseMessage = this.createResponseMessage(message, Message.Type.OK);
            if (message.isUdp()) {
                this.connectionBean().reservation().create(1, 0).addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                    @Override
                    public void operationComplete(FutureChannelCreator future) throws Exception {
                        if (future.isSuccess()) {
                            LOG.debug("Fire UDP to {}.", (Object)message.sender());
                            FutureResponse futureResponse = PingRPC.this.fireUDP(message.sender(), future.channelCreator(), PingRPC.this.connectionBean().channelServer().channelServerConfiguration());
                            Utils.addReleaseListener(future.channelCreator(), futureResponse);
                        } else {
                            Utils.addReleaseListener(future.channelCreator(), new BaseFuture[0]);
                            LOG.warn("handleResponse for REQUEST_3 failed (UDP) {}", (Object)future.failedReason());
                        }
                    }
                });
            } else {
                this.connectionBean().reservation().create(0, 1).addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                    @Override
                    public void operationComplete(FutureChannelCreator future) throws Exception {
                        if (future.isSuccess()) {
                            LOG.debug("Fire TCP to {}.", (Object)message.sender());
                            FutureResponse futureResponse = PingRPC.this.fireTCP(message.sender(), future.channelCreator(), PingRPC.this.connectionBean().channelServer().channelServerConfiguration());
                            Utils.addReleaseListener(future.channelCreator(), futureResponse);
                        } else {
                            Utils.addReleaseListener(future.channelCreator(), new BaseFuture[0]);
                            LOG.warn("handleResponse for REQUEST_3 failed (TCP) {}", (Object)future.failedReason());
                        }
                    }
                });
            }
        } else if (message.type() == Message.Type.REQUEST_2) {
            LOG.debug("Respond to discovering. Found {}.", (Object)message.sender());
            responseMessage = this.createResponseMessage(message, Message.Type.OK);
            int port = message.senderSocket().getPort();
            responseMessage.neighborsSet(this.createNeighborSet(message.sender()));
            responseMessage.intValue(port);
        } else if (message.type() == Message.Type.REQUEST_1 || message.type() == Message.Type.REQUEST_4) {
            LOG.debug("Respond to regular ping {}.", (Object)message.sender());
            if (message.isUdp() && message.sender().peerId().equals(this.peerBean().serverPeerAddress().peerId()) && message.recipient().peerId().equals(Number160.ZERO)) {
                LOG.warn("Don't respond. We are on the same peer, you should make this call.");
                responder.responseFireAndForget();
            }
            if (this.enable) {
                responseMessage = this.createResponseMessage(message, Message.Type.OK);
                if (this.wait) {
                    Thread.sleep(10000L);
                }
            } else {
                LOG.debug("Don't respond.");
                if (this.wait) {
                    Thread.sleep(10000L);
                }
                return;
            }
            if (message.type() == Message.Type.REQUEST_4) {
                List<PeerReceivedBroadcastPing> port = this.receivedBroadcastPingListeners;
                synchronized (port) {
                    for (PeerReceivedBroadcastPing listener : this.receivedBroadcastPingListeners) {
                        listener.broadcastPingReceived(message.sender());
                    }
                }
            }
        } else {
            PeerAddress serverAddress = this.peerBean().serverPeerAddress();
            if (message.isUdp()) {
                PeerAddress newServerAddress = serverAddress.changeFirewalledUDP(false);
                this.peerBean().serverPeerAddress(newServerAddress);
                List<PeerReachable> list = this.reachableListeners;
                synchronized (list) {
                    for (PeerReachable listener : this.reachableListeners) {
                        listener.peerWellConnected(newServerAddress, message.sender(), false);
                    }
                }
                responseMessage = message;
            } else {
                PeerAddress newServerAddress = serverAddress.changeFirewalledTCP(false);
                this.peerBean().serverPeerAddress(newServerAddress);
                List<PeerReachable> list = this.reachableListeners;
                synchronized (list) {
                    for (PeerReachable listener : this.reachableListeners) {
                        listener.peerWellConnected(newServerAddress, message.sender(), true);
                    }
                }
                responseMessage = this.createResponseMessage(message, Message.Type.OK);
            }
        }
        responder.response(responseMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerReachableListener(PeerReachable peerReachable) {
        List<PeerReachable> list = this.reachableListeners;
        synchronized (list) {
            this.reachableListeners.add(peerReachable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeerReachableListener(PeerReachable peerReachable) {
        List<PeerReachable> list = this.reachableListeners;
        synchronized (list) {
            this.reachableListeners.remove(peerReachable);
        }
    }

    public void addPeerReceivedBroadcastPingListener(PeerReceivedBroadcastPing peerReceivedBroadcastPing) {
        this.receivedBroadcastPingListeners.add(peerReceivedBroadcastPing);
    }

    public void removePeerReceivedBroadcastPingListener(PeerReceivedBroadcastPing peerReceivedBroadcastPing) {
        this.receivedBroadcastPingListeners.remove(peerReceivedBroadcastPing);
    }
}

