/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;
import net.tomp2p.utils.Utils;

public class DigestResult {
    private final SimpleBloomFilter<Number160> contentKeyBloomFilter;
    private final SimpleBloomFilter<Number160> versionKeyBloomFilter;
    private final SimpleBloomFilter<Number160> contentBloomFilter;
    private final NavigableMap<Number640, Collection<Number160>> keyDigest;
    private final Map<Number640, Data> dataMap;

    public DigestResult(SimpleBloomFilter<Number160> contentKeyBloomFilter, SimpleBloomFilter<Number160> versionKeyBloomFilter, SimpleBloomFilter<Number160> contentBloomFilter) {
        this.contentKeyBloomFilter = contentKeyBloomFilter;
        this.versionKeyBloomFilter = versionKeyBloomFilter;
        this.contentBloomFilter = contentBloomFilter;
        this.keyDigest = null;
        this.dataMap = null;
    }

    public DigestResult(NavigableMap<Number640, Collection<Number160>> keyDigest) {
        this.keyDigest = keyDigest;
        this.contentKeyBloomFilter = null;
        this.versionKeyBloomFilter = null;
        this.contentBloomFilter = null;
        this.dataMap = null;
    }

    public DigestResult(Map<Number640, Data> dataMap) {
        this.dataMap = dataMap;
        this.keyDigest = null;
        this.contentKeyBloomFilter = null;
        this.versionKeyBloomFilter = null;
        this.contentBloomFilter = null;
    }

    public SimpleBloomFilter<Number160> contentKeyBloomFilter() {
        return this.contentKeyBloomFilter;
    }

    public SimpleBloomFilter<Number160> versionKeyBloomFilter() {
        return this.versionKeyBloomFilter;
    }

    public SimpleBloomFilter<Number160> contentBloomFilter() {
        return this.contentBloomFilter;
    }

    public NavigableMap<Number640, Collection<Number160>> keyDigest() {
        return this.keyDigest;
    }

    public Map<Number640, Data> dataMap() {
        return this.dataMap;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.keyDigest != null) {
            hashCode ^= this.keyDigest.hashCode();
        }
        if (this.contentKeyBloomFilter != null) {
            hashCode ^= this.contentKeyBloomFilter.hashCode();
        }
        if (this.versionKeyBloomFilter != null) {
            hashCode ^= this.versionKeyBloomFilter.hashCode();
        }
        if (this.contentBloomFilter != null) {
            hashCode ^= this.contentBloomFilter.hashCode();
        }
        if (this.dataMap != null) {
            hashCode ^= this.dataMap.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DigestResult)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DigestResult o = (DigestResult)obj;
        return Utils.equals(this.keyDigest, o.keyDigest) && Utils.equals(this.contentKeyBloomFilter, o.contentKeyBloomFilter) && Utils.equals(this.versionKeyBloomFilter, o.versionKeyBloomFilter) && Utils.equals(this.contentBloomFilter, o.contentBloomFilter) && Utils.equals(this.dataMap, o.dataMap);
    }
}

