/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;

public class DigestInfo {
    private volatile Number160 keyDigest = null;
    private volatile Number160 contentDigest = null;
    private volatile int size = -1;
    private final NavigableMap<Number640, Collection<Number160>> mapDigests = new TreeMap<Number640, Collection<Number160>>();

    public DigestInfo() {
    }

    public DigestInfo(int size) {
        this.size = size;
    }

    public DigestInfo(Number160 keyDigest, Number160 contentDigest, int size) {
        this.keyDigest = keyDigest;
        this.contentDigest = contentDigest;
        this.size = size;
    }

    public Number160 keyDigest() {
        if (this.keyDigest == null) {
            this.process();
        }
        return this.keyDigest;
    }

    public Number160 contentDigest() {
        if (this.contentDigest == null) {
            this.process();
        }
        return this.contentDigest;
    }

    private void process() {
        Number160 hashKey = Number160.ZERO;
        Number160 hashContent = Number160.ZERO;
        for (Map.Entry entry : this.mapDigests.entrySet()) {
            hashKey = hashKey.xor(((Number640)entry.getKey()).locationKey());
            hashKey = hashKey.xor(((Number640)entry.getKey()).domainKey());
            hashKey = hashKey.xor(((Number640)entry.getKey()).contentKey());
            hashKey = hashKey.xor(((Number640)entry.getKey()).versionKey());
            for (Number160 basedOn : (Collection)entry.getValue()) {
                hashContent = hashContent.xor(basedOn);
            }
        }
        this.keyDigest = hashKey;
        this.contentDigest = hashContent;
    }

    public NavigableMap<Number640, Collection<Number160>> mapDigests() {
        return this.mapDigests;
    }

    public void put(Number640 key, Collection<Number160> basedOnSet) {
        this.mapDigests.put(key, basedOnSet);
    }

    public NavigableMap<Number640, Collection<Number160>> digests() {
        return this.mapDigests;
    }

    public int size() {
        if (this.size == -1) {
            this.size = this.mapDigests.size();
        }
        return this.size;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DigestInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DigestInfo other = (DigestInfo)obj;
        return this.keyDigest().equals(other.keyDigest()) && this.size() == other.size() && this.contentDigest().equals(other.contentDigest());
    }

    public int hashCode() {
        return this.keyDigest().hashCode() ^ this.size() ^ this.contentDigest().hashCode();
    }
}

