/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.DataMap;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.BroadcastHandler;
import net.tomp2p.p2p.builder.BroadcastBuilder;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BroadcastRPC.class);
    private final BroadcastHandler broadcastHandler;

    public BroadcastRPC(PeerBean peerBean, ConnectionBean connectionBean, BroadcastHandler broadcastHandler) {
        super(peerBean, connectionBean);
        this.register(RPC.Commands.BROADCAST.getNr());
        this.broadcastHandler = broadcastHandler;
    }

    public FutureResponse send(PeerAddress remotePeer, BroadcastBuilder broadcastBuilder, ChannelCreator channelCreator, ConnectionConfiguration configuration, int bucketNr) {
        Message message = this.createMessage(remotePeer, RPC.Commands.BROADCAST.getNr(), Message.Type.REQUEST_FF_1);
        message.intValue(broadcastBuilder.hopCounter());
        message.intValue(bucketNr);
        message.key(broadcastBuilder.messageKey());
        if (broadcastBuilder.dataMap() != null) {
            message.setDataMap(new DataMap(broadcastBuilder.dataMap()));
        }
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler<FutureResponse> requestHandler = new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration);
        if (!broadcastBuilder.isUDP()) {
            return requestHandler.sendTCP(channelCreator);
        }
        return requestHandler.fireAndForgetUDP(channelCreator);
    }

    @Override
    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        if (message.type() != Message.Type.REQUEST_FF_1 || message.command() != RPC.Commands.BROADCAST.getNr()) {
            throw new IllegalArgumentException("Message content is wrong for this handler.");
        }
        LOG.debug("received BRODACAST message: {}", (Object)message);
        this.broadcastHandler.receive(message);
        if (message.isUdp()) {
            responder.responseFireAndForget();
        } else {
            responder.response(this.createResponseMessage(message, Message.Type.OK));
        }
    }

    public BroadcastHandler broadcastHandler() {
        return this.broadcastHandler;
    }
}

